/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.core.context;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.component.jackson.JacksonDataFormat;
import org.apache.camel.core.osgi.OsgiDefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.unomi.api.services.ConfigSharingService;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.apache.unomi.router.api.ExportConfiguration;
import org.apache.unomi.router.api.IRouterCamelContext;
import org.apache.unomi.router.api.ImportConfiguration;
import org.apache.unomi.router.api.RouterConstants;
import org.apache.unomi.router.api.services.ImportExportConfigurationService;
import org.apache.unomi.router.api.services.ProfileExportService;
import org.apache.unomi.router.core.processor.ExportRouteCompletionProcessor;
import org.apache.unomi.router.core.processor.ImportConfigByFileNameProcessor;
import org.apache.unomi.router.core.processor.ImportRouteCompletionProcessor;
import org.apache.unomi.router.core.processor.UnomiStorageProcessor;
import org.apache.unomi.router.core.route.ProfileExportCollectRouteBuilder;
import org.apache.unomi.router.core.route.ProfileExportProducerRouteBuilder;
import org.apache.unomi.router.core.route.ProfileImportFromSourceRouteBuilder;
import org.apache.unomi.router.core.route.ProfileImportOneShotRouteBuilder;
import org.apache.unomi.router.core.route.ProfileImportToUnomiRouteBuilder;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterCamelContext
implements IRouterCamelContext {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)RouterCamelContext.class.getName());
    private CamelContext camelContext;
    private UnomiStorageProcessor unomiStorageProcessor;
    private ImportRouteCompletionProcessor importRouteCompletionProcessor;
    private ExportRouteCompletionProcessor exportRouteCompletionProcessor;
    private ImportConfigByFileNameProcessor importConfigByFileNameProcessor;
    private ImportExportConfigurationService<ImportConfiguration> importConfigurationService;
    private ImportExportConfigurationService<ExportConfiguration> exportConfigurationService;
    private PersistenceService persistenceService;
    private ProfileService profileService;
    private ProfileExportService profileExportService;
    private JacksonDataFormat jacksonDataFormat;
    private String uploadDir;
    private String execHistorySize;
    private String execErrReportSize;
    private Map<String, String> kafkaProps;
    private String configType;
    private String allowedEndpoints;
    private BundleContext bundleContext;
    private ConfigSharingService configSharingService;
    private ScheduledExecutorService scheduler;
    private Integer configsRefreshInterval = 1000;
    private ScheduledFuture<?> scheduledFuture;
    public static String EVENT_ID_REMOVE = "org.apache.unomi.router.event.remove";
    public static String EVENT_ID_IMPORT = "org.apache.unomi.router.event.import";
    public static String EVENT_ID_EXPORT = "org.apache.unomi.router.event.export";

    public void setExecHistorySize(String execHistorySize) {
        this.execHistorySize = execHistorySize;
    }

    public void setExecErrReportSize(String execErrReportSize) {
        this.execErrReportSize = execErrReportSize;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setConfigSharingService(ConfigSharingService configSharingService) {
        this.configSharingService = configSharingService;
    }

    public void setTracing(boolean tracing) {
        this.camelContext.setTracing(Boolean.valueOf(true));
    }

    public void init() throws Exception {
        LOGGER.info("Initialize Camel Context...");
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.configSharingService.setProperty("oneshotImportUploadDir", (Object)this.uploadDir);
        this.configSharingService.setProperty("historySize", (Object)this.execHistorySize);
        this.initCamel();
        this.initTimers();
        LOGGER.info("Camel Context initialized successfully.");
    }

    public void destroy() throws Exception {
        this.scheduledFuture.cancel(true);
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        this.camelContext.stop();
        LOGGER.info("Camel context for profile import is shutdown.");
    }

    private void initTimers() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    Map importConfigsToRefresh = RouterCamelContext.this.importConfigurationService.consumeConfigsToBeRefresh();
                    Map exportConfigsToRefresh = RouterCamelContext.this.exportConfigurationService.consumeConfigsToBeRefresh();
                    for (Map.Entry importConfigToRefresh : importConfigsToRefresh.entrySet()) {
                        try {
                            if (((RouterConstants.CONFIG_CAMEL_REFRESH)importConfigToRefresh.getValue()).equals((Object)RouterConstants.CONFIG_CAMEL_REFRESH.UPDATED)) {
                                RouterCamelContext.this.updateProfileImportReaderRoute((String)importConfigToRefresh.getKey(), true);
                                continue;
                            }
                            if (!((RouterConstants.CONFIG_CAMEL_REFRESH)importConfigToRefresh.getValue()).equals((Object)RouterConstants.CONFIG_CAMEL_REFRESH.REMOVED)) continue;
                            RouterCamelContext.this.killExistingRoute((String)importConfigToRefresh.getKey(), true);
                        }
                        catch (Exception e) {
                            LOGGER.error("Unexpected error while refreshing({}) camel route: {}", new Object[]{importConfigToRefresh.getValue(), importConfigToRefresh.getKey(), e});
                        }
                    }
                    for (Map.Entry exportConfigToRefresh : exportConfigsToRefresh.entrySet()) {
                        try {
                            if (((RouterConstants.CONFIG_CAMEL_REFRESH)exportConfigToRefresh.getValue()).equals((Object)RouterConstants.CONFIG_CAMEL_REFRESH.UPDATED)) {
                                RouterCamelContext.this.updateProfileExportReaderRoute((String)exportConfigToRefresh.getKey(), true);
                                continue;
                            }
                            if (!((RouterConstants.CONFIG_CAMEL_REFRESH)exportConfigToRefresh.getValue()).equals((Object)RouterConstants.CONFIG_CAMEL_REFRESH.REMOVED)) continue;
                            RouterCamelContext.this.killExistingRoute((String)exportConfigToRefresh.getKey(), true);
                        }
                        catch (Exception e) {
                            LOGGER.error("Unexpected error while refreshing({}) camel route: {}", new Object[]{exportConfigToRefresh.getValue(), exportConfigToRefresh.getKey(), e});
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Unexpected error while refreshing import/export camel routes", (Throwable)e);
                }
            }
        };
        this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(task, 0L, this.configsRefreshInterval.intValue(), TimeUnit.MILLISECONDS);
    }

    private void initCamel() throws Exception {
        this.camelContext = new OsgiDefaultCamelContext(this.bundleContext);
        ProfileImportFromSourceRouteBuilder builderReader = new ProfileImportFromSourceRouteBuilder(this.kafkaProps, this.configType);
        builderReader.setProfileService(this.profileService);
        builderReader.setImportConfigurationService(this.importConfigurationService);
        builderReader.setJacksonDataFormat(this.jacksonDataFormat);
        builderReader.setAllowedEndpoints(this.allowedEndpoints);
        builderReader.setContext(this.camelContext);
        this.camelContext.addRoutes((RoutesBuilder)builderReader);
        ProfileImportOneShotRouteBuilder builderOneShot = new ProfileImportOneShotRouteBuilder(this.kafkaProps, this.configType);
        builderOneShot.setProfileService(this.profileService);
        builderOneShot.setImportConfigByFileNameProcessor(this.importConfigByFileNameProcessor);
        builderOneShot.setJacksonDataFormat(this.jacksonDataFormat);
        builderOneShot.setUploadDir(this.uploadDir);
        builderOneShot.setContext(this.camelContext);
        this.camelContext.addRoutes((RoutesBuilder)builderOneShot);
        ProfileImportToUnomiRouteBuilder builderProcessor = new ProfileImportToUnomiRouteBuilder(this.kafkaProps, this.configType);
        builderProcessor.setUnomiStorageProcessor(this.unomiStorageProcessor);
        builderProcessor.setImportRouteCompletionProcessor(this.importRouteCompletionProcessor);
        builderProcessor.setJacksonDataFormat(this.jacksonDataFormat);
        builderProcessor.setContext(this.camelContext);
        this.camelContext.addRoutes((RoutesBuilder)builderProcessor);
        ProfileExportCollectRouteBuilder profileExportCollectRouteBuilder = new ProfileExportCollectRouteBuilder(this.kafkaProps, this.configType);
        profileExportCollectRouteBuilder.setExportConfigurationList(this.exportConfigurationService.getAll());
        profileExportCollectRouteBuilder.setPersistenceService(this.persistenceService);
        profileExportCollectRouteBuilder.setAllowedEndpoints(this.allowedEndpoints);
        profileExportCollectRouteBuilder.setJacksonDataFormat(this.jacksonDataFormat);
        profileExportCollectRouteBuilder.setContext(this.camelContext);
        this.camelContext.addRoutes((RoutesBuilder)profileExportCollectRouteBuilder);
        ProfileExportProducerRouteBuilder profileExportProducerRouteBuilder = new ProfileExportProducerRouteBuilder(this.kafkaProps, this.configType);
        profileExportProducerRouteBuilder.setProfileService(this.profileService);
        profileExportProducerRouteBuilder.setProfileExportService(this.profileExportService);
        profileExportProducerRouteBuilder.setExportRouteCompletionProcessor(this.exportRouteCompletionProcessor);
        profileExportProducerRouteBuilder.setAllowedEndpoints(this.allowedEndpoints);
        profileExportProducerRouteBuilder.setJacksonDataFormat(this.jacksonDataFormat);
        profileExportProducerRouteBuilder.setContext(this.camelContext);
        this.camelContext.addRoutes((RoutesBuilder)profileExportProducerRouteBuilder);
        this.camelContext.start();
    }

    public void killExistingRoute(String routeId, boolean fireEvent) throws Exception {
        RouteDefinition routeDefinition;
        Route route = this.camelContext.getRoute(routeId);
        if (route != null && (routeDefinition = this.camelContext.getRouteDefinition(routeId)) != null) {
            this.camelContext.removeRouteDefinition(routeDefinition);
        }
    }

    public void updateProfileImportReaderRoute(String configId, boolean fireEvent) throws Exception {
        this.killExistingRoute(configId, false);
        ImportConfiguration importConfiguration = (ImportConfiguration)this.importConfigurationService.load(configId);
        if (importConfiguration == null) {
            LOGGER.warn("Cannot update profile import reader route, config: {} not found", (Object)configId);
            return;
        }
        if ("recurrent".equals(importConfiguration.getConfigType())) {
            ProfileImportFromSourceRouteBuilder builder = new ProfileImportFromSourceRouteBuilder(this.kafkaProps, this.configType);
            builder.setImportConfigurationList(Arrays.asList(importConfiguration));
            builder.setImportConfigurationService(this.importConfigurationService);
            builder.setProfileService(this.profileService);
            builder.setAllowedEndpoints(this.allowedEndpoints);
            builder.setJacksonDataFormat(this.jacksonDataFormat);
            builder.setContext(this.camelContext);
            this.camelContext.addRoutes((RoutesBuilder)builder);
        }
    }

    public void updateProfileExportReaderRoute(String configId, boolean fireEvent) throws Exception {
        this.killExistingRoute(configId, false);
        ExportConfiguration exportConfiguration = (ExportConfiguration)this.exportConfigurationService.load(configId);
        if (exportConfiguration == null) {
            LOGGER.warn("Cannot update profile export reader route, config: {} not found", (Object)configId);
            return;
        }
        if ("recurrent".equals(exportConfiguration.getConfigType())) {
            ProfileExportCollectRouteBuilder profileExportCollectRouteBuilder = new ProfileExportCollectRouteBuilder(this.kafkaProps, this.configType);
            profileExportCollectRouteBuilder.setExportConfigurationList(Collections.singletonList(exportConfiguration));
            profileExportCollectRouteBuilder.setPersistenceService(this.persistenceService);
            profileExportCollectRouteBuilder.setAllowedEndpoints(this.allowedEndpoints);
            profileExportCollectRouteBuilder.setJacksonDataFormat(this.jacksonDataFormat);
            profileExportCollectRouteBuilder.setContext(this.camelContext);
            this.camelContext.addRoutes((RoutesBuilder)profileExportCollectRouteBuilder);
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setUnomiStorageProcessor(UnomiStorageProcessor unomiStorageProcessor) {
        this.unomiStorageProcessor = unomiStorageProcessor;
    }

    public void setImportRouteCompletionProcessor(ImportRouteCompletionProcessor importRouteCompletionProcessor) {
        this.importRouteCompletionProcessor = importRouteCompletionProcessor;
    }

    public void setExportRouteCompletionProcessor(ExportRouteCompletionProcessor exportRouteCompletionProcessor) {
        this.exportRouteCompletionProcessor = exportRouteCompletionProcessor;
    }

    public void setImportConfigByFileNameProcessor(ImportConfigByFileNameProcessor importConfigByFileNameProcessor) {
        this.importConfigByFileNameProcessor = importConfigByFileNameProcessor;
    }

    public void setImportConfigurationService(ImportExportConfigurationService<ImportConfiguration> importConfigurationService) {
        this.importConfigurationService = importConfigurationService;
    }

    public void setExportConfigurationService(ImportExportConfigurationService<ExportConfiguration> exportConfigurationService) {
        this.exportConfigurationService = exportConfigurationService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setProfileExportService(ProfileExportService profileExportService) {
        this.profileExportService = profileExportService;
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public void setJacksonDataFormat(JacksonDataFormat jacksonDataFormat) {
        this.jacksonDataFormat = jacksonDataFormat;
    }

    public void setUploadDir(String uploadDir) {
        this.uploadDir = uploadDir;
    }

    public void setKafkaProps(Map<String, String> kafkaProps) {
        this.kafkaProps = kafkaProps;
    }

    public void setConfigType(String configType) {
        this.configType = configType;
    }

    public void setAllowedEndpoints(String allowedEndpoints) {
        this.allowedEndpoints = allowedEndpoints;
    }
}

