/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.healthcheck.servlet;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.unomi.healthcheck.HealthCheckResponse;
import org.apache.unomi.healthcheck.HealthCheckService;
import org.osgi.service.useradmin.Authorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)HealthCheckServlet.class.getName());
    private final HealthCheckService service;
    private final ObjectMapper mapper;

    public HealthCheckServlet(HealthCheckService service) {
        LOGGER.info("Building healthcheck servlet...");
        this.service = service;
        this.mapper = new ObjectMapper();
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public void init(ServletConfig config) throws ServletException {
        LOGGER.info("Initializing healthcheck servlet...");
        super.init(config);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getAttribute("org.osgi.service.useradmin.authorization") == null || !((Authorization)request.getAttribute("org.osgi.service.useradmin.authorization")).hasRole("health")) {
            response.sendError(403);
            return;
        }
        List<HealthCheckResponse> checks = this.service.check();
        checks.sort(Comparator.comparing(HealthCheckResponse::getName));
        response.getWriter().println(this.mapper.writeValueAsString(checks));
        response.setContentType("application/json");
        response.setHeader("Cache-Control", "no-cache");
        if (checks.stream().allMatch(HealthCheckResponse::isLive)) {
            response.setStatus(200);
        } else {
            response.setStatus(206);
        }
    }
}

