/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wiremock.com.github.jknack.handlebars.Decorator;
import wiremock.com.github.jknack.handlebars.EscapingStrategy;
import wiremock.com.github.jknack.handlebars.Formatter;
import wiremock.com.github.jknack.handlebars.Helper;
import wiremock.com.github.jknack.handlebars.HelperRegistry;
import wiremock.com.github.jknack.handlebars.Parser;
import wiremock.com.github.jknack.handlebars.ParserFactory;
import wiremock.com.github.jknack.handlebars.Template;
import wiremock.com.github.jknack.handlebars.cache.NullTemplateCache;
import wiremock.com.github.jknack.handlebars.cache.TemplateCache;
import wiremock.com.github.jknack.handlebars.helper.DefaultHelperRegistry;
import wiremock.com.github.jknack.handlebars.internal.FormatterChain;
import wiremock.com.github.jknack.handlebars.internal.HbsParserFactory;
import wiremock.com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import wiremock.com.github.jknack.handlebars.io.CompositeTemplateLoader;
import wiremock.com.github.jknack.handlebars.io.StringTemplateSource;
import wiremock.com.github.jknack.handlebars.io.TemplateLoader;
import wiremock.com.github.jknack.handlebars.io.TemplateSource;
import wiremock.org.apache.commons.lang3.Validate;

public class Handlebars
implements HelperRegistry {
    public static final String DELIM_START = "{{";
    public static final String DELIM_END = "}}";
    private static final Logger logger = LoggerFactory.getLogger(Handlebars.class);
    private TemplateLoader loader;
    private TemplateCache cache = NullTemplateCache.INSTANCE;
    private boolean stringParams;
    private boolean prettyPrint;
    private HelperRegistry registry = new DefaultHelperRegistry();
    private boolean infiniteLoops;
    private boolean deletePartialAfterMerge;
    private EscapingStrategy escapingStrategy = EscapingStrategy.HTML_ENTITY;
    private ParserFactory parserFactory = new HbsParserFactory();
    private String startDelimiter = "{{";
    private String endDelimiter = "}}";
    private String handlebarsJsFile = "/handlebars-v4.0.4.js";
    private List<Formatter> formatters = new ArrayList<Formatter>();
    private Formatter.Chain formatter = Formatter.NOOP;
    private boolean parentScopeResolution = true;

    public Handlebars(TemplateLoader loader) {
        this.with(loader);
    }

    public Handlebars() {
        this(new ClassPathTemplateLoader());
    }

    public Template compile(String location) throws IOException {
        return this.compile(location, this.startDelimiter, this.endDelimiter);
    }

    public Template compile(String location, String startDelimiter, String endDelimiter) throws IOException {
        return this.compile(this.loader.sourceAt(location), startDelimiter, endDelimiter);
    }

    public Template compileInline(String input) throws IOException {
        return this.compileInline(input, this.startDelimiter, this.endDelimiter);
    }

    public Template compileInline(String input, String startDelimiter, String endDelimiter) throws IOException {
        Validate.notNull(input, "The input is required.", new Object[0]);
        String filename = "inline@" + Integer.toHexString(Math.abs(input.hashCode()));
        return this.compile(new StringTemplateSource(filename, input), startDelimiter, endDelimiter);
    }

    public Template compile(TemplateSource source) throws IOException {
        return this.compile(source, this.startDelimiter, this.endDelimiter);
    }

    public Template compile(TemplateSource source, String startDelimiter, String endDelimiter) throws IOException {
        Validate.notNull(source, "The template source is required.", new Object[0]);
        Validate.notEmpty(startDelimiter, "The start delimiter is required.", new Object[0]);
        Validate.notEmpty(endDelimiter, "The end delimiter is required.", new Object[0]);
        Parser parser = this.parserFactory.create(this, startDelimiter, endDelimiter);
        Template template = this.cache.get(source, parser);
        return template;
    }

    @Override
    public <C> Helper<C> helper(String name) {
        return this.registry.helper(name);
    }

    @Override
    public <H> Handlebars registerHelper(String name, Helper<H> helper) {
        this.registry.registerHelper(name, helper);
        return this;
    }

    @Override
    public <H> Handlebars registerHelperMissing(Helper<H> helper) {
        return this.registerHelper("helperMissing", (Helper)helper);
    }

    @Override
    public Handlebars registerHelpers(Object helperSource) {
        this.registry.registerHelpers(helperSource);
        return this;
    }

    @Override
    public Handlebars registerHelpers(Class<?> helperSource) {
        this.registry.registerHelpers(helperSource);
        return this;
    }

    @Override
    public Handlebars registerHelpers(URI location) throws Exception {
        this.registry.registerHelpers(location);
        return this;
    }

    @Override
    public Handlebars registerHelpers(File input) throws Exception {
        this.registry.registerHelpers(input);
        return this;
    }

    @Override
    public Handlebars registerHelpers(String filename, Reader source) throws Exception {
        this.registry.registerHelpers(filename, source);
        return this;
    }

    @Override
    public Handlebars registerHelpers(String filename, InputStream source) throws Exception {
        this.registry.registerHelpers(filename, source);
        return this;
    }

    @Override
    public Handlebars registerHelpers(String filename, String source) throws Exception {
        this.registry.registerHelpers(filename, source);
        return this;
    }

    @Override
    public Set<Map.Entry<String, Helper<?>>> helpers() {
        return this.registry.helpers();
    }

    public TemplateLoader getLoader() {
        return this.loader;
    }

    public TemplateCache getCache() {
        return this.cache;
    }

    public EscapingStrategy getEscapingStrategy() {
        return this.escapingStrategy;
    }

    public boolean stringParams() {
        return this.stringParams;
    }

    public boolean prettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public Handlebars prettyPrint(boolean prettyPrint) {
        this.setPrettyPrint(prettyPrint);
        return this;
    }

    public void setStringParams(boolean stringParams) {
        this.stringParams = stringParams;
    }

    public Handlebars stringParams(boolean stringParams) {
        this.setStringParams(stringParams);
        return this;
    }

    public boolean infiniteLoops() {
        return this.infiniteLoops;
    }

    public void setInfiniteLoops(boolean infiniteLoops) {
        this.infiniteLoops = infiniteLoops;
    }

    public Handlebars infiniteLoops(boolean infiniteLoops) {
        this.setInfiniteLoops(infiniteLoops);
        return this;
    }

    public boolean deletePartialAfterMerge() {
        return this.deletePartialAfterMerge;
    }

    public Handlebars deletePartialAfterMerge(boolean deletePartialAfterMerge) {
        this.setDeletePartialAfterMerge(deletePartialAfterMerge);
        return this;
    }

    public void setDeletePartialAfterMerge(boolean deletePartialAfterMerge) {
        this.deletePartialAfterMerge = deletePartialAfterMerge;
    }

    public void setEndDelimiter(String endDelimiter) {
        this.endDelimiter = Validate.notEmpty(endDelimiter, "The endDelimiter is required.", new Object[0]);
    }

    public Handlebars endDelimiter(String endDelimiter) {
        this.setEndDelimiter(endDelimiter);
        return this;
    }

    public void setStartDelimiter(String startDelimiter) {
        this.startDelimiter = Validate.notEmpty(startDelimiter, "The startDelimiter is required.", new Object[0]);
    }

    public Handlebars startDelimiter(String startDelimiter) {
        this.setStartDelimiter(startDelimiter);
        return this;
    }

    public Handlebars with(TemplateLoader ... loader) {
        Validate.isTrue(loader.length > 0, "The template loader is required.", new Object[0]);
        this.loader = loader.length == 1 ? loader[0] : new CompositeTemplateLoader(loader);
        return this;
    }

    public Handlebars with(ParserFactory parserFactory) {
        this.parserFactory = Validate.notNull(parserFactory, "A parserFactory is required.", new Object[0]);
        return this;
    }

    public Handlebars with(TemplateCache cache) {
        this.cache = Validate.notNull(cache, "The template cache is required.", new Object[0]);
        return this;
    }

    public Handlebars with(HelperRegistry registry) {
        this.registry = Validate.notNull(registry, "The registry is required.", new Object[0]);
        return this;
    }

    public Handlebars with(EscapingStrategy escapingStrategy) {
        this.escapingStrategy = Validate.notNull(escapingStrategy, "The escaping strategy is required.", new Object[0]);
        return this;
    }

    public Formatter.Chain getFormatter() {
        return this.formatter;
    }

    public Handlebars with(Formatter formatter) {
        Validate.notNull(formatter, "A formatter is required.", new Object[0]);
        this.formatters.add(formatter);
        this.formatter = new FormatterChain(this.formatters);
        return this;
    }

    public Handlebars handlebarsJsFile(String location) {
        URL resource;
        this.handlebarsJsFile = Validate.notEmpty(location, "A handlebars.js location is required.", new Object[0]);
        if (!this.handlebarsJsFile.startsWith("/")) {
            this.handlebarsJsFile = "/" + this.handlebarsJsFile;
        }
        if ((resource = this.getClass().getResource(this.handlebarsJsFile)) == null) {
            throw new IllegalArgumentException("File not found: " + this.handlebarsJsFile);
        }
        return this;
    }

    public String handlebarsJsFile() {
        return this.handlebarsJsFile;
    }

    public boolean parentScopeResolution() {
        return this.parentScopeResolution;
    }

    public void setParentScopeResolution(boolean parentScopeResolution) {
        this.parentScopeResolution = parentScopeResolution;
    }

    public Handlebars parentScopeResolution(boolean parentScopeResolution) {
        this.setParentScopeResolution(parentScopeResolution);
        return this;
    }

    public ParserFactory getParserFactory() {
        return this.parserFactory;
    }

    public static void log(String message, Object ... args) {
        logger.info(String.format(message, args));
    }

    public static void log(String message) {
        logger.info(message);
    }

    public static void warn(String message, Object ... args) {
        if (logger.isWarnEnabled()) {
            logger.warn(String.format(message, args));
        }
    }

    public static void warn(String message) {
        logger.warn(message);
    }

    public static void debug(String message, Object ... args) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format(message, args));
        }
    }

    public static void debug(String message) {
        logger.debug(message);
    }

    public static void error(String message, Object ... args) {
        logger.error(String.format(message, args));
    }

    public static void error(String message) {
        logger.error(message);
    }

    @Override
    public Decorator decorator(String name) {
        return this.registry.decorator(name);
    }

    @Override
    public Handlebars registerDecorator(String name, Decorator decorator) {
        this.registry.registerDecorator(name, decorator);
        return this;
    }

    public static class Utils {
        public static boolean isEmpty(Object value) {
            if (value == null) {
                return true;
            }
            if (value instanceof CharSequence) {
                return ((CharSequence)value).length() == 0;
            }
            if (value instanceof Collection) {
                return ((Collection)value).size() == 0;
            }
            if (value instanceof Iterable) {
                return !((Iterable)value).iterator().hasNext();
            }
            if (value instanceof Boolean) {
                return (Boolean)value == false;
            }
            if (value.getClass().isArray()) {
                return Array.getLength(value) == 0;
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue() == 0.0;
            }
            return false;
        }

        public static CharSequence escapeExpression(CharSequence input) {
            return EscapingStrategy.DEF.escape(input);
        }
    }

    public static class SafeString
    implements CharSequence {
        public final CharSequence content;

        public SafeString(CharSequence content) {
            this.content = content;
        }

        @Override
        public int length() {
            return this.content.length();
        }

        @Override
        public char charAt(int index) {
            return this.content.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.content.subSequence(start, end);
        }

        @Override
        public String toString() {
            return this.content.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SafeString) {
                SafeString that = (SafeString)obj;
                return this.content.equals(that.content);
            }
            return false;
        }
    }
}

