/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.classic;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.DateTimeException;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.measure.IncommensurableException;
import javax.measure.UnitConverter;
import javax.measure.format.MeasurementParseException;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.netcdf.base.Convention;
import org.apache.sis.storage.netcdf.base.DataType;
import org.apache.sis.storage.netcdf.base.Decoder;
import org.apache.sis.storage.netcdf.base.Dimension;
import org.apache.sis.storage.netcdf.base.Grid;
import org.apache.sis.storage.netcdf.base.NamedElement;
import org.apache.sis.storage.netcdf.base.Node;
import org.apache.sis.storage.netcdf.base.Variable;
import org.apache.sis.storage.netcdf.classic.DimensionInfo;
import org.apache.sis.storage.netcdf.classic.GridInfo;
import org.apache.sis.storage.netcdf.classic.VariableInfo;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.internal.CollectionsExt;
import org.apache.sis.util.internal.StandardDateFormat;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.InvalidParameterCardinalityException;

public final class ChannelDecoder
extends Decoder {
    public static final int MAGIC_NUMBER = 1128547840;
    public static final int MAX_VERSION = 2;
    private static final Charset NAME_ENCODING = StandardCharsets.UTF_8;
    static final Locale NAME_LOCALE = Locale.US;
    private static final int STREAMING = -1;
    private static final int DIMENSION = 10;
    private static final int VARIABLE = 11;
    private static final int ATTRIBUTE = 12;
    private final ChannelDataInput input;
    private final boolean is64bits;
    private final int numrecs;
    private Charset encoding;
    final VariableInfo[] variables;
    private final Map<String, VariableInfo> variableMap;
    private final Map<String, Object> attributeMap;
    private final Set<String> attributeNames;
    private Map<String, DimensionInfo> dimensionMap;
    private transient Grid[] gridGeometries;

    public ChannelDecoder(ChannelDataInput input, Charset encoding, GeometryLibrary geomlib, StoreListeners listeners) throws IOException, DataStoreException {
        super(geomlib, listeners);
        this.input = input;
        this.encoding = encoding != null ? encoding : StandardCharsets.UTF_8;
        int version = input.readInt();
        if ((version & 0xFFFFFF00) != 1128547840) {
            throw new DataStoreContentException(this.errors().getString((short)139, "netCDF", this.getFilename()));
        }
        switch (version &= 0xFF) {
            case 1: {
                this.is64bits = false;
                break;
            }
            case 2: {
                this.is64bits = true;
                break;
            }
            default: {
                throw new DataStoreContentException(this.errors().getString((short)159, "netCDF", version));
            }
        }
        this.numrecs = input.readInt();
        DimensionInfo[] dimensions = null;
        VariableInfo[] variables = null;
        List<Map.Entry<String, Object>> attributes = List.of();
        for (int i = 0; i < 3; ++i) {
            long tn = input.readLong();
            if (tn == 0L) continue;
            int tag = (int)(tn >>> 32);
            int nelems = (int)tn;
            this.ensureNonNegative(nelems, tag);
            try {
                switch (tag) {
                    case 10: {
                        dimensions = this.readDimensions(nelems);
                        break;
                    }
                    case 11: {
                        variables = this.readVariables(nelems, dimensions);
                        break;
                    }
                    case 12: {
                        attributes = this.readAttributes(nelems);
                        break;
                    }
                    default: {
                        throw this.malformedHeader();
                    }
                }
                continue;
            }
            catch (InvalidParameterCardinalityException e) {
                throw this.malformedHeader().initCause(e);
            }
        }
        this.attributeMap = CollectionsExt.toCaseInsensitiveNameMap(attributes, NAME_LOCALE);
        this.attributeNames = ChannelDecoder.attributeNames(attributes, this.attributeMap);
        if (variables != null) {
            this.variables = variables;
            this.variableMap = ChannelDecoder.toCaseInsensitiveNameMap(variables);
        } else {
            this.variables = new VariableInfo[0];
            this.variableMap = Map.of();
        }
        this.initialize();
    }

    private static <E extends NamedElement> Map<String, E> toCaseInsensitiveNameMap(E[] elements) {
        return CollectionsExt.toCaseInsensitiveNameMap(new AbstractList<Map.Entry<String, E>>((NamedElement[])elements){
            final /* synthetic */ NamedElement[] val$elements;
            {
                this.val$elements = namedElementArray;
            }

            @Override
            public int size() {
                return this.val$elements.length;
            }

            @Override
            public Map.Entry<String, E> get(int index) {
                NamedElement e = this.val$elements[index];
                return new AbstractMap.SimpleImmutableEntry<String, NamedElement>(e.getName(), e);
            }
        }, NAME_LOCALE);
    }

    private static String tagName(int tag) {
        short key;
        switch (tag) {
            case 10: {
                key = 65;
                break;
            }
            case 11: {
                key = 217;
                break;
            }
            case 12: {
                key = 10;
                break;
            }
            default: {
                return Integer.toHexString(tag);
            }
        }
        return Vocabulary.format(key);
    }

    final Errors errors() {
        return Errors.getResources(this.listeners.getLocale());
    }

    private DataStoreContentException malformedHeader() {
        return new DataStoreContentException(this.listeners.getLocale(), "netCDF", this.getFilename(), null);
    }

    private void ensureNonNegative(int nelems, int tag) throws DataStoreContentException {
        if (nelems < 0) {
            throw new DataStoreContentException(this.errors().getString((short)93, this.tagPath(ChannelDecoder.tagName(tag))));
        }
    }

    private String tagPath(String name) {
        return this.getFilename() + ":" + name;
    }

    private void align(int length) throws IOException {
        if ((length &= 3) != 0) {
            length = 4 - length;
            this.input.ensureBufferContains(length);
            this.input.buffer.position(this.input.buffer.position() + length);
        }
    }

    private long readOffset() throws IOException {
        return this.is64bits ? this.input.readLong() : this.input.readUnsignedInt();
    }

    private String readName() throws IOException, DataStoreContentException {
        int length = this.input.readInt();
        if (length < 0) {
            throw this.malformedHeader();
        }
        String text = this.input.readString(length, NAME_ENCODING);
        this.align(length);
        return text;
    }

    private Object readValues(DataType type, int length) throws IOException, DataStoreContentException {
        Object[] data;
        if (length <= 0) {
            if (length == 0) {
                return null;
            }
            throw this.malformedHeader();
        }
        if (length == 1) {
            switch (type) {
                case BYTE: {
                    byte v = this.input.readByte();
                    this.align(1);
                    return v;
                }
                case UBYTE: {
                    short v = (short)this.input.readUnsignedByte();
                    this.align(1);
                    return v;
                }
                case SHORT: {
                    short v = this.input.readShort();
                    this.align(2);
                    return v;
                }
                case USHORT: {
                    int v = this.input.readUnsignedShort();
                    this.align(2);
                    return v;
                }
                case INT: {
                    return this.input.readInt();
                }
                case INT64: {
                    return this.input.readLong();
                }
                case UINT: {
                    return this.input.readUnsignedInt();
                }
                case FLOAT: {
                    return Float.valueOf(this.input.readFloat());
                }
                case DOUBLE: {
                    return this.input.readDouble();
                }
            }
        }
        switch (type) {
            case CHAR: {
                String text = this.input.readString(length, this.encoding);
                this.align(length);
                return text.isEmpty() ? null : text;
            }
            case BYTE: 
            case UBYTE: {
                byte[] array = new byte[length];
                this.input.readFully(array);
                this.align(length);
                data = array;
                break;
            }
            case SHORT: 
            case USHORT: {
                short[] array = new short[length];
                this.input.readFully(array, 0, length);
                this.align(length << 1);
                data = array;
                break;
            }
            case INT: 
            case UINT: {
                int[] array = new int[length];
                this.input.readFully(array, 0, length);
                data = array;
                break;
            }
            case INT64: 
            case UINT64: {
                long[] array = new long[length];
                this.input.readFully(array, 0, length);
                data = array;
                break;
            }
            case FLOAT: {
                float[] array = new float[length];
                this.input.readFully(array, 0, length);
                return Vector.createForDecimal(array);
            }
            case DOUBLE: {
                double[] array = new double[length];
                this.input.readFully(array, 0, length);
                float[] asFloats = ArraysExt.copyAsFloatsIfLossless(array);
                if (asFloats != null) {
                    return Vector.createForDecimal(asFloats);
                }
                data = array;
                break;
            }
            default: {
                throw this.malformedHeader();
            }
        }
        return Vector.create(data, type.isUnsigned);
    }

    private DimensionInfo[] readDimensions(int nelems) throws IOException, DataStoreContentException {
        NamedElement[] dimensions = new DimensionInfo[nelems];
        for (int i = 0; i < nelems; ++i) {
            boolean isUnlimited;
            String name = this.readName();
            int length = this.input.readInt();
            boolean bl = isUnlimited = length == 0;
            if (isUnlimited && (length = this.numrecs) == -1) {
                throw new DataStoreContentException(this.errors().getString((short)89, this.tagPath("numrecs")));
            }
            dimensions[i] = new DimensionInfo(name, length, isUnlimited);
        }
        this.dimensionMap = ChannelDecoder.toCaseInsensitiveNameMap((NamedElement[])dimensions);
        return dimensions;
    }

    private List<Map.Entry<String, Object>> readAttributes(int nelems) throws IOException, DataStoreException {
        ArrayList<Map.Entry<String, Object>> attributes = new ArrayList<Map.Entry<String, Object>>(nelems);
        while (--nelems >= 0) {
            String name = this.readName();
            Object value = this.readValues(DataType.valueOf(this.input.readInt()), this.input.readInt());
            if (value == null) continue;
            attributes.add(new AbstractMap.SimpleEntry<String, Object>(name, value));
            if (!name.equals("_Encoding")) continue;
            try {
                this.encoding = Charset.forName(name);
            }
            catch (IllegalArgumentException e) {
                this.listeners.warning(Errors.format((short)11, this.getFilename(), "_Encoding"), e);
            }
        }
        return attributes;
    }

    private VariableInfo[] readVariables(int nelems, DimensionInfo[] allDimensions) throws IOException, DataStoreException {
        if (allDimensions == null) {
            throw this.malformedHeader();
        }
        VariableInfo[] variables = new VariableInfo[nelems];
        for (int j = 0; j < nelems; ++j) {
            String name = this.readName();
            int n = this.input.readInt();
            DimensionInfo[] varDims = new DimensionInfo[n];
            try {
                for (int i = 0; i < n; ++i) {
                    varDims[i] = allDimensions[this.input.readInt()];
                }
            }
            catch (IndexOutOfBoundsException cause) {
                throw this.malformedHeader().initCause(cause);
            }
            List<Map.Entry<String, Object>> attributes = List.of();
            long tn = this.input.readLong();
            if (tn != 0L) {
                int tag = (int)(tn >>> 32);
                int na = (int)tn;
                this.ensureNonNegative(na, tag);
                switch (tag) {
                    case 12: {
                        Charset globalEncoding = this.encoding;
                        attributes = this.readAttributes(na);
                        this.encoding = globalEncoding;
                        break;
                    }
                    default: {
                        throw this.malformedHeader();
                    }
                }
            }
            Map<String, Object> map = CollectionsExt.toCaseInsensitiveNameMap(attributes, NAME_LOCALE);
            variables[j] = new VariableInfo(this, this.input, name, varDims, map, ChannelDecoder.attributeNames(attributes, map), DataType.valueOf(this.input.readInt()), this.input.readInt(), this.readOffset());
        }
        VariableInfo.complete(variables);
        return variables;
    }

    private static Set<String> attributeNames(List<Map.Entry<String, Object>> attributes, Map<String, ?> attributeMap) {
        if (attributes.size() >= attributeMap.size()) {
            return Collections.unmodifiableSet(attributeMap.keySet());
        }
        LinkedHashSet<String> attributeNames = new LinkedHashSet<String>(Containers.hashMapCapacity(attributes.size()));
        attributes.forEach(e -> attributeNames.add((String)e.getKey()));
        return attributeNames;
    }

    @Override
    public final String getFilename() {
        return this.input.filename;
    }

    @Override
    public String[] getFormatDescription() {
        return new String[]{"NetCDF"};
    }

    @Override
    public void setSearchPath(String ... groupNames) {
    }

    @Override
    public String[] getSearchPath() {
        return new String[1];
    }

    @Override
    protected Dimension findDimension(String dimName) {
        String lower;
        DimensionInfo dim = this.dimensionMap.get(dimName);
        if (dim == null && (lower = dimName.toLowerCase(NAME_LOCALE)) != dimName) {
            dim = this.dimensionMap.get(lower);
        }
        return dim;
    }

    private VariableInfo findVariableInfo(String name) {
        String lower;
        VariableInfo v = this.variableMap.get(name);
        if (v == null && name != null && (lower = name.toLowerCase(NAME_LOCALE)) != name) {
            v = this.variableMap.get(lower);
        }
        return v;
    }

    @Override
    protected Variable findVariable(String name) {
        return this.findVariableInfo(name);
    }

    @Override
    protected Node findNode(String name) {
        return this.findVariableInfo(name);
    }

    private Object findAttribute(String name) {
        String mappedName;
        if (name == null) {
            return null;
        }
        int index = 0;
        Convention convention = this.convention();
        while ((mappedName = convention.mapAttributeName(name, index++)) != null) {
            Object value = this.attributeMap.get(mappedName);
            if (value != null) {
                return value;
            }
            String lowerCase = mappedName.toLowerCase(NAME_LOCALE);
            if (lowerCase == mappedName || (value = this.attributeMap.get(lowerCase)) == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public Collection<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.attributeNames);
    }

    @Override
    public String stringValue(String name) {
        Object value = this.findAttribute(name);
        return value != null ? value.toString() : null;
    }

    @Override
    public Number numericValue(String name) {
        Object value = this.findAttribute(name);
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof String) {
            return this.parseNumber(name, (String)value);
        }
        if (value instanceof Vector) {
            return ((Vector)value).get(0);
        }
        return null;
    }

    @Override
    public Date dateValue(String name) {
        Object value = this.findAttribute(name);
        if (value instanceof CharSequence) {
            try {
                return StandardDateFormat.toDate(StandardDateFormat.FORMAT.parse((CharSequence)value));
            }
            catch (ArithmeticException | DateTimeException e) {
                this.listeners.warning(e);
            }
        }
        return null;
    }

    @Override
    public Date[] numberToDate(String symbol, Number ... values) {
        Date[] dates = new Date[values.length];
        Matcher parts = Variable.TIME_UNIT_PATTERN.matcher(symbol);
        if (parts.matches()) {
            try {
                UnitConverter converter = Units.valueOf(parts.group(1)).getConverterToAny(Units.MILLISECOND);
                long epoch = StandardDateFormat.toDate(StandardDateFormat.FORMAT.parse(parts.group(2))).getTime();
                for (int i = 0; i < values.length; ++i) {
                    Number value = values[i];
                    if (value == null) continue;
                    dates[i] = new Date(epoch + Math.round(converter.convert(value.doubleValue())));
                }
            }
            catch (ArithmeticException | DateTimeException | IncommensurableException | MeasurementParseException e) {
                this.listeners.warning(e);
            }
        }
        return dates;
    }

    final Charset getEncoding() {
        return this.encoding;
    }

    @Override
    public Variable[] getVariables() {
        return this.variables;
    }

    private boolean listAxes(CharSequence[] names, Set<VariableInfo> axes, Set<DimensionInfo> dimensions) {
        if (names == null || names.length == 0) {
            return false;
        }
        for (CharSequence name : names) {
            VariableInfo axis = this.findVariableInfo(name.toString());
            if (axis == null) {
                dimensions.clear();
                axes.clear();
                break;
            }
            axes.add(axis);
            Collections.addAll(dimensions, axis.dimensions);
        }
        return true;
    }

    @Override
    public Grid[] getGridCandidates() {
        if (this.gridGeometries == null) {
            IdentityHashMap dimToAxes = new IdentityHashMap();
            block4: for (VariableInfo variable : this.variables) {
                switch (variable.getRole()) {
                    case COVERAGE: 
                    case DISCRETE_COVERAGE: {
                        variable.isCoordinateSystemAxis = false;
                        continue block4;
                    }
                    case AXIS: {
                        variable.isCoordinateSystemAxis = true;
                        DimensionInfo[] dimensionInfoArray = variable.dimensions;
                        int n = dimensionInfoArray.length;
                        for (int i = 0; i < n; ++i) {
                            DimensionInfo dimension = dimensionInfoArray[i];
                            CollectionsExt.addToMultiValuesMap(dimToAxes, dimension, variable);
                        }
                        continue block4;
                    }
                }
            }
            LinkedHashSet<VariableInfo> axes = new LinkedHashSet<VariableInfo>(8);
            HashSet<DimensionInfo> usedDimensions = new HashSet<DimensionInfo>(8);
            LinkedHashMap<GridInfo, GridInfo> shared = new LinkedHashMap<GridInfo, GridInfo>();
            block6: for (VariableInfo variable : this.variables) {
                if (variable.isCoordinateSystemAxis || variable.dimensions.length == 0) continue;
                axes.clear();
                usedDimensions.clear();
                if (!this.listAxes(variable.getCoordinateVariables(), axes, usedDimensions)) {
                    this.listAxes(this.convention().namesOfAxisVariables(variable), axes, usedDimensions);
                }
                int i = variable.dimensions.length;
                while (--i >= 0) {
                    DimensionInfo dimension = variable.dimensions[i];
                    if (!usedDimensions.add(dimension)) continue;
                    List axis = (List)dimToAxes.get(dimension);
                    if (axis == null) continue block6;
                    axes.addAll(axis);
                }
                GridInfo grid = new GridInfo(variable.dimensions, (VariableInfo[])axes.toArray(VariableInfo[]::new));
                GridInfo existing = shared.putIfAbsent(grid, grid);
                if (existing != null) {
                    grid = existing;
                }
                variable.grid = grid;
            }
            this.gridGeometries = (Grid[])shared.values().toArray(Grid[]::new);
        }
        return this.gridGeometries;
    }

    @Override
    public void close(DataStore lock) throws IOException {
        this.input.channel.close();
    }

    @Override
    public void addAttributesTo(TreeTable.Node root) {
        for (VariableInfo variable : this.variables) {
            TreeTable.Node node = root.newChild();
            node.setValue(TableColumn.NAME, variable.getName());
            variable.addAttributesTo(node);
        }
        VariableInfo.addAttributesTo(root, this.attributeNames, this.attributeMap);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SIS driver: \u201c").append(this.getFilename()).append('\u201d');
        if (!this.input.channel.isOpen()) {
            buffer.append(" (closed)");
        }
        return buffer.toString();
    }
}

