/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.csv;

import java.time.Instant;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import org.apache.sis.converter.SurjectiveConverter;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.util.internal.StandardDateFormat;
import org.opengis.referencing.datum.TemporalDatum;

class TimeEncoding
extends SurjectiveConverter<String, Instant> {
    static final CommonCRS.Temporal DEFAULT = CommonCRS.Temporal.TRUNCATED_JULIAN;
    static final TimeEncoding ABSOLUTE = new TimeEncoding(DEFAULT.datum(), (Unit)Units.DAY){

        @Override
        public Instant apply(String time) {
            return StandardDateFormat.parseInstantUTC(time);
        }
    };
    private final long origin;
    private final double interval;

    TimeEncoding(TemporalDatum datum, Unit<Time> unit) {
        this.origin = datum.getOrigin().getTime();
        this.interval = unit.getConverterTo(Units.MILLISECOND).convert(1.0);
    }

    @Override
    public final Class<String> getSourceClass() {
        return String.class;
    }

    @Override
    public final Class<Instant> getTargetClass() {
        return Instant.class;
    }

    @Override
    public Instant apply(String time) {
        double value = Double.parseDouble(time) * this.interval;
        long millis = Math.round(value);
        return Instant.ofEpochMilli(millis + this.origin).plusNanos(Math.round((value - (double)millis) * 1000000.0));
    }

    final double toCRS(long time) {
        return (double)(time - this.origin) / this.interval;
    }
}

