/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Arrays;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.provider.GeocentricAffine;
import org.apache.sis.referencing.operation.provider.GeocentricAffineBetweenGeographic;
import org.apache.sis.referencing.operation.provider.GeodeticOperation;
import org.apache.sis.referencing.operation.transform.MolodenskyTransform;
import org.apache.sis.referencing.util.Formulas;
import org.apache.sis.referencing.util.NilReferencingObject;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

@XmlTransient
public final class Molodensky
extends GeocentricAffineBetweenGeographic {
    private static final long serialVersionUID = 8126525068450868912L;
    public static final ParameterDescriptor<Double> AXIS_LENGTH_DIFFERENCE;
    public static final ParameterDescriptor<Double> FLATTENING_DIFFERENCE;
    public static final ParameterDescriptorGroup PARAMETERS;
    private static final Molodensky[] REDIMENSIONED;

    public static ParameterDescriptorGroup internal() {
        ParameterBuilder builder = (ParameterBuilder)Molodensky.builder().setCodeSpace(Citations.SIS, "SIS");
        ParameterDescriptor<Object> abridged = ((ParameterBuilder)builder.addName("abridged")).create(Boolean.class, null);
        return ((ParameterBuilder)builder.addName("Molodensky (radians domain)")).createGroup(DIMENSION, SRC_SEMI_MAJOR, SRC_SEMI_MINOR, AXIS_LENGTH_DIFFERENCE, FLATTENING_DIFFERENCE, TX, TY, TZ, abridged);
    }

    @Override
    final GeodeticOperation redimensioned(int indexOfDim) {
        return REDIMENSIONED[indexOfDim];
    }

    @Deprecated
    public Molodensky() {
        super(REDIMENSIONED[3]);
    }

    private Molodensky(int indexOfDim) {
        super(GeocentricAffine.Type.MOLODENSKY, PARAMETERS, indexOfDim);
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws FactoryException {
        return Molodensky.createMathTransform(factory, Parameters.castOrWrap(values), this.getSourceDimensions(), this.getTargetDimensions(), false);
    }

    static MathTransform createMathTransform(MathTransformFactory factory, Parameters values, int sourceDimensions, int targetDimensions, boolean isAbridged) throws FactoryException {
        Ellipsoid target;
        Integer dim = (Integer)values.getValue(DIMENSION);
        if (dim != null) {
            int n = dim;
            if (n != 2 && n != 3) {
                throw new InvalidParameterValueException(Errors.format((short)45, "dim", dim), "dim", dim);
            }
            sourceDimensions = targetDimensions = n;
        }
        double sa = values.doubleValue(SRC_SEMI_MAJOR);
        double sb = values.doubleValue(SRC_SEMI_MINOR);
        double ta = Molodensky.optional(values, TGT_SEMI_MAJOR);
        double tb = Molodensky.optional(values, TGT_SEMI_MINOR);
        double \u0394a = Molodensky.conditional(values, AXIS_LENGTH_DIFFERENCE, ta);
        double \u0394f = Molodensky.conditional(values, FLATTENING_DIFFERENCE, tb);
        if (Double.isNaN(ta)) {
            ta = sa + \u0394a;
        }
        if (Double.isNaN(tb)) {
            tb = ta * (sb / sa - \u0394f);
        }
        Map<String, ReferenceIdentifier> name = Map.of("name", NilReferencingObject.UNNAMED);
        Ellipsoid source = new Ellipsoid(name, sa, sb, \u0394a, \u0394f);
        source.other = target = new Ellipsoid(name, ta, tb, -\u0394a, -\u0394f);
        target.other = source;
        source.computeDifferences(values);
        return MolodenskyTransform.createGeodeticTransformation(factory, source, sourceDimensions >= 3, target, targetDimensions >= 3, values.doubleValue(TX), values.doubleValue(TY), values.doubleValue(TZ), isAbridged);
    }

    private static double optional(Parameters values, ParameterDescriptor<Double> parameter) {
        Double value = values.getValue(parameter);
        return value != null ? value : Double.NaN;
    }

    private static double conditional(Parameters values, ParameterDescriptor<Double> parameter, double condition) {
        return Double.isNaN(condition) ? values.doubleValue(parameter) : Molodensky.optional(values, parameter);
    }

    static {
        ParameterBuilder builder = Molodensky.builder();
        AXIS_LENGTH_DIFFERENCE = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8654")).addName("Semi-major axis length difference")).create(Double.NaN, Units.METRE);
        FLATTENING_DIFFERENCE = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8655")).addName("Flattening difference")).createBounded(-1.0, 1.0, Double.NaN, Units.UNITY);
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.setRequired(true).addIdentifier("9604")).addName("Molodensky")).addName(Citations.OGC, "Molodenski")).createGroup(DIMENSION, SRC_SEMI_MAJOR, SRC_SEMI_MINOR, TGT_SEMI_MAJOR, TGT_SEMI_MINOR, TX, TY, TZ, AXIS_LENGTH_DIFFERENCE, FLATTENING_DIFFERENCE);
        REDIMENSIONED = new Molodensky[4];
        Arrays.setAll(REDIMENSIONED, Molodensky::new);
    }

    private static final class Ellipsoid
    extends DefaultEllipsoid {
        private double \u0394a;
        private double \u0394f;
        Ellipsoid other;

        Ellipsoid(Map<String, ?> name, double a, double b, double \u0394a, double \u0394f) {
            super(name, a, b, Formulas.getInverseFlattening(a, b), false, Units.METRE);
            this.\u0394a = \u0394a;
            this.\u0394f = \u0394f;
        }

        void computeDifferences(Parameters values) {
            if (Double.isNaN(this.\u0394a)) {
                this.\u0394a = super.semiMajorAxisDifference(this.other);
                Ellipsoid.setIfPresent(values, AXIS_LENGTH_DIFFERENCE, this.\u0394a, this.getAxisUnit());
            }
            if (Double.isNaN(this.\u0394f)) {
                this.\u0394f = super.flatteningDifference(this.other);
                Ellipsoid.setIfPresent(values, FLATTENING_DIFFERENCE, this.\u0394f, Units.UNITY);
            }
        }

        private static void setIfPresent(Parameters values, ParameterDescriptor<Double> parameter, double value, Unit<?> unit) {
            try {
                values.getOrCreate(parameter).setValue(value, unit);
            }
            catch (InvalidParameterValueException | ParameterNotFoundException e) {
                AbstractProvider.recoverableException(Molodensky.class, e);
            }
        }

        @Override
        public double semiMajorAxisDifference(org.opengis.referencing.datum.Ellipsoid target) {
            return target == this.other && !Double.isNaN(this.\u0394a) ? this.\u0394a : super.semiMajorAxisDifference(target);
        }

        @Override
        public double flatteningDifference(org.opengis.referencing.datum.Ellipsoid target) {
            return target == this.other && !Double.isNaN(this.\u0394f) ? this.\u0394f : super.flatteningDifference(target);
        }
    }
}

