/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.pending.geoapi.filter.ComparisonOperatorName;
import org.apache.sis.pending.geoapi.filter.DistanceOperatorName;
import org.apache.sis.pending.geoapi.filter.LogicalOperatorName;
import org.apache.sis.pending.geoapi.filter.SpatialOperatorName;
import org.apache.sis.pending.geoapi.filter.TemporalOperatorName;

public abstract class Visitor<R, A> {
    private final Map<Enum<?>, BiConsumer<Filter<R>, A>> filters;
    private final Map<String, BiConsumer<Expression<R, ?>, A>> expressions;

    protected Visitor() {
        this.filters = new HashMap();
        this.expressions = new HashMap();
    }

    protected Visitor(boolean hasFilters, boolean hasExpressions) {
        this.filters = hasFilters ? new HashMap() : Collections.emptyMap();
        this.expressions = hasExpressions ? new HashMap() : Collections.emptyMap();
    }

    protected Visitor(Visitor<R, A> source, boolean copyFilters, boolean copyExpressions) {
        this.filters = copyFilters ? new HashMap(source.filters) : source.filters;
        this.expressions = copyExpressions ? new HashMap(source.expressions) : source.expressions;
    }

    protected final BiConsumer<Filter<R>, A> getFilterHandler(Enum<?> type) {
        return this.filters.get(type);
    }

    protected final BiConsumer<Expression<R, ?>, A> getExpressionHandler(String type) {
        return this.expressions.get(type);
    }

    protected final void setFilterHandler(Enum<?> type, BiConsumer<Filter<R>, A> action) {
        this.filters.put(type, action);
    }

    private void setFamilyHandlers(Enum<?> lastType, BiConsumer<Filter<R>, A> action) {
        for (Enum type : (Enum[])lastType.getClass().getEnumConstants()) {
            this.filters.put(type, action);
            if (type == lastType) break;
        }
    }

    protected final void setExpressionHandler(String type, BiConsumer<Expression<R, ?>, A> action) {
        this.expressions.put(type, action);
    }

    private void setExpressionHandlers(BiConsumer<Expression<R, ?>, A> action, String ... types) {
        for (String type : types) {
            this.expressions.put(type, action);
        }
    }

    protected final void setLogicalHandlers(BiConsumer<Filter<R>, A> action) {
        this.setFamilyHandlers(LogicalOperatorName.NOT, action);
    }

    protected final void setNullAndNilHandlers(BiConsumer<Filter<R>, A> action) {
        this.setFilterHandler(ComparisonOperatorName.PROPERTY_IS_NULL, action);
        this.setFilterHandler(ComparisonOperatorName.PROPERTY_IS_NIL, action);
    }

    protected final void setBinaryComparisonHandlers(BiConsumer<Filter<R>, A> action) {
        this.setFamilyHandlers(ComparisonOperatorName.PROPERTY_IS_GREATER_THAN_OR_EQUAL_TO, action);
    }

    protected final void setBinaryTemporalHandlers(BiConsumer<Filter<R>, A> action) {
        this.setFamilyHandlers(TemporalOperatorName.ANY_INTERACTS, action);
    }

    protected final void setSpatialHandlers(BiConsumer<Filter<R>, A> action) {
        this.setFamilyHandlers(SpatialOperatorName.OVERLAPS, action);
        this.setFamilyHandlers(DistanceOperatorName.WITHIN, action);
    }

    protected final void setMathHandlers(BiConsumer<Expression<R, ?>, A> action) {
        this.setExpressionHandlers(action, "Add", "Subtract", "Multiply", "Divide");
    }

    protected final void removeFilterHandlers(Collection<? extends Enum<?>> types) {
        this.filters.keySet().removeAll(types);
    }

    public void visit(Filter<R> filter, A accumulator) {
        Enum<?> type = filter != null ? filter.getOperatorType() : null;
        BiConsumer<Filter<R>, A> f = this.filters.get(type);
        if (f != null) {
            f.accept(filter, accumulator);
        } else {
            this.typeNotFound(type, filter, accumulator);
        }
    }

    public void visit(Expression<R, ?> expression, A accumulator) {
        String type = expression != null ? expression.getFunctionName().tip().toString() : null;
        BiConsumer<Expression<R, ?>, A> f = this.expressions.get(type);
        if (f != null) {
            f.accept(expression, accumulator);
        } else {
            this.typeNotFound(type, expression, accumulator);
        }
    }

    protected void typeNotFound(Enum<?> type, Filter<R> filter, A accumulator) {
        throw new UnsupportedOperationException(Resources.format((short)77, 0, type));
    }

    protected void typeNotFound(String type, Expression<R, ?> expression, A accumulator) {
        throw new UnsupportedOperationException(Resources.format((short)77, 1, type));
    }
}

