/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.feature.internal.FeatureExpression;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.UnaryFunction;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.ScopedName;

final class ConvertFunction<R, S, V>
extends UnaryFunction<R, S>
implements FeatureExpression<R, V>,
Optimization.OnExpression<R, V> {
    private static final long serialVersionUID = 4686604324414717316L;
    private static final ScopedName NAME = ConvertFunction.createName("Convert");
    private final ObjectConverter<? super S, ? extends V> converter;

    ConvertFunction(Expression<R, ? extends S> expression, Class<S> source, Class<V> target) {
        super(expression);
        this.converter = ObjectConverters.find(source, target);
    }

    private ConvertFunction(ConvertFunction<R, S, V> original, Expression<R, ? extends S> expression) {
        super(expression);
        this.converter = original.converter;
    }

    @Override
    public Expression<R, V> recreate(Expression<R, ?>[] effective) {
        Expression<R, ?> e = effective[0];
        if (e instanceof FeatureExpression) {
            Class<?> source;
            Class<V> target = this.getValueClass();
            if (target.isAssignableFrom(source = ((FeatureExpression)e).getValueClass())) {
                return e;
            }
            if (source != Object.class) {
                return new ConvertFunction(e, source, target);
            }
        }
        Class<? super S> source = this.converter.getSourceClass();
        return new ConvertFunction<R, S, V>(this, e.toValueType(source));
    }

    @Override
    public ScopedName getFunctionName() {
        return NAME;
    }

    @Override
    public Set<FunctionProperty> properties() {
        return FunctionProperty.concatenate(ConvertFunction.properties(this.expression), this.converter.properties());
    }

    @Override
    protected Collection<?> getChildren() {
        return List.of(this.expression, this.converter.getSourceClass(), this.converter.getTargetClass());
    }

    @Override
    public V apply(R feature) {
        Object value = this.expression.apply(feature);
        try {
            return this.converter.apply(value);
        }
        catch (UnconvertibleObjectException e) {
            this.warning(e, false);
            return null;
        }
    }

    @Override
    public Class<? extends V> getValueClass() {
        return this.converter.getTargetClass();
    }

    @Override
    public PropertyTypeBuilder expectedType(DefaultFeatureType valueType, FeatureTypeBuilder addTo) {
        FeatureExpression<?, ?> fex = FeatureExpression.castOrCopy(this.expression);
        if (fex == null) {
            return null;
        }
        PropertyTypeBuilder p = fex.expectedType(valueType, addTo);
        if (p instanceof AttributeTypeBuilder) {
            return ((AttributeTypeBuilder)p).setValueClass(this.getValueClass());
        }
        return p;
    }

    @Override
    public <N> Expression<R, N> toValueType(Class<N> target) {
        if (target.isAssignableFrom(this.getValueClass())) {
            return this;
        }
        Class<? super S> source = this.converter.getSourceClass();
        if (target.isAssignableFrom(source)) {
            return this.expression;
        }
        try {
            return new ConvertFunction<R, S, N>(this.expression, source, target);
        }
        catch (UnconvertibleObjectException e) {
            throw (ClassCastException)new ClassCastException(Errors.format((short)8, this.expression.getFunctionName(), target)).initCause(e);
        }
    }
}

