/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid.j2d;

import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.apache.sis.coverage.grid.j2d.FillValues;
import org.apache.sis.coverage.grid.j2d.ImageUtilities;
import org.apache.sis.system.ReferenceQueueConsumer;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.internal.Numerics;

public class TilePlaceholder {
    public static final boolean PENDING_JDK_FIX = true;
    private static final WeakHashSet<TilePlaceholder> CACHE = new WeakHashSet<TilePlaceholder>(TilePlaceholder.class);
    protected final SampleModel model;
    private BufferRef reference;

    protected TilePlaceholder(SampleModel model) {
        ArgumentChecks.ensureNonNull("model", model);
        this.model = model;
    }

    public static TilePlaceholder empty(SampleModel model) {
        return CACHE.unique(new TilePlaceholder(model));
    }

    public static TilePlaceholder filled(SampleModel model, Number fillValue) {
        if (fillValue == null) {
            return TilePlaceholder.empty(model);
        }
        Object[] values = new Number[model.getNumBands()];
        Arrays.fill(values, fillValue);
        return TilePlaceholder.filled(model, new FillValues(model, (Number[])values, true));
    }

    public static TilePlaceholder filled(SampleModel model, FillValues fill) {
        return CACHE.unique(fill.isFullyZero ? new TilePlaceholder(model) : new Filled(model, fill));
    }

    public static TilePlaceholder withCross(RenderedImage image) {
        return CACHE.unique(new WithCross(image));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Raster create(Point location) {
        DataBuffer buffer;
        TilePlaceholder tilePlaceholder = this;
        synchronized (tilePlaceholder) {
            if (this.reference == null || (buffer = (DataBuffer)this.reference.get()) == null) {
                buffer = this.model.createDataBuffer();
                this.reference = new BufferRef(this, buffer);
                if (this.getClass() != TilePlaceholder.class) {
                    WritableRaster tile = Raster.createWritableRaster(this.model, buffer, location);
                    this.draw(tile);
                    return tile;
                }
            }
        }
        return Raster.createRaster(this.model, buffer, location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isCreatorOf(Raster tile) {
        if (tile != null) {
            BufferRef r;
            TilePlaceholder tilePlaceholder = this;
            synchronized (tilePlaceholder) {
                r = this.reference;
            }
            if (r != null) {
                return r.get() == tile.getDataBuffer();
            }
        }
        return false;
    }

    protected void draw(WritableRaster tile) {
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && this.model.equals(((TilePlaceholder)obj).model);
    }

    public int hashCode() {
        return this.getClass().hashCode() - this.model.hashCode();
    }

    private static final class Filled
    extends TilePlaceholder {
        private final FillValues fill;

        Filled(SampleModel model, FillValues fill) {
            super(model);
            this.fill = fill;
        }

        @Override
        protected void draw(WritableRaster tile) {
            this.fill.fill(tile);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.fill.equals(((Filled)obj).fill);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.fill.hashCode();
        }
    }

    private static final class WithCross
    extends TilePlaceholder {
        private final double[] samples;

        WithCross(RenderedImage image) {
            super(image.getSampleModel());
            this.samples = new double[this.model.getNumBands()];
            if (ImageUtilities.isIntegerType(this.model)) {
                boolean isUnsigned = ImageUtilities.isUnsignedType(this.model);
                for (int i = 0; i < this.samples.length; ++i) {
                    int size = this.model.getSampleSize(i);
                    if (!isUnsigned) {
                        --size;
                    }
                    this.samples[i] = Numerics.bitmask(size) - 1L;
                }
            } else {
                ColorSpace cs;
                ColorModel cm = image.getColorModel();
                if (cm != null && (cs = cm.getColorSpace()) != null) {
                    int i = Math.min(cs.getNumComponents(), this.samples.length);
                    while (--i >= 0) {
                        this.samples[i] = cs.getMaxValue(i);
                    }
                } else {
                    Arrays.fill(this.samples, 1.0);
                }
            }
        }

        @Override
        protected void draw(WritableRaster tile) {
            int width = tile.getWidth();
            int height = tile.getHeight();
            int xmin = tile.getMinX();
            int ymin = tile.getMinY();
            int xmax = width + xmin - 1;
            int ymax = height + ymin - 1;
            if (height >= 4) {
                for (int x = xmin; x <= xmax; ++x) {
                    tile.setPixel(x, ymax - 1, this.samples);
                    tile.setPixel(x, ymin, this.samples);
                    if (++x > xmax) break;
                    tile.setPixel(x, ymin + 1, this.samples);
                    tile.setPixel(x, ymax, this.samples);
                }
            }
            if (width >= 4) {
                for (int y = ymin; y <= ymax; ++y) {
                    tile.setPixel(xmax - 1, y, this.samples);
                    tile.setPixel(xmin, y, this.samples);
                    if (++y > ymax) break;
                    tile.setPixel(xmin + 1, y, this.samples);
                    tile.setPixel(xmax, y, this.samples);
                }
            }
            boolean t = true;
            if (width >= height) {
                double step = (double)height / (double)width;
                int m = ymax + ymin;
                for (int x = xmin; x <= xmax; ++x) {
                    int y = ymin + (int)((double)(x - xmin) * step);
                    int s = Math.min(x + 1, xmax);
                    for (int i = Math.max(x - 1, xmin); i <= s; ++i) {
                        tile.setPixel(i, y, this.samples);
                        tile.setPixel(i, m - y, this.samples);
                    }
                }
            } else {
                double step = (double)width / (double)height;
                int m = xmax + xmin;
                for (int y = ymin; y <= ymax; ++y) {
                    int x = xmin + (int)((double)(y - ymin) * step);
                    int s = Math.min(y + 1, ymax);
                    for (int i = Math.max(y - 1, ymin); i <= s; ++i) {
                        tile.setPixel(x, i, this.samples);
                        tile.setPixel(m - x, i, this.samples);
                    }
                }
            }
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Arrays.equals(((WithCross)obj).samples, this.samples);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + Arrays.hashCode(this.samples);
        }
    }

    private static final class BufferRef
    extends WeakReference<DataBuffer>
    implements Disposable {
        private TilePlaceholder owner;

        BufferRef(TilePlaceholder owner, DataBuffer buffer) {
            super(buffer, ReferenceQueueConsumer.QUEUE);
            this.owner = owner;
        }

        @Override
        public void dispose() {
            this.owner = null;
        }
    }
}

