/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactoryBundle;
import net.sf.jasperreports.engine.query.QueryExecuterFactory;
import net.sf.jasperreports.engine.util.JRSingletonCache;

public final class DefaultQueryExecuterFactoryBundle
implements JRQueryExecuterFactoryBundle {
    private static final JRSingletonCache<QueryExecuterFactory> cache = new JRSingletonCache<QueryExecuterFactory>(QueryExecuterFactory.class);
    private static final DefaultQueryExecuterFactoryBundle INSTANCE = new DefaultQueryExecuterFactoryBundle();
    private JasperReportsContext jasperReportsContext;

    private DefaultQueryExecuterFactoryBundle() {
        this(DefaultJasperReportsContext.getInstance());
    }

    private DefaultQueryExecuterFactoryBundle(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public static DefaultQueryExecuterFactoryBundle getInstance() {
        return INSTANCE;
    }

    public static DefaultQueryExecuterFactoryBundle getInstance(JasperReportsContext jasperReportsContext) {
        return new DefaultQueryExecuterFactoryBundle(jasperReportsContext);
    }

    @Override
    public String[] getLanguages() {
        ArrayList<String> languages = new ArrayList<String>();
        List<JRPropertiesUtil.PropertySuffix> properties = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperties("net.sf.jasperreports.query.executer.factory.");
        for (JRPropertiesUtil.PropertySuffix property : properties) {
            languages.add(property.getSuffix());
        }
        return languages.toArray(new String[languages.size()]);
    }

    @Override
    public QueryExecuterFactory getQueryExecuterFactory(String language) throws JRException {
        String factoryClassName = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty("net.sf.jasperreports.query.executer.factory." + language);
        if (factoryClassName == null) {
            return null;
        }
        return cache.getCachedInstance(factoryClassName);
    }
}

