/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import java.util.List;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.export.ooxml.BaseFontHelper;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxParagraphHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxRunHelper;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterInputItem;

public class DocxStyleHelper
extends BaseHelper {
    private final JRDocxExporter exporter;
    private final DocxParagraphHelper paragraphHelper;
    private final DocxRunHelper runHelper;

    public DocxStyleHelper(JRDocxExporter exporter, Writer writer, BaseFontHelper docxFontHelper) {
        super(exporter.getJasperReportsContext(), writer);
        this.exporter = exporter;
        this.paragraphHelper = new DocxParagraphHelper(this.jasperReportsContext, writer, false);
        this.runHelper = new DocxRunHelper(this.jasperReportsContext, writer, docxFontHelper);
    }

    public void export(ExporterInput exporterInput) {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write("<w:styles\n");
        this.write(" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\"\n");
        this.write(" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\">\n");
        this.write(" <w:docDefaults>\n");
        this.write("  <w:rPrDefault>\n");
        this.write("  </w:rPrDefault>\n");
        this.write("  <w:pPrDefault>\n");
        this.write("  <w:pPr>\n");
        this.write("  <w:spacing w:line=\"240\"/>\n");
        this.write("  </w:pPr>\n");
        this.write("  </w:pPrDefault>\n");
        this.write(" </w:docDefaults>\n");
        List<ExporterInputItem> items = exporterInput.getItems();
        for (int reportIndex = 0; reportIndex < items.size(); ++reportIndex) {
            JRStyle[] styles;
            ExporterInputItem item = items.get(reportIndex);
            JasperPrint jasperPrint = item.getJasperPrint();
            if (reportIndex == 0) {
                JRDesignStyle style = new JRDesignStyle(jasperPrint.getDefaultStyleProvider());
                style.setName("EMPTY_CELL_STYLE");
                style.setParentStyle(jasperPrint.getDefaultStyle());
                style.setFontSize(Float.valueOf(0.0f));
                this.exportHeader(jasperPrint.getDefaultStyleProvider(), style);
                this.paragraphHelper.exportProps(style);
                this.runHelper.exportProps(jasperPrint.getDefaultStyleProvider(), style, this.exporter.getLocale());
                this.exportFooter();
            }
            if ((styles = jasperPrint.getStyles()) == null) continue;
            for (int i = 0; i < styles.length; ++i) {
                JRStyle style = styles[i];
                this.exportHeader(jasperPrint.getDefaultStyleProvider(), style);
                this.paragraphHelper.exportProps(style);
                this.runHelper.exportProps(jasperPrint.getDefaultStyleProvider(), style, this.exporter.getLocale());
                this.exportFooter();
            }
        }
        this.write("</w:styles>\n");
    }

    private void exportHeader(JRDefaultStyleProvider defaultStyleProvider, JRStyle style) {
        String styleNameReference;
        this.write(" <w:style w:type=\"paragraph\" w:styleId=\"" + style.getName() + "\"");
        if (style.isDefault()) {
            this.write(" w:default=\"1\"");
        }
        this.write(">\n");
        this.write("  <w:name w:val=\"" + style.getName() + "\" />\n");
        this.write("  <w:qFormat />\n");
        JRStyle baseStyle = defaultStyleProvider.getStyleResolver().getBaseStyle(style);
        String string = styleNameReference = baseStyle == null ? null : baseStyle.getName();
        if (styleNameReference != null) {
            this.write("  <w:basedOn w:val=\"" + styleNameReference + "\" />\n");
        }
    }

    private void exportFooter() {
        this.write(" </w:style>\n");
    }
}

