/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.analytics.dataset;

import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.List;
import net.sf.jasperreports.engine.analytics.dataset.BaseMultiAxisData;
import net.sf.jasperreports.engine.analytics.dataset.DataAxis;
import net.sf.jasperreports.engine.analytics.dataset.DataMeasure;
import net.sf.jasperreports.engine.analytics.dataset.MultiAxisDataset;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;

public class DesignMultiAxisData
extends BaseMultiAxisData
implements JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_DATASET = "dataset";
    public static final String PROPERTY_AXIS_LIST = "axisList";
    public static final String PROPERTY_MEASURES = "measures";
    private transient JRPropertyChangeSupport eventSupport;

    public void setDataset(MultiAxisDataset dataset) {
        MultiAxisDataset old = this.dataset;
        this.dataset = dataset;
        this.getEventSupport().firePropertyChange(PROPERTY_DATASET, old, this.dataset);
    }

    @Override
    public void addDataAxis(DataAxis axis) {
        super.addDataAxis(axis);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_AXIS_LIST, axis, this.getDataAxisList().size() - 1);
    }

    public void removeDataAxis(DataAxis axis) {
        int idx = this.removeDataAxis(axis.getAxis());
        if (idx >= 0) {
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_AXIS_LIST, this.getDataAxisList(), idx);
        }
    }

    @JsonSetter
    private void setMeasures(List<DataMeasure> measures) {
        if (measures != null) {
            for (DataMeasure measure : measures) {
                this.addMeasure(measure);
            }
        }
    }

    public void addMeasure(DataMeasure measure) {
        this.measures.add(measure);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_MEASURES, measure, this.measures.size() - 1);
    }

    public void removeMeasure(DataMeasure measure) {
        int idx = this.measures.indexOf(measure);
        if (idx >= 0) {
            this.measures.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_MEASURES, measure, idx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        DesignMultiAxisData designMultiAxisData = this;
        synchronized (designMultiAxisData) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

