/**
 * Copyright (C) 2006 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * <i>Guice</i> (pronounced "juice"). A lightweight dependency injection
 * container. Features include:
 *
 * <ul>
 *   <li>constructor, method, and field injection</li>
 *   <li>static method and field injection</li>
 *   <li>circular reference support (including constructors if you depend upon
 *    interfaces)</li>
 *   <li>high performance</li>
 *   <li>externalize what needs to be and no more</li>
 * </ul>
 */
package com.opensymphony.xwork2.inject;
