/*
 * Decompiled with CFR 0.152.
 */
package com.google.transconsole.common.messages;

import com.google.gxp.com.google.common.base.CharEscapers;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.transconsole.common.messages.MessageFragment;
import com.google.transconsole.common.messages.TextFragment;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class BaseMessage
implements Iterable<MessageFragment> {
    protected final String id;
    protected final ImmutableList<MessageFragment> fragments;

    BaseMessage(String id, List<MessageFragment> fragments) {
        this.id = id;
        this.fragments = ImmutableList.copyOf(BaseMessage.normalizeFragments(fragments));
    }

    public String getPresentation() {
        StringBuilder sb = new StringBuilder();
        for (MessageFragment f : this.fragments) {
            sb.append(f.getPresentation());
        }
        return sb.toString();
    }

    protected void appendAttribute(StringBuilder sb, String name, String value) {
        if (value == null) {
            return;
        }
        sb.append(" ");
        sb.append(name);
        sb.append("=\"");
        sb.append(CharEscapers.xmlEscaper().escape(value));
        sb.append("\"");
    }

    protected abstract String getFragmentsAsXml();

    protected String collapseXml(String s) {
        return s.trim().replaceAll("\\s+", " ");
    }

    public abstract String toXml();

    public String getId() {
        return this.id;
    }

    public List<MessageFragment> getFragments() {
        return this.fragments;
    }

    @Override
    public Iterator<MessageFragment> iterator() {
        return this.fragments.iterator();
    }

    private static List<MessageFragment> normalizeFragments(List<MessageFragment> input) {
        StringBuilder sb = new StringBuilder();
        ArrayList<MessageFragment> result = Lists.newArrayList();
        for (MessageFragment fragment : input) {
            fragment.partialNormalize(sb, result);
        }
        if (sb.length() > 0) {
            result.add(new TextFragment(sb.toString()));
        }
        return result;
    }
}

