/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.i18ncheck;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.alerts.AlertSetBuilder;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.base.AbbrExpression;
import com.google.gxp.compiler.base.AttrBundleParam;
import com.google.gxp.compiler.base.BoundCall;
import com.google.gxp.compiler.base.Call;
import com.google.gxp.compiler.base.CallVisitor;
import com.google.gxp.compiler.base.Callable;
import com.google.gxp.compiler.base.ContentType;
import com.google.gxp.compiler.base.DefaultingTypeVisitor;
import com.google.gxp.compiler.base.ExhaustiveExpressionVisitor;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.NoMessage;
import com.google.gxp.compiler.base.OutputElement;
import com.google.gxp.compiler.base.Parameter;
import com.google.gxp.compiler.base.PlaceholderEnd;
import com.google.gxp.compiler.base.PlaceholderStart;
import com.google.gxp.compiler.base.Root;
import com.google.gxp.compiler.base.StringConstant;
import com.google.gxp.compiler.base.Template;
import com.google.gxp.compiler.base.Type;
import com.google.gxp.compiler.base.TypeVisitor;
import com.google.gxp.compiler.base.UnboundCall;
import com.google.gxp.compiler.base.UnexpectedNodeException;
import com.google.gxp.compiler.base.UnextractedMessage;
import com.google.gxp.compiler.base.ValidatedCall;
import com.google.gxp.compiler.collapse.SpaceCollapsedTree;
import com.google.gxp.compiler.i18ncheck.I18nCheckedTree;
import com.google.gxp.compiler.i18ncheck.UnextractableContentAlert;
import com.google.gxp.compiler.i18ncheck.UnnecessaryNomsgWarning;
import com.google.gxp.compiler.phpivot.PlaceholderPivotedTree;
import com.google.gxp.compiler.reparent.Attribute;
import com.google.gxp.compiler.schema.AttributeValidator;
import com.google.gxp.compiler.schema.ContentFamily;
import com.google.gxp.compiler.schema.ElementValidator;
import com.google.gxp.compiler.schema.Schema;
import java.util.Map;
import java.util.regex.Pattern;

public class I18nChecker {
    public static final I18nChecker INSTANCE = new I18nChecker();

    private I18nChecker() {
    }

    public I18nCheckedTree apply(SpaceCollapsedTree tree, PlaceholderPivotedTree pivotedTree) {
        AlertSetBuilder alertSetBuilder = new AlertSetBuilder(pivotedTree.getAlerts());
        tree.getRoot().acceptVisitor(new Visitor(alertSetBuilder));
        return new I18nCheckedTree(pivotedTree.getSourcePosition(), alertSetBuilder.buildAndClear(), (Root)pivotedTree.getRoot());
    }

    private static class Visitor
    extends ExhaustiveExpressionVisitor
    implements CallVisitor<Expression> {
        private final AlertSink alertSink;
        private boolean visible = true;
        private boolean insideMsg = false;
        private boolean insidePh = false;
        private boolean insideNoMsg = false;
        private static final Pattern LOCALE_INDEPENDENT_PATTERN = Pattern.compile("[\\s\\xa0]*");
        private static final TypeVisitor<Boolean> TYPE_VISITOR = new DefaultingTypeVisitor<Boolean>(){

            @Override
            public Boolean defaultVisitType(Type type) {
                return true;
            }

            @Override
            public Boolean visitContentType(ContentType type) {
                return Visitor.isSchemaVisible(type.getSchema());
            }
        };

        Visitor(AlertSink alertSink) {
            this.alertSink = Preconditions.checkNotNull(alertSink);
        }

        @Override
        public Template visitTemplate(Template template) {
            boolean oldVisible = this.visible;
            for (Parameter parameter : template.getParameters()) {
                this.visible = Visitor.isTypeVisible(parameter.getType());
                Expression defaultValue = parameter.getDefaultValue();
                if (defaultValue != null) {
                    defaultValue.acceptVisitor(this);
                }
                this.visible = oldVisible;
            }
            this.visible = Visitor.isSchemaVisible(template.getSchema());
            template.getContent().acceptVisitor(this);
            this.visible = oldVisible;
            return template;
        }

        private static boolean isLocaleIndependent(String s) {
            return LOCALE_INDEPENDENT_PATTERN.matcher(s).matches();
        }

        @Override
        public Expression visitStringConstant(StringConstant node) {
            if (!(!this.visible || this.insideMsg && !this.insidePh || this.insideNoMsg || Visitor.isLocaleIndependent(node.evaluate()))) {
                this.alertSink.add(new UnextractableContentAlert(node.getSourcePosition(), node.getDisplayName()));
            }
            return node;
        }

        @Override
        public Expression visitAbbrExpression(AbbrExpression abbr) {
            boolean oldVisible = this.visible;
            this.visible = Visitor.isTypeVisible(abbr.getType());
            this.apply(abbr.getValue());
            this.visible = oldVisible;
            this.apply(abbr.getContent());
            return abbr;
        }

        @Override
        public Expression visitCall(Call call) {
            return call.acceptCallVisitor(this);
        }

        @Override
        public Expression visitBoundCall(BoundCall call) {
            boolean oldVisible = this.visible;
            Callable callee = call.getCallee();
            for (Map.Entry<String, Attribute> param : call.getAttributes().entrySet()) {
                Type type = callee.getParameterByPrimary(param.getKey()).getType();
                this.visible = Visitor.isTypeVisible(type);
                this.visitAttribute(param.getValue());
            }
            this.visible = oldVisible;
            return call;
        }

        @Override
        public Expression visitUnboundCall(UnboundCall call) {
            throw new UnexpectedNodeException(call);
        }

        @Override
        public Expression visitValidatedCall(ValidatedCall call) {
            throw new UnexpectedNodeException(call);
        }

        @Override
        public Expression visitOutputElement(OutputElement element) {
            boolean oldVisible = this.visible;
            ElementValidator elementValidator = element.getValidator();
            boolean oldInsideMsg = this.insideMsg;
            this.insideMsg = false;
            for (Attribute attr : element.getAttributes()) {
                AttributeValidator attrValidator = elementValidator.getAttributeValidator(attr.getName());
                this.visible = attrValidator.isFlagSet(AttributeValidator.Flag.VISIBLETEXT);
                this.visitAttribute(attr);
                this.visible = oldVisible;
            }
            this.insideMsg = oldInsideMsg;
            this.visible &= !elementValidator.isFlagSet(ElementValidator.Flag.INVISIBLEBODY);
            this.apply(element.getContent());
            this.visible = oldVisible;
            return element;
        }

        @Override
        public Expression visitAttrBundleParam(AttrBundleParam bundle) {
            boolean oldVisible = this.visible;
            boolean oldInsideMsg = this.insideMsg;
            this.insideMsg = false;
            for (Map.Entry<AttributeValidator, Attribute> entry : bundle.getAttrs().entrySet()) {
                AttributeValidator attrValidator = entry.getKey();
                this.visible = attrValidator.isFlagSet(AttributeValidator.Flag.VISIBLETEXT);
                this.visitAttribute(entry.getValue());
            }
            this.visible = oldVisible;
            this.insideMsg = oldInsideMsg;
            return bundle;
        }

        @Override
        public Expression visitUnextractedMessage(UnextractedMessage msg) {
            boolean oldInsideMsg = this.insideMsg;
            boolean oldInsidePh = this.insidePh;
            this.insideMsg = true;
            this.insidePh = false;
            super.visitUnextractedMessage(msg);
            this.insideMsg = oldInsideMsg;
            this.insidePh = oldInsidePh;
            return msg;
        }

        @Override
        public Expression visitNoMessage(NoMessage noMsg) {
            if (!this.visible) {
                this.alertSink.add(new UnnecessaryNomsgWarning(noMsg));
            }
            this.insideNoMsg = true;
            super.visitNoMessage(noMsg);
            this.insideNoMsg = false;
            return noMsg;
        }

        @Override
        public Expression visitPlaceholderStart(PlaceholderStart phStart) {
            this.insidePh = true;
            return super.visitPlaceholderStart(phStart);
        }

        @Override
        public Expression visitPlaceholderEnd(PlaceholderEnd phEnd) {
            this.insidePh = false;
            return super.visitPlaceholderEnd(phEnd);
        }

        private static boolean isSchemaVisible(Schema schema) {
            return schema.getContentFamily() == ContentFamily.MARKUP || schema.getContentFamily() == ContentFamily.PLAINTEXT;
        }

        private static boolean isTypeVisible(Type type) {
            return type.acceptTypeVisitor(TYPE_VISITOR);
        }
    }
}

