/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import net.sf.oval.Check;
import net.sf.oval.ConstraintSet;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.ConstraintViolation;
import net.sf.oval.IValidator;
import net.sf.oval.ValidationCycle;
import net.sf.oval.collection.CollectionFactory;
import net.sf.oval.collection.CollectionFactoryJDKImpl;
import net.sf.oval.collection.CollectionFactoryJavolutionImpl;
import net.sf.oval.collection.CollectionFactoryTroveImpl;
import net.sf.oval.configuration.Configurer;
import net.sf.oval.configuration.annotation.AnnotationsConfigurer;
import net.sf.oval.configuration.pojo.elements.ClassConfiguration;
import net.sf.oval.configuration.pojo.elements.ConstraintSetConfiguration;
import net.sf.oval.configuration.pojo.elements.ConstructorConfiguration;
import net.sf.oval.configuration.pojo.elements.FieldConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodConfiguration;
import net.sf.oval.configuration.pojo.elements.ObjectConfiguration;
import net.sf.oval.configuration.pojo.elements.ParameterConfiguration;
import net.sf.oval.constraint.AssertConstraintSetCheck;
import net.sf.oval.constraint.AssertFieldConstraintsCheck;
import net.sf.oval.constraint.AssertValidCheck;
import net.sf.oval.constraint.ConstraintsCheck;
import net.sf.oval.constraint.NotNullCheck;
import net.sf.oval.context.ClassContext;
import net.sf.oval.context.ConstructorParameterContext;
import net.sf.oval.context.FieldContext;
import net.sf.oval.context.IterableElementContext;
import net.sf.oval.context.MapKeyContext;
import net.sf.oval.context.MapValueContext;
import net.sf.oval.context.MethodParameterContext;
import net.sf.oval.context.MethodReturnValueContext;
import net.sf.oval.context.OValContext;
import net.sf.oval.context.ObjectGraphNavigationContext;
import net.sf.oval.exception.ConstraintSetAlreadyDefinedException;
import net.sf.oval.exception.ConstraintsViolatedException;
import net.sf.oval.exception.ExceptionTranslator;
import net.sf.oval.exception.FieldNotFoundException;
import net.sf.oval.exception.InvalidConfigurationException;
import net.sf.oval.exception.MethodNotFoundException;
import net.sf.oval.exception.OValException;
import net.sf.oval.exception.ReflectionException;
import net.sf.oval.exception.UndefinedConstraintSetException;
import net.sf.oval.exception.ValidationFailedException;
import net.sf.oval.expression.ExpressionLanguageRegistry;
import net.sf.oval.guard.ParameterNameResolver;
import net.sf.oval.guard.ParameterNameResolverEnumerationImpl;
import net.sf.oval.internal.ClassChecks;
import net.sf.oval.internal.ContextCache;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.MessageRenderer;
import net.sf.oval.internal.util.ArrayUtils;
import net.sf.oval.internal.util.Assert;
import net.sf.oval.internal.util.CollectionUtils;
import net.sf.oval.internal.util.IdentityHashSet;
import net.sf.oval.internal.util.ReflectionUtils;
import net.sf.oval.internal.util.StringUtils;
import net.sf.oval.localization.context.DefaultOValContextRenderer;
import net.sf.oval.localization.context.OValContextRenderer;
import net.sf.oval.localization.locale.LocaleProvider;
import net.sf.oval.localization.locale.ThreadLocalLocaleProvider;
import net.sf.oval.localization.message.MessageResolver;
import net.sf.oval.localization.message.ResourceBundleMessageResolver;
import net.sf.oval.localization.value.MessageValueFormatter;
import net.sf.oval.localization.value.ToStringMessageValueFormatter;
import net.sf.oval.logging.LoggerFactory;
import net.sf.oval.ogn.ObjectGraphNavigationResult;
import net.sf.oval.ogn.ObjectGraphNavigatorRegistry;

public class Validator
implements IValidator {
    protected static final Check[] EMPTY_CHECKS = new Check[0];
    private static final Log LOG = Log.getLog(Validator.class);
    private static CollectionFactory collectionFactory = Validator._createDefaultCollectionFactory();
    private static OValContextRenderer contextRenderer = DefaultOValContextRenderer.INSTANCE;
    private static LocaleProvider localeProvider = new ThreadLocalLocaleProvider();
    private static MessageResolver messageResolver;
    private static MessageValueFormatter messageValueFormatter;
    private final ConcurrentMap<Class<?>, ClassChecks> checksByClass = collectionFactory.createConcurrentMap();
    private final Set<Configurer> configurers = new LinkedHashSet<Configurer>(4);
    private final Map<String, ConstraintSet> constraintSetsById = collectionFactory.createConcurrentMap(4);
    protected final ThreadLocal<LinkedList<InternalValidationCycle>> currentValidationCycles = ThreadLocal.withInitial(LinkedList::new);
    private ExceptionTranslator exceptionTranslator;
    protected final ExpressionLanguageRegistry expressionLanguageRegistry = new ExpressionLanguageRegistry();
    private final Set<String> disabledProfiles = collectionFactory.createSet();
    private final Set<String> enabledProfiles = collectionFactory.createSet();
    private boolean isAllProfilesEnabledByDefault = true;
    private boolean isProfilesFeatureUsed = false;
    protected final ObjectGraphNavigatorRegistry ognRegistry = new ObjectGraphNavigatorRegistry();
    protected final DelegatingParameterNameResolver parameterNameResolver = new DelegatingParameterNameResolver(new ParameterNameResolverEnumerationImpl());

    static {
        messageValueFormatter = ToStringMessageValueFormatter.INSTANCE;
    }

    private static CollectionFactory _createDefaultCollectionFactory() {
        if (ReflectionUtils.isClassPresent("javolution.util.FastMap") && ReflectionUtils.isClassPresent("javolution.util.FastSet") && ReflectionUtils.isClassPresent("javolution.util.FastTable")) {
            LOG.info("javolution.util collection classes are available.");
            return new CollectionFactoryJavolutionImpl();
        }
        if (ReflectionUtils.isClassPresent("gnu.trove.map.hash.THashMap") && ReflectionUtils.isClassPresent("gnu.trove.set.hash.THashSet")) {
            LOG.info("gnu.trove collection classes are available.");
            return new CollectionFactoryTroveImpl();
        }
        return new CollectionFactoryJDKImpl();
    }

    public static CollectionFactory getCollectionFactory() {
        return collectionFactory;
    }

    public static OValContextRenderer getContextRenderer() {
        return contextRenderer;
    }

    public static LocaleProvider getLocaleProvider() {
        return localeProvider;
    }

    public static LoggerFactory getLoggerFactory() {
        return Log.getLoggerFactory();
    }

    public static MessageResolver getMessageResolver() {
        if (messageResolver == null) {
            messageResolver = ResourceBundleMessageResolver.INSTANCE;
        }
        return messageResolver;
    }

    public static MessageValueFormatter getMessageValueFormatter() {
        return messageValueFormatter;
    }

    public static void setCollectionFactory(CollectionFactory factory) throws IllegalArgumentException {
        Assert.argumentNotNull("factory", factory);
        collectionFactory = factory;
    }

    public static void setContextRenderer(OValContextRenderer contextRenderer) {
        Assert.argumentNotNull("contextRenderer", contextRenderer);
        Validator.contextRenderer = contextRenderer;
    }

    public static void setLocaleProvider(LocaleProvider localeProvider) {
        Assert.argumentNotNull("localeProvider", localeProvider);
        Validator.localeProvider = localeProvider;
    }

    public static void setLoggerFactory(LoggerFactory loggerFactory) {
        Assert.argumentNotNull("loggerFactory", loggerFactory);
        Log.setLoggerFactory(loggerFactory);
    }

    public static void setMessageResolver(MessageResolver messageResolver) throws IllegalArgumentException {
        Assert.argumentNotNull("messageResolver", messageResolver);
        Validator.messageResolver = messageResolver;
    }

    public static void setMessageValueFormatter(MessageValueFormatter formatter) {
        Assert.argumentNotNull("formatter", formatter);
        messageValueFormatter = formatter;
    }

    public Validator() {
        ReflectionUtils.assertPrivateAccessAllowed();
        this.configurers.add(new AnnotationsConfigurer());
    }

    public Validator(Collection<Configurer> configurers) {
        ReflectionUtils.assertPrivateAccessAllowed();
        if (configurers != null) {
            this.configurers.addAll(configurers);
        }
    }

    public Validator(Configurer ... configurers) {
        ReflectionUtils.assertPrivateAccessAllowed();
        if (configurers != null) {
            Collections.addAll(this.configurers, configurers);
        }
    }

    private void _addChecks(ClassChecks cc, ClassConfiguration classCfg) throws InvalidConfigurationException, ReflectionException {
        if (Boolean.TRUE.equals(classCfg.overwrite)) {
            cc.clear();
        }
        if (classCfg.checkInvariants != null) {
            cc.isCheckInvariants = classCfg.checkInvariants;
        }
        boolean applyFieldConstraintsToConstructors = Boolean.TRUE.equals(classCfg.applyFieldConstraintsToConstructors);
        boolean applyFieldConstraintsToSetters = Boolean.TRUE.equals(classCfg.applyFieldConstraintsToSetters);
        boolean assertParametersNotNull = Boolean.TRUE.equals(classCfg.assertParametersNotNull);
        NotNullCheck sharedNotNullCheck = assertParametersNotNull ? new NotNullCheck() : null;
        try {
            if (classCfg.objectConfiguration != null) {
                ObjectConfiguration objectCfg = classCfg.objectConfiguration;
                if (Boolean.TRUE.equals(objectCfg.overwrite)) {
                    cc.clearObjectChecks();
                }
                cc.addObjectChecks(objectCfg.checks);
            }
            if (classCfg.fieldConfigurations != null) {
                for (FieldConfiguration fieldCfg : classCfg.fieldConfigurations) {
                    Field field = classCfg.type.getDeclaredField(fieldCfg.name);
                    if (Boolean.TRUE.equals(fieldCfg.overwrite)) {
                        cc.clearFieldChecks(field);
                    }
                    if (fieldCfg.checks == null || fieldCfg.checks.isEmpty()) continue;
                    cc.addFieldChecks(field, fieldCfg.checks);
                }
            }
            if (classCfg.constructorConfigurations != null) {
                for (ConstructorConfiguration ctorCfg : classCfg.constructorConfigurations) {
                    if (ctorCfg.parameterConfigurations == null) continue;
                    Class[] paramTypes = new Class[ctorCfg.parameterConfigurations.size()];
                    int i = 0;
                    int l = ctorCfg.parameterConfigurations.size();
                    while (i < l) {
                        paramTypes[i] = ctorCfg.parameterConfigurations.get((int)i).type;
                        ++i;
                    }
                    Constructor<?> ctor = classCfg.type.getDeclaredConstructor(paramTypes);
                    if (Boolean.TRUE.equals(ctorCfg.overwrite)) {
                        cc.clearConstructorChecks(ctor);
                    }
                    if (Boolean.TRUE.equals(ctorCfg.postCheckInvariants)) {
                        cc.methodsWithCheckInvariantsPost.add(ctor);
                    }
                    String[] paramNames = this.parameterNameResolver.getParameterNames(ctor);
                    int i2 = 0;
                    int l2 = ctorCfg.parameterConfigurations.size();
                    while (i2 < l2) {
                        Field field;
                        ParameterConfiguration paramCfg = ctorCfg.parameterConfigurations.get(i2);
                        if (Boolean.TRUE.equals(paramCfg.overwrite)) {
                            cc.clearConstructorParameterChecks(ctor, i2);
                        }
                        if (paramCfg.hasChecks()) {
                            cc.addConstructorParameterChecks(ctor, i2, paramCfg.checks);
                        }
                        if (paramCfg.hasCheckExclusions()) {
                            cc.addConstructorParameterCheckExclusions(ctor, i2, paramCfg.checkExclusions);
                        }
                        if (assertParametersNotNull) {
                            cc.addConstructorParameterChecks(ctor, i2, sharedNotNullCheck);
                        }
                        if (applyFieldConstraintsToConstructors && (field = ReflectionUtils.getField(cc.clazz, paramNames[i2])) != null && paramTypes[i2].isAssignableFrom(field.getType())) {
                            AssertFieldConstraintsCheck check = new AssertFieldConstraintsCheck();
                            check.setFieldName(field.getName());
                            cc.addConstructorParameterChecks(ctor, i2, check);
                        }
                        ++i2;
                    }
                }
            }
            if (classCfg.methodConfigurations != null) {
                for (MethodConfiguration methodCfg : classCfg.methodConfigurations) {
                    Field field;
                    Method method;
                    if (methodCfg.parameterConfigurations == null || methodCfg.parameterConfigurations.isEmpty()) {
                        method = classCfg.type.getDeclaredMethod(methodCfg.name, new Class[0]);
                    } else {
                        Class[] paramTypes = new Class[methodCfg.parameterConfigurations.size()];
                        int i = 0;
                        int l = methodCfg.parameterConfigurations.size();
                        while (i < l) {
                            paramTypes[i] = methodCfg.parameterConfigurations.get((int)i).type;
                            ++i;
                        }
                        method = classCfg.type.getDeclaredMethod(methodCfg.name, paramTypes);
                    }
                    if (Boolean.TRUE.equals(methodCfg.overwrite)) {
                        cc.clearMethodChecks(method);
                    }
                    if (applyFieldConstraintsToSetters && (field = ReflectionUtils.getFieldForSetter(method)) != null) {
                        AssertFieldConstraintsCheck check = new AssertFieldConstraintsCheck();
                        check.setFieldName(field.getName());
                        cc.addMethodParameterChecks(method, 0, check);
                    }
                    if (methodCfg.parameterConfigurations != null && !methodCfg.parameterConfigurations.isEmpty()) {
                        int i = 0;
                        int l = methodCfg.parameterConfigurations.size();
                        while (i < l) {
                            ParameterConfiguration paramCfg = methodCfg.parameterConfigurations.get(i);
                            if (Boolean.TRUE.equals(paramCfg.overwrite)) {
                                cc.clearMethodParameterChecks(method, i);
                            }
                            if (paramCfg.hasChecks()) {
                                cc.addMethodParameterChecks(method, i, paramCfg.checks);
                            }
                            if (paramCfg.hasCheckExclusions()) {
                                cc.addMethodParameterCheckExclusions(method, i, paramCfg.checkExclusions);
                            }
                            if (assertParametersNotNull) {
                                cc.addMethodParameterChecks(method, i, sharedNotNullCheck);
                            }
                            ++i;
                        }
                    }
                    if (methodCfg.returnValueConfiguration != null) {
                        if (Boolean.TRUE.equals(methodCfg.returnValueConfiguration.overwrite)) {
                            cc.clearMethodReturnValueChecks(method);
                        }
                        if (methodCfg.returnValueConfiguration.checks != null && !methodCfg.returnValueConfiguration.checks.isEmpty()) {
                            cc.addMethodReturnValueChecks(method, methodCfg.isInvariant, methodCfg.returnValueConfiguration.checks);
                        }
                    }
                    if (Boolean.TRUE.equals(methodCfg.preCheckInvariants)) {
                        cc.methodsWithCheckInvariantsPre.add(method);
                    }
                    if (methodCfg.preExecutionConfiguration != null) {
                        if (Boolean.TRUE.equals(methodCfg.preExecutionConfiguration.overwrite)) {
                            cc.clearMethodPreChecks(method);
                        }
                        if (methodCfg.preExecutionConfiguration.checks != null && !methodCfg.preExecutionConfiguration.checks.isEmpty()) {
                            cc.addMethodPreChecks(method, methodCfg.preExecutionConfiguration.checks);
                        }
                    }
                    if (Boolean.TRUE.equals(methodCfg.postCheckInvariants)) {
                        cc.methodsWithCheckInvariantsPost.add(method);
                    }
                    if (methodCfg.postExecutionConfiguration == null) continue;
                    if (Boolean.TRUE.equals(methodCfg.postExecutionConfiguration.overwrite)) {
                        cc.clearMethodPostChecks(method);
                    }
                    if (methodCfg.postExecutionConfiguration.checks == null || methodCfg.postExecutionConfiguration.checks.isEmpty()) continue;
                    cc.addMethodPostChecks(method, methodCfg.postExecutionConfiguration.checks);
                }
            }
        }
        catch (NoSuchMethodException ex) {
            throw new MethodNotFoundException(ex);
        }
        catch (NoSuchFieldException ex) {
            throw new FieldNotFoundException(ex);
        }
    }

    private void _checkConstraint(Check check, Object validatedObject, Object valueToValidate, InternalValidationCycle cycle) {
        if (check instanceof AssertValidCheck) {
            this.checkConstraintAssertValid(valueToValidate, cycle);
            return;
        }
        if (check instanceof ConstraintsCheck) {
            for (Check innerCheck : ((ConstraintsCheck)check).checks) {
                this.checkConstraint(innerCheck, validatedObject, valueToValidate, cycle.getContext(), cycle, false);
            }
            return;
        }
        if (check instanceof AssertConstraintSetCheck) {
            this.checkConstraintAssertConstraintSet((AssertConstraintSetCheck)check, validatedObject, valueToValidate, cycle);
            return;
        }
        if (check instanceof AssertFieldConstraintsCheck) {
            this.checkConstraintAssertFieldConstraints((AssertFieldConstraintsCheck)check, validatedObject, valueToValidate, cycle);
            return;
        }
        if (!check.isSatisfied(validatedObject, valueToValidate, cycle)) {
            String errorMessage = this.renderMessage(cycle.contextPath, valueToValidate, check.getMessage(), check.getMessageVariables());
            cycle.addConstraintViolation(check, errorMessage, valueToValidate);
        }
    }

    private Class<?> _getContainerElementType(OValContext containerContext, int typeArgumentIndex) {
        if (containerContext instanceof FieldContext) {
            FieldContext ctx = (FieldContext)containerContext;
            return ReflectionUtils.getTypeArgument(ctx.getField(), typeArgumentIndex);
        }
        if (containerContext instanceof MethodParameterContext) {
            MethodParameterContext ctx = (MethodParameterContext)containerContext;
            return ReflectionUtils.getTypeArgument(ctx.getMethod(), ctx.getParameterIndex(), typeArgumentIndex);
        }
        return null;
    }

    private void _validateObjectInvariants(Object validatedObject, Class<?> clazz, InternalValidationCycle cycle) throws ValidationFailedException {
        if (clazz == Object.class) {
            return;
        }
        try {
            Object valueToValidate;
            OValContext ctx;
            Collection checks;
            ClassChecks cc = this.getClassChecks(clazz);
            for (Field field : cc.constrainedFields) {
                checks = cc.checksForFields.get(field);
                if (checks == null || checks.isEmpty()) continue;
                ctx = ContextCache.getFieldContext(field);
                valueToValidate = this.resolveValue((FieldContext)ctx, validatedObject);
                for (Check check : checks) {
                    this.checkConstraint(check, validatedObject, valueToValidate, ctx, cycle, false);
                }
            }
            for (Method getter : cc.constrainedMethods) {
                checks = cc.checksForMethodReturnValues.get(getter);
                if (checks == null || checks.isEmpty()) continue;
                ctx = ContextCache.getMethodReturnValueContext(getter);
                valueToValidate = this.resolveValue((MethodReturnValueContext)ctx, validatedObject);
                for (Check check : checks) {
                    this.checkConstraint(check, validatedObject, valueToValidate, ctx, cycle, false);
                }
            }
            if (!cc.checksForObject.isEmpty()) {
                ClassContext ctx2 = ContextCache.getClassContext(clazz);
                for (Check check : cc.checksForObject) {
                    this.checkConstraint(check, validatedObject, validatedObject, ctx2, cycle, false);
                }
            }
            this._validateObjectInvariants(validatedObject, clazz.getSuperclass(), cycle);
        }
        catch (OValException ex) {
            throw new ValidationFailedException("Object validation failed. Class: " + clazz + " Validated object: " + validatedObject, ex);
        }
    }

    private void _validateStaticInvariants(Class<?> validatedClass, InternalValidationCycle cycle) throws ValidationFailedException {
        Object valueToValidate;
        OValContext ctx;
        Collection checks;
        ClassChecks cc = this.getClassChecks(validatedClass);
        for (Field field : cc.constrainedStaticFields) {
            checks = cc.checksForFields.get(field);
            if (checks == null || checks.isEmpty()) continue;
            ctx = ContextCache.getFieldContext(field);
            valueToValidate = this.resolveValue((FieldContext)ctx, (Object)null);
            for (Check check : checks) {
                this.checkConstraint(check, validatedClass, valueToValidate, ctx, cycle, false);
            }
        }
        for (Method getter : cc.constrainedStaticMethods) {
            checks = cc.checksForMethodReturnValues.get(getter);
            if (checks == null || checks.isEmpty()) continue;
            ctx = ContextCache.getMethodReturnValueContext(getter);
            valueToValidate = this.resolveValue((MethodReturnValueContext)ctx, null);
            for (Check check : checks) {
                this.checkConstraint(check, validatedClass, valueToValidate, ctx, cycle, false);
            }
        }
    }

    public void addChecks(Class<?> clazz, Check ... checks) throws IllegalArgumentException {
        Assert.argumentNotNull("clazz", clazz);
        Assert.argumentNotEmpty("checks", checks);
        this.getClassChecks(clazz).addObjectChecks(checks);
    }

    public void addChecks(Field field, Check ... checks) throws IllegalArgumentException {
        Assert.argumentNotNull("field", field);
        Assert.argumentNotEmpty("checks", checks);
        this.getClassChecks(field.getDeclaringClass()).addFieldChecks(field, checks);
    }

    public void addChecks(Method invariantMethod, Check ... checks) throws IllegalArgumentException, InvalidConfigurationException {
        Assert.argumentNotNull("invariantMethod", invariantMethod);
        Assert.argumentNotEmpty("checks", checks);
        this.getClassChecks(invariantMethod.getDeclaringClass()).addMethodReturnValueChecks(invariantMethod, Boolean.TRUE, checks);
    }

    public void addConstraintSet(ConstraintSet constraintSet, boolean overwrite) throws ConstraintSetAlreadyDefinedException, IllegalArgumentException {
        Assert.argumentNotNull("constraintSet", constraintSet);
        Assert.argumentNotBlank("constraintSet.id", constraintSet.getId());
        if (!overwrite && this.constraintSetsById.containsKey(constraintSet.getId())) {
            throw new ConstraintSetAlreadyDefinedException(constraintSet.getId());
        }
        this.constraintSetsById.put(constraintSet.getId(), constraintSet);
    }

    @Override
    public void assertValid(Object validatedObject) throws ValidationFailedException, ConstraintsViolatedException {
        List<ConstraintViolation> violations = this.validate(validatedObject);
        if (!violations.isEmpty()) {
            throw this.translateException(new ConstraintsViolatedException(violations));
        }
    }

    @Override
    public void assertValidFieldValue(Object validatedObject, Field validatedField, Object fieldValueToValidate) throws ValidationFailedException, ConstraintsViolatedException {
        List<ConstraintViolation> violations = this.validateFieldValue(validatedObject, validatedField, fieldValueToValidate);
        if (!violations.isEmpty()) {
            throw this.translateException(new ConstraintsViolatedException(violations));
        }
    }

    protected void checkConstraint(Check check, Object validatedObject, Object valueToValidate, OValContext context, InternalValidationCycle cycle, boolean isContainerValue) throws OValException {
        boolean isMap;
        boolean isIterable;
        String target;
        if (!(check instanceof ConstraintsCheck) && !this.isAnyProfileEnabled(check.getProfiles(), cycle.profiles)) {
            return;
        }
        if (!check.isActive(validatedObject, valueToValidate, cycle)) {
            return;
        }
        int contextPathElementsAdded = 0;
        cycle.contextPath.add(context);
        ++contextPathElementsAdded;
        if (!isContainerValue && (target = check.getTarget()) != null && (target = target.trim()).length() > 0) {
            String path;
            String ognId;
            if (valueToValidate == null) {
                return;
            }
            List<String> chunks = StringUtils.split(target, ':', 2);
            if (chunks.size() == 1) {
                ognId = "";
                path = chunks.get(0);
            } else {
                ognId = chunks.get(0);
                path = chunks.get(1);
            }
            ObjectGraphNavigationResult ognResult = this.ognRegistry.getObjectGraphNavigator(ognId).navigateTo(valueToValidate, path);
            if (ognResult == null) {
                return;
            }
            if (ognResult.path.indexOf(46) > -1) {
                cycle.contextPath.add(new ObjectGraphNavigationContext(StringUtils.substringBeforeLast(path, '.')));
                ++contextPathElementsAdded;
            }
            validatedObject = ognResult.targetParent;
            valueToValidate = ognResult.target;
            context = ognResult.targetAccessor instanceof Field ? ContextCache.getFieldContext((Field)ognResult.targetAccessor) : ContextCache.getMethodReturnValueContext((Method)ognResult.targetAccessor);
            cycle.contextPath.add(context);
            ++contextPathElementsAdded;
        }
        Class<?> compileTimeType = context.getCompileTimeType();
        boolean bl = valueToValidate == null ? compileTimeType != null && Iterable.class.isAssignableFrom(compileTimeType) : (isIterable = valueToValidate instanceof Iterable);
        boolean bl2 = !isIterable && (valueToValidate == null ? compileTimeType != null && Map.class.isAssignableFrom(compileTimeType) : valueToValidate instanceof Map) ? true : (isMap = false);
        boolean isArray = !isIterable && !isMap && (valueToValidate == null ? compileTimeType != null && compileTimeType.isArray() : valueToValidate.getClass().isArray());
        boolean isContainer = isIterable || isMap || isArray;
        ConstraintTarget[] targets = check.getAppliesTo();
        if (isContainer && valueToValidate != null) {
            if (isIterable) {
                if (ArrayUtils.containsSame(targets, ConstraintTarget.VALUES) && (!isContainerValue || ArrayUtils.containsSame(targets, ConstraintTarget.RECURSIVE))) {
                    int i2 = 0;
                    Class<?> clazz = this._getContainerElementType(context, 0);
                    for (Object item2 : (Iterable)valueToValidate) {
                        IterableElementContext ctx = new IterableElementContext(clazz, i2);
                        this.checkConstraint(check, validatedObject, item2, ctx, cycle, true);
                        ++i2;
                    }
                }
            } else if (isMap) {
                OValContext ctx;
                if (ArrayUtils.containsSame(targets, ConstraintTarget.KEYS) && (!isContainerValue || ArrayUtils.containsSame(targets, ConstraintTarget.RECURSIVE))) {
                    Class<?> elementType2 = this._getContainerElementType(context, 0);
                    for (Object object : ((Map)valueToValidate).keySet()) {
                        ctx = new MapKeyContext(elementType2, object);
                        this.checkConstraint(check, validatedObject, object, ctx, cycle, true);
                    }
                }
                if (ArrayUtils.containsSame(targets, ConstraintTarget.VALUES) && (!isContainerValue || ArrayUtils.containsSame(targets, ConstraintTarget.RECURSIVE))) {
                    Class<?> elementType = this._getContainerElementType(context, 1);
                    for (Map.Entry entry : ((Map)valueToValidate).entrySet()) {
                        ctx = new MapValueContext(elementType, entry.getKey());
                        this.checkConstraint(check, validatedObject, entry.getValue(), ctx, cycle, true);
                    }
                }
            } else if (ArrayUtils.containsSame(targets, ConstraintTarget.VALUES) && (!isContainerValue || ArrayUtils.containsSame(targets, ConstraintTarget.RECURSIVE))) {
                Object fValidatedObject = validatedObject;
                Class<?> clazz = valueToValidate.getClass().getComponentType();
                ArrayUtils.iterate(valueToValidate, (i, item) -> {
                    IterableElementContext ctx = new IterableElementContext(elementType, (int)i);
                    this.checkConstraint(check, fValidatedObject, item, ctx, cycle, true);
                });
            }
        }
        if (isContainerValue || !isContainer || isContainer && ArrayUtils.containsSame(targets, ConstraintTarget.CONTAINER)) {
            this._checkConstraint(check, validatedObject, valueToValidate, cycle);
        }
        int i3 = 0;
        while (i3 < contextPathElementsAdded) {
            CollectionUtils.removeLast(cycle.contextPath);
            ++i3;
        }
    }

    protected void checkConstraintAssertConstraintSet(AssertConstraintSetCheck check, Object validatedObject, Object valueToValidate, InternalValidationCycle cycle) throws OValException {
        ConstraintSet cs = this.getConstraintSet(check.getId());
        if (cs == null) {
            throw new UndefinedConstraintSetException(check.getId());
        }
        Collection<Check> referencedChecks = cs.getChecks();
        if (referencedChecks != null && !referencedChecks.isEmpty()) {
            OValContext context = CollectionUtils.removeLast(cycle.contextPath);
            for (Check referencedCheck : referencedChecks) {
                this.checkConstraint(referencedCheck, validatedObject, valueToValidate, context, cycle, false);
            }
            cycle.contextPath.add(context);
        }
    }

    protected void checkConstraintAssertFieldConstraints(AssertFieldConstraintsCheck check, Object validatedObject, Object valueToValidate, InternalValidationCycle cycle) throws OValException {
        Field field;
        OValContext context = CollectionUtils.removeLast(cycle.contextPath);
        Class<?> targetClass = check.getDeclaringClass() != null && check.getDeclaringClass() != Void.class ? check.getDeclaringClass() : (context instanceof ConstructorParameterContext ? ((ConstructorParameterContext)context).getConstructor().getDeclaringClass() : (context instanceof MethodParameterContext ? ((MethodParameterContext)context).getMethod().getDeclaringClass() : (context instanceof MethodReturnValueContext ? ((MethodReturnValueContext)context).getMethod().getDeclaringClass() : validatedObject.getClass())));
        String fieldName = check.getFieldName();
        if (fieldName == null || fieldName.length() == 0) {
            if (context instanceof ConstructorParameterContext) {
                fieldName = ((ConstructorParameterContext)context).getParameterName();
            } else if (context instanceof MethodParameterContext) {
                fieldName = ((MethodParameterContext)context).getParameterName();
            } else if (context instanceof MethodReturnValueContext) {
                fieldName = ReflectionUtils.guessFieldName(((MethodReturnValueContext)context).getMethod());
            }
        }
        if ((field = ReflectionUtils.getFieldRecursive(targetClass, fieldName)) == null) {
            throw new FieldNotFoundException("Field <" + fieldName + "> not found in class <" + targetClass + "> or its super classes.");
        }
        ClassChecks cc = this.getClassChecks(field.getDeclaringClass());
        Collection referencedChecks = cc.checksForFields.get(field);
        if (referencedChecks != null && !referencedChecks.isEmpty()) {
            for (Check referencedCheck : referencedChecks) {
                this.checkConstraint(referencedCheck, validatedObject, valueToValidate, context, cycle, false);
            }
        }
        cycle.contextPath.add(context);
    }

    protected void checkConstraintAssertValid(Object valueToValidate, InternalValidationCycle cycle) throws OValException {
        if (valueToValidate == null) {
            return;
        }
        if (this.isCurrentlyValidated(valueToValidate)) {
            return;
        }
        this.validateInvariants(valueToValidate, cycle);
    }

    public synchronized void disableAllProfiles() {
        this.isProfilesFeatureUsed = true;
        this.isAllProfilesEnabledByDefault = false;
        this.enabledProfiles.clear();
        this.disabledProfiles.clear();
    }

    public void disableProfile(String profile) {
        this.isProfilesFeatureUsed = true;
        if (this.isAllProfilesEnabledByDefault) {
            this.disabledProfiles.add(profile);
        } else {
            this.enabledProfiles.remove(profile);
        }
    }

    public synchronized void enableAllProfiles() {
        this.isProfilesFeatureUsed = true;
        this.isAllProfilesEnabledByDefault = true;
        this.enabledProfiles.clear();
        this.disabledProfiles.clear();
    }

    public void enableProfile(String profile) {
        this.isProfilesFeatureUsed = true;
        if (this.isAllProfilesEnabledByDefault) {
            this.disabledProfiles.remove(profile);
        } else {
            this.enabledProfiles.add(profile);
        }
    }

    protected void finalize() throws Throwable {
        try {
            ContextCache.clear();
        }
        finally {
            super.finalize();
        }
    }

    public Check[] getChecks(Class<?> clazz) throws IllegalArgumentException {
        Assert.argumentNotNull("clazz", clazz);
        ClassChecks cc = this.getClassChecks(clazz);
        Set<Check> checks = cc.checksForObject;
        return checks == null ? EMPTY_CHECKS : checks.toArray(new Check[checks.size()]);
    }

    public Check[] getChecks(Field field) throws IllegalArgumentException {
        Assert.argumentNotNull("field", field);
        ClassChecks cc = this.getClassChecks(field.getDeclaringClass());
        Set<Check> checks = cc.checksForFields.get(field);
        return checks == null ? EMPTY_CHECKS : checks.toArray(new Check[checks.size()]);
    }

    public Check[] getChecks(Method method) throws IllegalArgumentException {
        Assert.argumentNotNull("method", method);
        ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
        Set<Check> checks = cc.checksForMethodReturnValues.get(method);
        return checks == null ? EMPTY_CHECKS : checks.toArray(new Check[checks.size()]);
    }

    protected ClassChecks getClassChecks(Class<?> clazz) throws IllegalArgumentException, InvalidConfigurationException, ReflectionException {
        Assert.argumentNotNull("clazz", clazz);
        return this.checksByClass.computeIfAbsent(clazz, k -> {
            ClassChecks newCC = new ClassChecks((Class<?>)k, this.parameterNameResolver);
            for (Configurer configurer : this.configurers) {
                ClassConfiguration classConfig = configurer.getClassConfiguration((Class<?>)k);
                if (classConfig == null) continue;
                this._addChecks(newCC, classConfig);
            }
            return newCC;
        });
    }

    public ConstraintSet getConstraintSet(String constraintSetId) throws InvalidConfigurationException, IllegalArgumentException {
        Assert.argumentNotNull("constraintSetId", constraintSetId);
        ConstraintSet cs = this.constraintSetsById.get(constraintSetId);
        if (cs == null) {
            for (Configurer configurer : this.configurers) {
                ConstraintSetConfiguration csc = configurer.getConstraintSetConfiguration(constraintSetId);
                if (csc == null) continue;
                cs = new ConstraintSet(csc.id);
                cs.setChecks(csc.checks);
                this.addConstraintSet(cs, csc.overwrite != null && csc.overwrite != false);
            }
        }
        return cs;
    }

    public ExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }

    public ExpressionLanguageRegistry getExpressionLanguageRegistry() {
        return this.expressionLanguageRegistry;
    }

    public ObjectGraphNavigatorRegistry getObjectGraphNavigatorRegistry() {
        return this.ognRegistry;
    }

    protected boolean isAnyProfileEnabled(String[] profilesOfCheck, String[] enabledProfiles) {
        if (enabledProfiles == null) {
            if (profilesOfCheck == null || profilesOfCheck.length == 0) {
                return this.isProfileEnabled("default");
            }
            String[] stringArray = profilesOfCheck;
            int n = profilesOfCheck.length;
            int n2 = 0;
            while (n2 < n) {
                String profile = stringArray[n2];
                if (this.isProfileEnabled(profile)) {
                    return true;
                }
                ++n2;
            }
        } else {
            if (profilesOfCheck == null || profilesOfCheck.length == 0) {
                return ArrayUtils.containsEqual(enabledProfiles, "default");
            }
            String[] stringArray = profilesOfCheck;
            int n = profilesOfCheck.length;
            int n3 = 0;
            while (n3 < n) {
                String profile = stringArray[n3];
                if (ArrayUtils.containsEqual(enabledProfiles, profile)) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    protected boolean isCurrentlyValidated(Object object) {
        Assert.argumentNotNull("object", object);
        LinkedList<InternalValidationCycle> cycles = this.currentValidationCycles.get();
        return !cycles.isEmpty() && cycles.getLast().validatedObjects.contains(object);
    }

    public boolean isProfileEnabled(String profileId) {
        Assert.argumentNotNull("profileId", profileId);
        if (this.isProfilesFeatureUsed) {
            if (this.isAllProfilesEnabledByDefault) {
                return !this.disabledProfiles.contains(profileId);
            }
            return this.enabledProfiles.contains(profileId);
        }
        return true;
    }

    public void reconfigureChecks() {
        this.checksByClass.clear();
        this.constraintSetsById.clear();
    }

    public void removeChecks(Class<?> clazz, Check ... checks) throws IllegalArgumentException {
        Assert.argumentNotNull("clazz", clazz);
        Assert.argumentNotEmpty("checks", checks);
        this.getClassChecks(clazz).removeObjectChecks(checks);
    }

    public void removeChecks(Field field, Check ... checks) throws IllegalArgumentException {
        Assert.argumentNotNull("field", field);
        Assert.argumentNotEmpty("checks", checks);
        this.getClassChecks(field.getDeclaringClass()).removeFieldChecks(field, checks);
    }

    public void removeChecks(Method getter, Check ... checks) throws IllegalArgumentException {
        Assert.argumentNotNull("getter", getter);
        Assert.argumentNotEmpty("checks", checks);
        this.getClassChecks(getter.getDeclaringClass()).removeMethodReturnValueChecks(getter, checks);
    }

    public ConstraintSet removeConstraintSet(String id) throws IllegalArgumentException {
        Assert.argumentNotNull("id", id);
        return this.constraintSetsById.remove(id);
    }

    protected String renderMessage(List<OValContext> contextPath, Object invalidValue, String messageKey, Map<String, ?> messageValues) {
        String message = MessageRenderer.renderMessage(messageKey, messageValues);
        if (message.indexOf(123) == -1) {
            return message;
        }
        message = StringUtils.replaceAll(message, "{context}", contextRenderer.render(contextPath));
        message = StringUtils.replaceAll(message, "{invalidValue}", messageValueFormatter.format(invalidValue));
        return message;
    }

    @Deprecated
    public void reportConstraintViolation(ConstraintViolation constraintViolation) throws IllegalStateException {
        Assert.argumentNotNull("constraintViolation", constraintViolation);
        if (this.currentValidationCycles.get().isEmpty()) {
            throw new IllegalStateException("No active validation cycle found for the current thread.");
        }
        this.currentValidationCycles.get().getLast().addConstraintViolation(constraintViolation);
    }

    protected Object resolveValue(FieldContext ctx, Object validatedObject) {
        return ReflectionUtils.getFieldValue(ctx.getField(), validatedObject);
    }

    protected Object resolveValue(MethodReturnValueContext ctx, Object validatedObject) {
        return ReflectionUtils.invokeMethod(ctx.getMethod(), validatedObject, new Object[0]);
    }

    public void setExceptionTranslator(ExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
    }

    protected RuntimeException translateException(OValException ex) {
        RuntimeException rex;
        if (this.exceptionTranslator != null && (rex = this.exceptionTranslator.translateException(ex)) != null) {
            return rex;
        }
        return ex;
    }

    @Override
    public List<ConstraintViolation> validate(Object validatedObject) throws ValidationFailedException {
        Assert.argumentNotNull("validatedObject", validatedObject);
        InternalValidationCycle cycle = new InternalValidationCycle(validatedObject, null);
        this.currentValidationCycles.get().add(cycle);
        try {
            this.validateInvariants(validatedObject, cycle);
            List<ConstraintViolation> list = cycle.violations;
            return list;
        }
        finally {
            this.currentValidationCycles.get().removeLast();
        }
    }

    @Override
    public List<ConstraintViolation> validate(Object validatedObject, String ... profiles) throws ValidationFailedException {
        Assert.argumentNotNull("validatedObject", validatedObject);
        InternalValidationCycle cycle = new InternalValidationCycle(validatedObject, profiles);
        this.currentValidationCycles.get().add(cycle);
        try {
            this.validateInvariants(validatedObject, cycle);
            List<ConstraintViolation> list = cycle.violations;
            return list;
        }
        finally {
            this.currentValidationCycles.get().removeLast();
        }
    }

    @Override
    public List<ConstraintViolation> validateFieldValue(Object validatedObject, Field validatedField, Object fieldValueToValidate) throws ValidationFailedException {
        Assert.argumentNotNull("validatedObject", validatedObject);
        Assert.argumentNotNull("validatedField", validatedField);
        InternalValidationCycle cycle = new InternalValidationCycle(validatedObject, null);
        this.currentValidationCycles.get().add(cycle);
        try {
            ClassChecks cc = this.getClassChecks(validatedField.getDeclaringClass());
            Collection checks = cc.checksForFields.get(validatedField);
            if (checks == null || checks.isEmpty()) {
                List<ConstraintViolation> list = cycle.violations;
                return list;
            }
            FieldContext context = ContextCache.getFieldContext(validatedField);
            for (Check check : checks) {
                this.checkConstraint(check, validatedObject, fieldValueToValidate, context, cycle, false);
            }
            List<ConstraintViolation> list = cycle.violations;
            return list;
        }
        catch (OValException ex) {
            throw new ValidationFailedException("Field validation failed. Field: " + validatedField + " Validated object: " + validatedObject, ex);
        }
        finally {
            this.currentValidationCycles.get().removeLast();
        }
    }

    protected void validateInvariants(Object validatedObject, InternalValidationCycle cycle) throws ValidationFailedException {
        this.currentValidationCycles.get().getLast().validatedObjects.add(validatedObject);
        if (validatedObject instanceof Class) {
            this._validateStaticInvariants((Class)validatedObject, cycle);
        } else {
            this._validateObjectInvariants(validatedObject, validatedObject.getClass(), cycle);
        }
    }

    protected static final class DelegatingParameterNameResolver
    implements ParameterNameResolver {
        private ParameterNameResolver delegate;

        public DelegatingParameterNameResolver(ParameterNameResolver delegate) {
            this.delegate = delegate;
        }

        public ParameterNameResolver getDelegate() {
            return this.delegate;
        }

        @Override
        public String[] getParameterNames(Constructor<?> constructor) throws ReflectionException {
            return this.delegate.getParameterNames(constructor);
        }

        @Override
        public String[] getParameterNames(Method method) throws ReflectionException {
            return this.delegate.getParameterNames(method);
        }

        public void setDelegate(ParameterNameResolver delegate) {
            this.delegate = delegate;
        }
    }

    protected final class InternalValidationCycle
    implements ValidationCycle {
        public final String[] profiles;
        public IdentityHashSet<Object> validatedObjects = new IdentityHashSet(4);
        public final Object rootValidatedObject;
        public List<ConstraintViolation> violations = Collections.emptyList();
        public final List<OValContext> contextPath = Validator.access$0().createList(4);
        public final List<OValContext> contextPathImmutable = Collections.unmodifiableList(this.contextPath);

        public InternalValidationCycle(Object rootValidatedObject, String[] profiles) {
            this.profiles = profiles;
            this.rootValidatedObject = rootValidatedObject;
        }

        @Override
        public void addConstraintViolation(Check check, String message, Object invalidValue) {
            this.addConstraintViolation(new ConstraintViolation(check, message, this.rootValidatedObject, invalidValue, this.contextPathImmutable));
        }

        @Override
        public void addConstraintViolation(ConstraintViolation violation) {
            if (this.violations.isEmpty()) {
                this.violations = collectionFactory.createList();
            }
            this.violations.add(violation);
        }

        @Override
        public List<OValContext> getContextPath() {
            return this.contextPathImmutable;
        }

        @Override
        public Object getRootObject() {
            return this.rootValidatedObject;
        }

        @Override
        public Validator getValidator() {
            return Validator.this;
        }
    }
}

