/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype;

import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.nodetype.NodeTypeDefDiff;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.nodetype.TypeEditor;
import org.apache.jackrabbit.oak.plugins.nodetype.TypeRegistration;
import org.apache.jackrabbit.oak.plugins.tree.factories.RootFactory;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.commit.VisibleEditor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={EditorProvider.class})
public class TypeEditorProvider
implements EditorProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TypeEditorProvider.class);
    private final boolean strict;

    public TypeEditorProvider(boolean strict) {
        this.strict = strict;
    }

    public TypeEditorProvider() {
        this(true);
    }

    @Override
    public Editor getRootEditor(NodeState before, NodeState after, NodeBuilder builder, CommitInfo info) throws CommitFailedException {
        NodeState beforeTypes = before.getChildNode("jcr:system").getChildNode("jcr:nodeTypes");
        NodeState afterTypes = after.getChildNode("jcr:system").getChildNode("jcr:nodeTypes");
        String primary = after.getName("jcr:primaryType");
        Iterable<String> mixins = after.getNames("jcr:mixinTypes");
        TypeRegistration registration = new TypeRegistration();
        afterTypes.compareAgainstBaseState(beforeTypes, registration);
        if (registration.isModified()) {
            ReadOnlyNodeTypeManager ntBefore = ReadOnlyNodeTypeManager.getInstance(RootFactory.createReadOnlyRoot(before), NamePathMapper.DEFAULT);
            ReadOnlyNodeTypeManager ntAfter = ReadOnlyNodeTypeManager.getInstance(RootFactory.createReadOnlyRoot(after), NamePathMapper.DEFAULT);
            afterTypes = registration.apply(builder);
            Set<String> modifiedTypes = registration.getModifiedTypes(beforeTypes);
            if (!modifiedTypes.isEmpty()) {
                boolean modified = false;
                for (String t : modifiedTypes) {
                    boolean mod = !this.isTrivialChange(ntBefore, ntAfter, t);
                    modified = modified || mod;
                }
                if (!modified) {
                    LOG.info("Node type changes: " + String.valueOf(modifiedTypes) + " appear to be trivial, repository will not be scanned");
                } else {
                    TypeEditor.ConstraintViolationCallback callback = this.strict ? TypeEditor.THROW_ON_CONSTRAINT_VIOLATION : TypeEditor.WARN_ON_CONSTRAINT_VIOLATION;
                    long start = System.currentTimeMillis();
                    VisibleEditor editor = new VisibleEditor(new TypeEditor(callback, modifiedTypes, afterTypes, primary, mixins, builder));
                    LOG.info("Node type changes: " + String.valueOf(modifiedTypes) + " appear not to be trivial, starting repository scan");
                    CommitFailedException exception = EditorDiff.process(editor, EmptyNodeState.MISSING_NODE, after);
                    LOG.info("Node type changes: " + String.valueOf(modifiedTypes) + "; repository scan took " + (System.currentTimeMillis() - start) + "ms" + (String)(exception == null ? "" : "; failed with " + exception.getMessage()));
                    if (exception != null) {
                        throw exception;
                    }
                }
            }
        }
        TypeEditor.ConstraintViolationCallback callback = this.strict ? TypeEditor.THROW_ON_CONSTRAINT_VIOLATION : TypeEditor.WARN_ON_CONSTRAINT_VIOLATION;
        return new VisibleEditor(new TypeEditor(callback, null, afterTypes, primary, mixins, builder));
    }

    private boolean isTrivialChange(ReadOnlyNodeTypeManager ntBefore, ReadOnlyNodeTypeManager ntAfter, String nodeType) {
        NodeType na;
        NodeType nb;
        try {
            nb = ntBefore.getNodeType(nodeType);
        }
        catch (NoSuchNodeTypeException ex) {
            LOG.info(nodeType + " not present in 'before' state");
            return true;
        }
        catch (RepositoryException ex) {
            LOG.info("getting node type", (Throwable)ex);
            return false;
        }
        try {
            na = ntAfter.getNodeType(nodeType);
        }
        catch (NoSuchNodeTypeException ex) {
            LOG.info(nodeType + " was removed");
            return false;
        }
        catch (RepositoryException ex) {
            LOG.info("getting node type", (Throwable)ex);
            return false;
        }
        NodeTypeDefDiff diff = NodeTypeDefDiff.create((NodeTypeDefinition)nb, (NodeTypeDefinition)na);
        if (!diff.isModified()) {
            LOG.info("Node type " + nodeType + " was not changed");
            return true;
        }
        if (diff.isTrivial()) {
            LOG.info("Node type change for " + nodeType + " appears to be trivial");
            return true;
        }
        LOG.info("Node type change for " + nodeType + " requires repository scan: " + String.valueOf(diff));
        return false;
    }
}

