/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sling.testing.resourceresolver;

import java.io.IOException;

import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RootResourceTypeTest {

    private ResourceResolver resourceResolver;

    @Before
    public final void setUp() throws IOException, LoginException {
        resourceResolver = createResourceResolver();
    }

    protected ResourceResolver createResourceResolver() throws LoginException {
        return new MockResourceResolverFactory().getResourceResolver(null);
    }

    @Test
    @SuppressWarnings("null")
    public void testIsResourceResolver() {
        Resource root = resourceResolver.getResource("/");
        Assert.assertTrue(root.isResourceType("rep:root"));
    }

    @Test
    public void testGetRootParent() {
        Resource rootParent = resourceResolver.getResource("/..");
        Assert.assertNull(rootParent);
    }
}
