/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlethelpers.internalrequests;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseInternalRequest {
    protected final ResourceResolver resourceResolver;
    protected final String path;
    protected String selectorString;
    protected String extension;
    protected String requestMethod = "GET";
    protected String contentType;
    protected Reader bodyReader;
    protected boolean explicitStatusCheck;
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String DEFAULT_METHOD = "GET";
    public static final String MDC_KEY = "sling." + BaseInternalRequest.class.getSimpleName();

    protected BaseInternalRequest(@NotNull ResourceResolver resourceResolver, @NotNull String path) {
        this.checkNotNull(ResourceResolver.class, (Object)resourceResolver);
        this.checkNotNull("path", (Object)path);
        this.resourceResolver = resourceResolver;
        this.path = path;
    }

    protected void checkNotNull(String info, Object candidate) {
        if (candidate == null) {
            throw new IllegalArgumentException(info + " is null");
        }
    }

    protected void checkNotNull(Class<?> clazz, Object candidate) {
        this.checkNotNull(clazz.getSimpleName(), candidate);
    }

    public BaseInternalRequest withRequestMethod(String method) {
        this.requestMethod = method.toUpperCase();
        return this;
    }

    public BaseInternalRequest withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public BaseInternalRequest withBody(Reader bodyContent) {
        this.bodyReader = bodyContent;
        return this;
    }

    public BaseInternalRequest withSelectors(String ... selectors) {
        if (selectors == null) {
            return this;
        }
        StringBuilder sb = new StringBuilder();
        Arrays.stream(selectors).forEach(sel -> sb.append(sb.isEmpty() ? "" : ".").append((String)sel));
        this.selectorString = sb.toString();
        return this;
    }

    public BaseInternalRequest withExtension(String extension) {
        this.extension = extension;
        return this;
    }

    public BaseInternalRequest withParameter(String key, Object value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("Null key or value");
        }
        this.parameters.put(key, value);
        return this;
    }

    public BaseInternalRequest withParameters(Map<String, Object> additionalParameters) {
        if (additionalParameters != null) {
            this.parameters.putAll(additionalParameters);
        }
        return this;
    }

    public abstract BaseInternalRequest execute() throws IOException;

    protected abstract Resource getExecutionResource();

    protected abstract void assertRequestExecuted() throws IOException;

    public abstract BaseInternalRequest checkResponseContentType(String var1) throws IOException;

    public BaseInternalRequest checkStatus(int ... acceptableValues) throws IOException {
        this.assertRequestExecuted();
        this.explicitStatusCheck = true;
        if (acceptableValues == null || acceptableValues.length == 0) {
            return this;
        }
        int actualStatus = this.getStatus();
        OptionalInt found = Arrays.stream(acceptableValues).filter(expected -> expected == actualStatus).findFirst();
        if (!found.isPresent()) {
            String sb = Arrays.stream(acceptableValues).mapToObj(String::valueOf).collect(Collectors.joining(","));
            throw new IOException("Unexpected response status " + actualStatus + ", expected one of '" + sb + "'");
        }
        return this;
    }

    public abstract int getStatus() throws IOException;

    public abstract String getResponseAsString() throws IOException;
}

