/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.registration.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import javax.jcr.Repository;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.server.ServerAdapterFactory;
import org.apache.sling.jcr.registration.AbstractRegistrationSupport;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.propertytypes.ServiceDescription;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, name="org.apache.sling.jcr.jackrabbit.server.RmiRegistrationSupport", reference={@Reference(name="Repository", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, service=Repository.class)})
@Designate(ocd=Configuration.class)
@ServiceDescription(value="RMI based Repository Registration")
public class RmiRegistrationSupport
extends AbstractRegistrationSupport {
    public static final String PROP_REGISTRY_PORT = "port";
    private int registryPort;
    private Registry registry;
    private boolean registryIsPrivate;

    @Override
    protected boolean doActivate() {
        Object portProp = this.getComponentContext().getProperties().get(PROP_REGISTRY_PORT);
        if (portProp instanceof Number) {
            this.registryPort = ((Number)portProp).intValue();
        } else {
            try {
                this.registryPort = Integer.parseInt(String.valueOf(portProp));
            }
            catch (NumberFormatException nfe) {
                this.registryPort = 0;
            }
        }
        if (this.registryPort < 0) {
            this.logger.warn("RMI registry disabled (no or negative RMI port configured)");
            return false;
        }
        if (this.registryPort == 0) {
            this.registryPort = 1099;
        } else if (this.registryPort > 65535) {
            this.logger.warn("Illegal RMI registry port number {} disabling RMI registry", (Object)this.registryPort);
            return false;
        }
        this.logger.info("Using RMI Registry port {}", (Object)this.registryPort);
        return true;
    }

    @Override
    protected void doDeactivate() {
        if (this.registry != null && this.registryIsPrivate) {
            try {
                UnicastRemoteObject.unexportObject(this.registry, true);
                this.logger.info("Unexported private RMI Registry at {}", (Object)this.registryPort);
            }
            catch (NoSuchObjectException nsoe) {
                this.logger.info("Cannot unexport private RMI Registry reference", (Object)nsoe);
            }
        }
        this.registry = null;
    }

    @Override
    protected Object bindRepository(String name, Repository repository) {
        return new RmiRegistration(name, repository);
    }

    @Override
    protected void unbindRepository(String name, Object data) {
        RmiRegistration rr = (RmiRegistration)data;
        rr.unregister();
    }

    private Registry getPrivateRegistry() {
        if (this.registry == null) {
            try {
                this.registry = LocateRegistry.createRegistry(this.registryPort);
                this.registryIsPrivate = true;
                this.logger.info("Using private RMI Registry at {}", (Object)this.registryPort);
            }
            catch (RemoteException re) {
                this.logger.info("Cannot create private registry, trying existing registry at {}, reason: {}", (Object)this.registryPort, (Object)re);
                try {
                    this.registry = LocateRegistry.getRegistry(this.registryPort);
                    this.registryIsPrivate = false;
                    this.logger.info("Trying existing registry at {}", (Object)this.registryPort);
                }
                catch (RemoteException pre) {
                    this.logger.error("Cannot get existing registry, will not register repositories on RMI", (Object)pre);
                }
            }
        }
        return this.registry;
    }

    protected RemoteAdapterFactory getRemoteAdapterFactory() {
        return new ServerAdapterFactory();
    }

    @Override
    @Reference(service=LoggerFactory.class)
    protected void bindLogger(Logger logger) {
        super.bindLogger(logger);
    }

    private class RmiRegistration {
        private String rmiName;
        private Remote rmiRepository;

        RmiRegistration(String rmiName, Repository repository) {
            this.register(rmiName, repository);
        }

        public String getRmiName() {
            return this.rmiName;
        }

        public String getRmiURL() {
            String host;
            try {
                host = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (IOException ignore) {
                host = "localhost";
            }
            return "//" + host + ":" + RmiRegistrationSupport.this.registryPort + "/" + this.getRmiName();
        }

        private void register(String rmiName, Repository repository) {
            System.setProperty("java.rmi.server.useCodebaseOnly", "true");
            try {
                RemoteAdapterFactory raf = RmiRegistrationSupport.this.getRemoteAdapterFactory();
                this.rmiRepository = raf.getRemoteRepository(repository);
            }
            catch (RemoteException e) {
                RmiRegistrationSupport.this.logger.error("Unable to create remote repository.", (Object)e);
                return;
            }
            catch (Exception e) {
                RmiRegistrationSupport.this.logger.error("Unable to create RMI repository. jcr-rmi.jar might be missing.", (Object)e);
                return;
            }
            try {
                Registry privateRegistry = RmiRegistrationSupport.this.getPrivateRegistry();
                if (privateRegistry != null) {
                    privateRegistry.bind(rmiName, this.rmiRepository);
                    this.rmiName = rmiName;
                    RmiRegistrationSupport.this.logger.info("Repository bound to {}", (Object)this.getRmiURL());
                }
            }
            catch (NoSuchObjectException nsoe) {
                RmiRegistrationSupport.this.logger.warn("Cannot contact RMI registry at {}, repository not registered", (Object)RmiRegistrationSupport.this.registryPort);
            }
            catch (Exception e) {
                RmiRegistrationSupport.this.logger.error("Unable to bind repository via RMI.", (Object)e);
            }
        }

        public void unregister() {
            if (this.rmiName != null) {
                try {
                    Registry privateRegistry = RmiRegistrationSupport.this.getPrivateRegistry();
                    if (privateRegistry != null) {
                        privateRegistry.unbind(this.rmiName);
                        RmiRegistrationSupport.this.logger.info("Repository unbound from {}", (Object)this.getRmiURL());
                    }
                }
                catch (Exception e) {
                    RmiRegistrationSupport.this.logger.error("Error while unbinding repository from JNDI: ", (Object)e);
                }
            }
            if (this.rmiRepository != null) {
                try {
                    UnicastRemoteObject.unexportObject(this.rmiRepository, true);
                }
                catch (NoSuchObjectException nsoe) {
                    RmiRegistrationSupport.this.logger.info("Cannot unexport remote Repository reference", (Object)nsoe);
                }
            }
        }
    }

    @ObjectClassDefinition(name="Apache Sling JCR Repository RMI Registrar", description="The RMI Registrar listens for embedded repositories  to be registered as services and registers them in an RMI registry under the  name specified in the \"name\" service property.")
    public static @interface Configuration {
        @AttributeDefinition(name="Port Number", description="Port number of the RMI registry to use. The RMI Registrar first tries to create a private RMI registry at this port. If this fails, an existing registry is tried to connect at this port on local host. If this number is negative, the RMI registrar is disabled. If this number is higher than 65535, an error message is logged and the RMI Registrar is also  disabled. If this number is zero, the system default RMI Registry port 1099 is used.")
        public int port() default 1099;
    }
}

