/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client;

import java.net.URI;
import java.util.Optional;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.auth.oauth_client.ClientConnection;
import org.apache.sling.auth.oauth_client.impl.OAuthUris;
import org.jetbrains.annotations.NotNull;

@NotNull
public class OAuthTokenResponse {
    private final Optional<String> token;
    private final ClientConnection connection;
    private final SlingHttpServletRequest request;
    private final String redirectPath;

    public OAuthTokenResponse(@NotNull Optional<String> token, @NotNull ClientConnection connection, @NotNull SlingHttpServletRequest request, @NotNull String redirectPath) {
        this.token = token;
        this.connection = connection;
        this.request = request;
        this.redirectPath = redirectPath;
    }

    public boolean hasValidToken() {
        return this.token.isPresent();
    }

    @NotNull
    public String getTokenValue() {
        return this.token.orElseThrow(() -> new IllegalStateException("No access token present."));
    }

    @NotNull
    public URI getRedirectUri() {
        if (this.token.isPresent()) {
            throw new IllegalStateException("Access token is present, will not generate a new redirect URI.");
        }
        return OAuthUris.getOAuthEntryPointUri(this.connection, this.request, this.redirectPath);
    }
}

