/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.sling.ide.transport.RepositoryPath;

public class IgnoredResources {
    private List<Pattern> patterns = new ArrayList<Pattern>();

    public void registerRegExpIgnoreRule(String root, String pattern) {
        if (pattern.startsWith("#")) {
            return;
        }
        StringBuilder reg = new StringBuilder("^");
        if (root.equals("/")) {
            root = "";
        }
        reg.append(root).append("/");
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '*') {
                reg.append(".*");
                continue;
            }
            if (c == '?') {
                reg.append(".");
                continue;
            }
            if (c == '.') {
                reg.append("\\.");
                continue;
            }
            reg.append(c);
        }
        reg.append("$");
        this.patterns.add(Pattern.compile(reg.toString()));
    }

    public boolean isIgnored(RepositoryPath repositoryPath) {
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(repositoryPath.asString()).matches()) continue;
            return true;
        }
        return false;
    }
}

