/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image.processing.isoline;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.sis.image.processing.isoline.Fragments;
import org.apache.sis.image.processing.isoline.Joiner;
import org.apache.sis.image.processing.isoline.PolylineBuffer;
import org.apache.sis.image.processing.isoline.PolylineStage;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

final class Tracer {
    static final int UPPER_LEFT = 1;
    static final int UPPER_RIGHT = 2;
    static final int LOWER_LEFT = 4;
    static final int LOWER_RIGHT = 8;
    private final double[] window;
    private final int pixelStride;
    int x;
    int y;
    private final double translateX;
    private final double translateY;
    private final MathTransform gridToCRS;

    Tracer(double[] window, int pixelStride, Rectangle domain, MathTransform gridToCRS) {
        this.window = window;
        this.pixelStride = pixelStride;
        this.translateX = domain.x;
        this.translateY = domain.y;
        this.gridToCRS = gridToCRS;
    }

    private Joiner writeTo(Joiner path, PolylineBuffer[] polylines, boolean close) throws TransformException {
        for (int pi = 0; pi < polylines.length; ++pi) {
            PolylineBuffer p = polylines[pi];
            if (p == null) continue;
            int size = p.size;
            if (size == 0) {
                assert (p.isEmpty());
                continue;
            }
            if (path == null) {
                path = new Joiner(this.gridToCRS);
            }
            path.append(p.coordinates, size, (pi & 1) == 0);
            p.clear();
        }
        if (path != null) {
            path.createPolyline(close);
        }
        return path;
    }

    final class Level {
        private final int band;
        final double value;
        int isDataAbove;
        private final PolylineBuffer polylineOnLeft;
        private final PolylineBuffer[] polylinesOnTop;
        private final Map<Point, Fragments> partialPaths;
        private Joiner path;
        Shape shape;

        Level(int band, double value, int width) {
            this.band = band;
            this.value = value;
            this.partialPaths = new HashMap<Point, Fragments>();
            this.polylineOnLeft = new PolylineBuffer();
            this.polylinesOnTop = new PolylineBuffer[width];
            for (int i = 0; i < width; ++i) {
                this.polylinesOnTop[i] = new PolylineBuffer();
            }
        }

        final void nextColumn() {
            this.isDataAbove = (this.isDataAbove & 0xA) >>> 1;
        }

        final void interpolate() throws TransformException {
            switch (this.isDataAbove) {
                default: {
                    throw new AssertionError(this.isDataAbove);
                }
                case 0: 
                case 15: {
                    assert (this.polylinesOnTop[Tracer.this.x].isEmpty());
                    assert (this.polylineOnLeft.isEmpty());
                    break;
                }
                case 3: 
                case 12: {
                    assert (this.polylinesOnTop[Tracer.this.x].isEmpty());
                    this.interpolateMissingLeftSide();
                    this.interpolateOnRightSide();
                    break;
                }
                case 5: 
                case 10: {
                    assert (this.polylineOnLeft.isEmpty());
                    PolylineBuffer polylineOnTop = this.polylinesOnTop[Tracer.this.x];
                    this.interpolateMissingTopSide(polylineOnTop);
                    this.interpolateOnBottomSide(polylineOnTop);
                    break;
                }
                case 4: 
                case 11: {
                    assert (this.polylinesOnTop[Tracer.this.x].isEmpty());
                    this.interpolateMissingLeftSide();
                    this.interpolateOnBottomSide(this.polylinesOnTop[Tracer.this.x].transferFrom(this.polylineOnLeft));
                    break;
                }
                case 2: 
                case 13: {
                    assert (this.polylineOnLeft.isEmpty());
                    this.interpolateMissingTopSide(this.polylineOnLeft.transferFrom(this.polylinesOnTop[Tracer.this.x]));
                    this.interpolateOnRightSide();
                    break;
                }
                case 7: 
                case 8: {
                    assert (this.polylinesOnTop[Tracer.this.x].isEmpty());
                    assert (this.polylineOnLeft.isEmpty());
                    this.interpolateOnRightSide();
                    this.interpolateOnBottomSide(this.polylinesOnTop[Tracer.this.x].attach(this.polylineOnLeft));
                    break;
                }
                case 1: 
                case 14: {
                    this.closeLeftWithTop(this.polylinesOnTop[Tracer.this.x]);
                    break;
                }
                case 6: 
                case 9: {
                    double average = 0.0;
                    double[] data = Tracer.this.window;
                    int p = this.band;
                    do {
                        average += data[p];
                    } while ((p += Tracer.this.pixelStride) < data.length);
                    assert ((p -= this.band) == Tracer.this.pixelStride * 4) : p;
                    boolean LLtoUR = this.isDataAbove == 6;
                    boolean bl = (average /= 4.0) <= this.value;
                    PolylineBuffer polylineOnTop = this.polylinesOnTop[Tracer.this.x];
                    if (LLtoUR ^= bl) {
                        this.closeLeftWithTop(polylineOnTop);
                        this.interpolateOnRightSide();
                        this.interpolateOnBottomSide(polylineOnTop.attach(this.polylineOnLeft));
                        break;
                    }
                    this.interpolateMissingLeftSide();
                    PolylineBuffer swap = new PolylineBuffer().transferFrom(polylineOnTop);
                    this.interpolateOnBottomSide(polylineOnTop.transferFrom(this.polylineOnLeft));
                    this.interpolateMissingTopSide(this.polylineOnLeft.transferFrom(swap));
                    this.interpolateOnRightSide();
                    break;
                }
            }
        }

        private void interpolateMissingLeftSide() {
            if (this.polylineOnLeft.size == 0) {
                this.polylineOnLeft.append(Tracer.this.translateX + (double)Tracer.this.x, Tracer.this.translateY + ((double)Tracer.this.y + this.interpolate(0, 2 * Tracer.this.pixelStride)));
            }
        }

        private void interpolateMissingTopSide(PolylineBuffer polylineOnTop) {
            if (polylineOnTop.size == 0) {
                this.interpolateOnTopSide(polylineOnTop);
            }
        }

        private void interpolateOnTopSide(PolylineBuffer appendTo) {
            appendTo.append(Tracer.this.translateX + ((double)Tracer.this.x + this.interpolate(0, Tracer.this.pixelStride)), Tracer.this.translateY + (double)Tracer.this.y);
        }

        private void interpolateOnRightSide() {
            this.polylineOnLeft.append(Tracer.this.translateX + (double)(Tracer.this.x + 1), Tracer.this.translateY + ((double)Tracer.this.y + this.interpolate(Tracer.this.pixelStride, 3 * Tracer.this.pixelStride)));
        }

        private void interpolateOnBottomSide(PolylineBuffer polylineOnTop) {
            polylineOnTop.append(Tracer.this.translateX + ((double)Tracer.this.x + this.interpolate(2 * Tracer.this.pixelStride, 3 * Tracer.this.pixelStride)), Tracer.this.translateY + (double)(Tracer.this.y + 1));
        }

        private double interpolate(int i1, int i2) {
            double[] data = Tracer.this.window;
            int p = this.band;
            double v1 = data[p + i1];
            double v2 = data[p + i2];
            return (this.value - v1) / (v2 - v1);
        }

        private void closeLeftWithTop(PolylineBuffer polylineOnTop) throws TransformException {
            PolylineBuffer[] polylines;
            this.interpolateMissingLeftSide();
            this.interpolateMissingTopSide(polylineOnTop);
            if (this.polylineOnLeft.opposite == polylineOnTop) {
                assert (polylineOnTop.opposite == this.polylineOnLeft);
                polylines = new PolylineBuffer[]{polylineOnTop, this.polylineOnLeft};
            } else {
                Fragments fragment = new Fragments(this.polylineOnLeft, polylineOnTop);
                if (fragment.isEmpty()) {
                    polylines = new PolylineBuffer[]{this.polylineOnLeft.opposite, this.polylineOnLeft, polylineOnTop, polylineOnTop.opposite};
                } else if (fragment.addOrMerge(this.partialPaths)) {
                    polylines = fragment.toPolylines();
                } else {
                    return;
                }
            }
            this.path = Tracer.this.writeTo(this.path, polylines, true);
        }

        private void writeFragment(PolylineBuffer polyline) throws TransformException {
            PolylineBuffer[] polylines;
            boolean close;
            Fragments fragment = new Fragments(polyline, null);
            if (fragment.isEmpty()) {
                close = false;
                polylines = new PolylineBuffer[]{polyline.opposite, polyline};
            } else {
                close = fragment.addOrMerge(this.partialPaths);
                if (!close) {
                    return;
                }
                polylines = fragment.toPolylines();
            }
            this.path = Tracer.this.writeTo(this.path, polylines, close);
        }

        final void finishedRow() throws TransformException {
            if (!this.polylineOnLeft.transferToOpposite()) {
                this.writeFragment(this.polylineOnLeft);
            }
            this.isDataAbove = 0;
        }

        final void finish() throws TransformException {
            assert (this.polylineOnLeft.isEmpty());
            this.polylineOnLeft.coordinates = null;
            for (int i = 0; i < this.polylinesOnTop.length; ++i) {
                this.writeFragment(this.polylinesOnTop[i]);
                this.polylinesOnTop[i] = null;
            }
            assert (this.isConsistent());
        }

        private boolean isConsistent() {
            for (Map.Entry<Point, Fragments> entry : this.partialPaths.entrySet()) {
                if (entry.getValue().isExtremity(entry.getKey())) continue;
                return false;
            }
            return true;
        }

        final void merge(Level other) throws TransformException {
            assert (other != this && other.value == this.value);
            if (this.path == null) {
                this.path = other.path;
            } else {
                this.path.append(other.path);
            }
            other.path = null;
            assert (this.isConsistent());
            assert (other.isConsistent());
            IdentityHashMap<Fragments, Boolean> done = new IdentityHashMap<Fragments, Boolean>(other.partialPaths.size() / 2);
            for (Map.Entry<Point, Fragments> entry : other.partialPaths.entrySet()) {
                Fragments fragment = entry.getValue();
                if (done.put(fragment, Boolean.TRUE) == null) {
                    assert (fragment.isExtremity(entry.getKey()));
                    if (fragment.addOrMerge(this.partialPaths)) {
                        this.path = Tracer.this.writeTo(this.path, fragment.toPolylines(), true);
                        fragment.clear();
                    }
                }
                entry.setValue(null);
            }
        }

        final void flush() throws TransformException {
            for (Map.Entry<Point, Fragments> entry : this.partialPaths.entrySet()) {
                Fragments fragment = entry.getValue();
                assert (fragment.isExtremity(entry.getKey()));
                if (!fragment.isEmpty()) {
                    this.path = Tracer.this.writeTo(this.path, fragment.toPolylines(), false);
                    fragment.clear();
                }
                entry.setValue(null);
            }
            if (this.path != null) {
                this.shape = this.path.build();
                this.path = null;
            }
        }

        final void toRawPath(Map<PolylineStage, Path2D> appendTo) {
            PolylineStage.FINAL.add(appendTo, this.path != null ? this.path.snapshot() : this.shape);
            PolylineStage.FRAGMENT.add(appendTo, this.partialPaths);
            this.polylineOnLeft.toRawPath(appendTo);
            for (PolylineBuffer p : this.polylinesOnTop) {
                if (p == null) continue;
                p.toRawPath(appendTo);
            }
        }
    }
}

