/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.operation.provider.GeocentricAffine;
import org.apache.sis.referencing.operation.transform.EllipsoidToCentricTransform;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

@XmlTransient
public abstract class GeocentricAffineBetweenGeographic
extends GeocentricAffine {
    private static final long serialVersionUID = -6202315859507526222L;
    public static final ParameterDescriptor<Integer> DIMENSION;
    public static final ParameterDescriptor<Double> SRC_SEMI_MAJOR;
    public static final ParameterDescriptor<Double> SRC_SEMI_MINOR;
    public static final ParameterDescriptor<Double> TGT_SEMI_MAJOR;
    public static final ParameterDescriptor<Double> TGT_SEMI_MINOR;

    GeocentricAffineBetweenGeographic(GeocentricAffine.Type operationType, ParameterDescriptorGroup parameters, byte dimension) {
        super(operationType, parameters, EllipsoidalCS.class, true, EllipsoidalCS.class, true, dimension);
    }

    public static Ellipsoid getSourceEllipsoid(Parameters values, MathTransformProvider.Context context) {
        return context.getSourceEllipsoid().orElseGet(() -> GeocentricAffineBetweenGeographic.getEllipsoid("source", values, SRC_SEMI_MAJOR, SRC_SEMI_MINOR));
    }

    public static Ellipsoid getTargetEllipsoid(Parameters values, MathTransformProvider.Context context) {
        return context.getTargetEllipsoid().orElseGet(() -> GeocentricAffineBetweenGeographic.getEllipsoid("target", values, TGT_SEMI_MAJOR, TGT_SEMI_MINOR));
    }

    @Override
    public MathTransform createMathTransform(MathTransformProvider.Context context) throws FactoryException {
        Parameters pv = Parameters.castOrWrap(context.getCompletedParameters());
        MathTransform affine = super.createMathTransform(context);
        MathTransformFactory factory = context.getFactory();
        MathTransform toGeocentric = EllipsoidToCentricTransform.createGeodeticConversion(factory, DefaultEllipsoid.castOrCopy(GeocentricAffineBetweenGeographic.getSourceEllipsoid(pv, context)).convertTo((Unit<Length>)Units.METRE), context.getSourceDimensions().orElse(this.minSourceDimension) >= 3, EllipsoidToCentricTransform.TargetType.CARTESIAN);
        MathTransform toGeographic = EllipsoidToCentricTransform.createGeodeticConversion(factory, DefaultEllipsoid.castOrCopy(GeocentricAffineBetweenGeographic.getTargetEllipsoid(pv, context)).convertTo((Unit<Length>)Units.METRE), context.getTargetDimensions().orElse(this.minSourceDimension) >= 3, EllipsoidToCentricTransform.TargetType.CARTESIAN);
        try {
            toGeographic = toGeographic.inverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new FactoryException((Throwable)e);
        }
        return factory.createConcatenatedTransform(toGeocentric, factory.createConcatenatedTransform(affine, toGeographic));
    }

    static {
        ParameterBuilder builder = (ParameterBuilder)GeocentricAffineBetweenGeographic.builder().setCodeSpace((Citation)Citations.OGC, "OGC");
        SRC_SEMI_MAJOR = ((ParameterBuilder)builder.addName("src_semi_major")).createStrictlyPositive(Double.NaN, Units.METRE);
        SRC_SEMI_MINOR = ((ParameterBuilder)builder.addName("src_semi_minor")).createStrictlyPositive(Double.NaN, Units.METRE);
        TGT_SEMI_MAJOR = ((ParameterBuilder)builder.addName("tgt_semi_major")).createStrictlyPositive(Double.NaN, Units.METRE);
        TGT_SEMI_MINOR = ((ParameterBuilder)builder.addName("tgt_semi_minor")).createStrictlyPositive(Double.NaN, Units.METRE);
        DIMENSION = ((ParameterBuilder)builder.addName("dim")).setRequired(false).createBounded(Integer.class, Integer.valueOf(2), Integer.valueOf(3), 2);
    }
}

