/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shenyu.admin.discovery.listener;

/**
 * Data changed event.
 */
public final class DiscoveryDataChangedEvent {

    private final String key;

    private final String value;

    private final Event event;

    /**
     * Instantiates a new Data changed event.
     *
     * @param key the key
     * @param value the value
     * @param event the event
     */
    public DiscoveryDataChangedEvent(final String key, final String value, final Event event) {
        this.key = key;
        this.value = value;
        this.event = event;
    }

    /**
     * Gets key.
     *
     * @return the key
     */
    public String getKey() {
        return key;
    }

    /**
     * Gets value.
     *
     * @return the value
     */
    public String getValue() {
        return value;
    }

    /**
     * Gets event.
     *
     * @return the event
     */
    public Event getEvent() {
        return event;
    }

    /**
     * Data changed event.
     */
    public enum Event {

        /**
         * Added event.
         */
        ADDED,
        /**
         * Updated event.
         */
        UPDATED,
        /**
         * Deleted event.
         */
        DELETED,
        /**
         * Ignored event.
         */
        IGNORED
    }
}
