/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.metrics.publish.spectator;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Tag;
import java.util.Iterator;
import java.util.List;
import org.apache.servicecomb.foundation.metrics.publish.spectator.MeasurementGroupConfig;
import org.apache.servicecomb.foundation.metrics.publish.spectator.MeasurementNode;
import org.apache.servicecomb.foundation.metrics.publish.spectator.TagFinder;

public class MeasurementTree
extends MeasurementNode {
    public MeasurementTree() {
        super(null, null);
    }

    public void from(Iterator<Meter> meters, MeasurementGroupConfig groupConfig) {
        meters.forEachRemaining(meter -> {
            Iterable measurements = meter.measure();
            this.from(measurements, groupConfig);
        });
    }

    public void from(Iterable<Measurement> measurements, MeasurementGroupConfig groupConfig) {
        block0: for (Measurement measurement : measurements) {
            Id id = measurement.id();
            MeasurementNode node = this.addChild(id.name(), measurement);
            List<TagFinder> tagFinders = groupConfig.findTagFinders(id.name());
            if (tagFinders == null) continue;
            for (TagFinder tagFinder : tagFinders) {
                Tag tag = tagFinder.find(id.tags());
                if (tag == null) {
                    if (tagFinder.skipOnNull()) continue block0;
                    throw new IllegalStateException(String.format("tag key \"%s\" not exist in %s", tagFinder.getTagKey(), measurement));
                }
                node = node.addChild(tag.value(), measurement);
            }
        }
    }
}

