// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v5.29.3
// source: apache/rocketmq/v2/service.proto

package v2

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	MessagingService_QueryRoute_FullMethodName                      = "/apache.rocketmq.v2.MessagingService/QueryRoute"
	MessagingService_Heartbeat_FullMethodName                       = "/apache.rocketmq.v2.MessagingService/Heartbeat"
	MessagingService_SendMessage_FullMethodName                     = "/apache.rocketmq.v2.MessagingService/SendMessage"
	MessagingService_QueryAssignment_FullMethodName                 = "/apache.rocketmq.v2.MessagingService/QueryAssignment"
	MessagingService_ReceiveMessage_FullMethodName                  = "/apache.rocketmq.v2.MessagingService/ReceiveMessage"
	MessagingService_AckMessage_FullMethodName                      = "/apache.rocketmq.v2.MessagingService/AckMessage"
	MessagingService_ForwardMessageToDeadLetterQueue_FullMethodName = "/apache.rocketmq.v2.MessagingService/ForwardMessageToDeadLetterQueue"
	MessagingService_PullMessage_FullMethodName                     = "/apache.rocketmq.v2.MessagingService/PullMessage"
	MessagingService_UpdateOffset_FullMethodName                    = "/apache.rocketmq.v2.MessagingService/UpdateOffset"
	MessagingService_GetOffset_FullMethodName                       = "/apache.rocketmq.v2.MessagingService/GetOffset"
	MessagingService_QueryOffset_FullMethodName                     = "/apache.rocketmq.v2.MessagingService/QueryOffset"
	MessagingService_EndTransaction_FullMethodName                  = "/apache.rocketmq.v2.MessagingService/EndTransaction"
	MessagingService_Telemetry_FullMethodName                       = "/apache.rocketmq.v2.MessagingService/Telemetry"
	MessagingService_NotifyClientTermination_FullMethodName         = "/apache.rocketmq.v2.MessagingService/NotifyClientTermination"
	MessagingService_ChangeInvisibleDuration_FullMethodName         = "/apache.rocketmq.v2.MessagingService/ChangeInvisibleDuration"
	MessagingService_RecallMessage_FullMethodName                   = "/apache.rocketmq.v2.MessagingService/RecallMessage"
)

// MessagingServiceClient is the client API for MessagingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// For all the RPCs in MessagingService, the following error handling policies
// apply:
//
// If the request doesn't bear a valid authentication credential, return a
// response with common.status.code == `UNAUTHENTICATED`. If the authenticated
// user is not granted with sufficient permission to execute the requested
// operation, return a response with common.status.code == `PERMISSION_DENIED`.
// If the per-user-resource-based quota is exhausted, return a response with
// common.status.code == `RESOURCE_EXHAUSTED`. If any unexpected server-side
// errors raise, return a response with common.status.code == `INTERNAL`.
type MessagingServiceClient interface {
	// Queries the route entries of the requested topic in the perspective of the
	// given endpoints. On success, servers should return a collection of
	// addressable message-queues. Note servers may return customized route
	// entries based on endpoints provided.
	//
	// If the requested topic doesn't exist, returns `NOT_FOUND`.
	// If the specific endpoints is empty, returns `INVALID_ARGUMENT`.
	QueryRoute(ctx context.Context, in *QueryRouteRequest, opts ...grpc.CallOption) (*QueryRouteResponse, error)
	// Producer or consumer sends HeartbeatRequest to servers periodically to
	// keep-alive. Additionally, it also reports client-side configuration,
	// including topic subscription, load-balancing group name, etc.
	//
	// Returns `OK` if success.
	//
	// If a client specifies a language that is not yet supported by servers,
	// returns `INVALID_ARGUMENT`
	Heartbeat(ctx context.Context, in *HeartbeatRequest, opts ...grpc.CallOption) (*HeartbeatResponse, error)
	// Delivers messages to brokers.
	// Clients may further:
	// 1. Refine a message destination to message-queues which fulfills parts of
	// FIFO semantic;
	// 2. Flag a message as transactional, which keeps it invisible to consumers
	// until it commits;
	// 3. Time a message, making it invisible to consumers till specified
	// time-point;
	// 4. And more...
	//
	// Returns message-id or transaction-id with status `OK` on success.
	//
	// If the destination topic doesn't exist, returns `NOT_FOUND`.
	SendMessage(ctx context.Context, in *SendMessageRequest, opts ...grpc.CallOption) (*SendMessageResponse, error)
	// Queries the assigned route info of a topic for current consumer,
	// the returned assignment result is decided by server-side load balancer.
	//
	// If the corresponding topic doesn't exist, returns `NOT_FOUND`.
	// If the specific endpoints is empty, returns `INVALID_ARGUMENT`.
	QueryAssignment(ctx context.Context, in *QueryAssignmentRequest, opts ...grpc.CallOption) (*QueryAssignmentResponse, error)
	// Receives messages from the server in batch manner, returns a set of
	// messages if success. The received messages should be acked or redelivered
	// after processed.
	//
	// If the pending concurrent receive requests exceed the quota of the given
	// consumer group, returns `UNAVAILABLE`. If the upstream store server hangs,
	// return `DEADLINE_EXCEEDED` in a timely manner. If the corresponding topic
	// or consumer group doesn't exist, returns `NOT_FOUND`. If there is no new
	// message in the specific topic, returns `OK` with an empty message set.
	// Please note that client may suffer from false empty responses.
	//
	// If failed to receive message from remote, server must return only one
	// `ReceiveMessageResponse` as the reply to the request, whose `Status` indicates
	// the specific reason of failure, otherwise, the reply is considered successful.
	ReceiveMessage(ctx context.Context, in *ReceiveMessageRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ReceiveMessageResponse], error)
	// Acknowledges the message associated with the `receipt_handle` or `offset`
	// in the `AckMessageRequest`, it means the message has been successfully
	// processed. Returns `OK` if the message server remove the relevant message
	// successfully.
	//
	// If the given receipt_handle is illegal or out of date, returns
	// `INVALID_ARGUMENT`.
	AckMessage(ctx context.Context, in *AckMessageRequest, opts ...grpc.CallOption) (*AckMessageResponse, error)
	// Forwards one message to dead letter queue if the max delivery attempts is
	// exceeded by this message at client-side, return `OK` if success.
	ForwardMessageToDeadLetterQueue(ctx context.Context, in *ForwardMessageToDeadLetterQueueRequest, opts ...grpc.CallOption) (*ForwardMessageToDeadLetterQueueResponse, error)
	// PullMessage and ReceiveMessage RPCs serve a similar purpose,
	// which is to attempt to get messages from the server, but with different semantics.
	PullMessage(ctx context.Context, in *PullMessageRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[PullMessageResponse], error)
	// Update the consumption progress of the designated queue of the
	// consumer group to the remote.
	UpdateOffset(ctx context.Context, in *UpdateOffsetRequest, opts ...grpc.CallOption) (*UpdateOffsetResponse, error)
	// Query the consumption progress of the designated queue of the
	// consumer group to the remote.
	GetOffset(ctx context.Context, in *GetOffsetRequest, opts ...grpc.CallOption) (*GetOffsetResponse, error)
	// Query the offset of the designated queue by the query offset policy.
	QueryOffset(ctx context.Context, in *QueryOffsetRequest, opts ...grpc.CallOption) (*QueryOffsetResponse, error)
	// Commits or rollback one transactional message.
	EndTransaction(ctx context.Context, in *EndTransactionRequest, opts ...grpc.CallOption) (*EndTransactionResponse, error)
	// Once a client starts, it would immediately establishes bi-lateral stream
	// RPCs with brokers, reporting its settings as the initiative command.
	//
	// When servers have need of inspecting client status, they would issue
	// telemetry commands to clients. After executing received instructions,
	// clients shall report command execution results through client-side streams.
	Telemetry(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[TelemetryCommand, TelemetryCommand], error)
	// Notify the server that the client is terminated.
	NotifyClientTermination(ctx context.Context, in *NotifyClientTerminationRequest, opts ...grpc.CallOption) (*NotifyClientTerminationResponse, error)
	// Once a message is retrieved from consume queue on behalf of the group, it
	// will be kept invisible to other clients of the same group for a period of
	// time. The message is supposed to be processed within the invisible
	// duration. If the client, which is in charge of the invisible message, is
	// not capable of processing the message timely, it may use
	// ChangeInvisibleDuration to lengthen invisible duration.
	ChangeInvisibleDuration(ctx context.Context, in *ChangeInvisibleDurationRequest, opts ...grpc.CallOption) (*ChangeInvisibleDurationResponse, error)
	// Recall a message,
	// for delay message, should recall before delivery time, like the rollback operation of transaction message,
	// for normal message, not supported for now.
	RecallMessage(ctx context.Context, in *RecallMessageRequest, opts ...grpc.CallOption) (*RecallMessageResponse, error)
}

type messagingServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMessagingServiceClient(cc grpc.ClientConnInterface) MessagingServiceClient {
	return &messagingServiceClient{cc}
}

func (c *messagingServiceClient) QueryRoute(ctx context.Context, in *QueryRouteRequest, opts ...grpc.CallOption) (*QueryRouteResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(QueryRouteResponse)
	err := c.cc.Invoke(ctx, MessagingService_QueryRoute_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messagingServiceClient) Heartbeat(ctx context.Context, in *HeartbeatRequest, opts ...grpc.CallOption) (*HeartbeatResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(HeartbeatResponse)
	err := c.cc.Invoke(ctx, MessagingService_Heartbeat_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messagingServiceClient) SendMessage(ctx context.Context, in *SendMessageRequest, opts ...grpc.CallOption) (*SendMessageResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SendMessageResponse)
	err := c.cc.Invoke(ctx, MessagingService_SendMessage_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messagingServiceClient) QueryAssignment(ctx context.Context, in *QueryAssignmentRequest, opts ...grpc.CallOption) (*QueryAssignmentResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(QueryAssignmentResponse)
	err := c.cc.Invoke(ctx, MessagingService_QueryAssignment_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messagingServiceClient) ReceiveMessage(ctx context.Context, in *ReceiveMessageRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ReceiveMessageResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &MessagingService_ServiceDesc.Streams[0], MessagingService_ReceiveMessage_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[ReceiveMessageRequest, ReceiveMessageResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type MessagingService_ReceiveMessageClient = grpc.ServerStreamingClient[ReceiveMessageResponse]

func (c *messagingServiceClient) AckMessage(ctx context.Context, in *AckMessageRequest, opts ...grpc.CallOption) (*AckMessageResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(AckMessageResponse)
	err := c.cc.Invoke(ctx, MessagingService_AckMessage_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messagingServiceClient) ForwardMessageToDeadLetterQueue(ctx context.Context, in *ForwardMessageToDeadLetterQueueRequest, opts ...grpc.CallOption) (*ForwardMessageToDeadLetterQueueResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ForwardMessageToDeadLetterQueueResponse)
	err := c.cc.Invoke(ctx, MessagingService_ForwardMessageToDeadLetterQueue_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messagingServiceClient) PullMessage(ctx context.Context, in *PullMessageRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[PullMessageResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &MessagingService_ServiceDesc.Streams[1], MessagingService_PullMessage_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[PullMessageRequest, PullMessageResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type MessagingService_PullMessageClient = grpc.ServerStreamingClient[PullMessageResponse]

func (c *messagingServiceClient) UpdateOffset(ctx context.Context, in *UpdateOffsetRequest, opts ...grpc.CallOption) (*UpdateOffsetResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UpdateOffsetResponse)
	err := c.cc.Invoke(ctx, MessagingService_UpdateOffset_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messagingServiceClient) GetOffset(ctx context.Context, in *GetOffsetRequest, opts ...grpc.CallOption) (*GetOffsetResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetOffsetResponse)
	err := c.cc.Invoke(ctx, MessagingService_GetOffset_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messagingServiceClient) QueryOffset(ctx context.Context, in *QueryOffsetRequest, opts ...grpc.CallOption) (*QueryOffsetResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(QueryOffsetResponse)
	err := c.cc.Invoke(ctx, MessagingService_QueryOffset_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messagingServiceClient) EndTransaction(ctx context.Context, in *EndTransactionRequest, opts ...grpc.CallOption) (*EndTransactionResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(EndTransactionResponse)
	err := c.cc.Invoke(ctx, MessagingService_EndTransaction_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messagingServiceClient) Telemetry(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[TelemetryCommand, TelemetryCommand], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &MessagingService_ServiceDesc.Streams[2], MessagingService_Telemetry_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[TelemetryCommand, TelemetryCommand]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type MessagingService_TelemetryClient = grpc.BidiStreamingClient[TelemetryCommand, TelemetryCommand]

func (c *messagingServiceClient) NotifyClientTermination(ctx context.Context, in *NotifyClientTerminationRequest, opts ...grpc.CallOption) (*NotifyClientTerminationResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(NotifyClientTerminationResponse)
	err := c.cc.Invoke(ctx, MessagingService_NotifyClientTermination_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messagingServiceClient) ChangeInvisibleDuration(ctx context.Context, in *ChangeInvisibleDurationRequest, opts ...grpc.CallOption) (*ChangeInvisibleDurationResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ChangeInvisibleDurationResponse)
	err := c.cc.Invoke(ctx, MessagingService_ChangeInvisibleDuration_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messagingServiceClient) RecallMessage(ctx context.Context, in *RecallMessageRequest, opts ...grpc.CallOption) (*RecallMessageResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(RecallMessageResponse)
	err := c.cc.Invoke(ctx, MessagingService_RecallMessage_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MessagingServiceServer is the server API for MessagingService service.
// All implementations must embed UnimplementedMessagingServiceServer
// for forward compatibility.
//
// For all the RPCs in MessagingService, the following error handling policies
// apply:
//
// If the request doesn't bear a valid authentication credential, return a
// response with common.status.code == `UNAUTHENTICATED`. If the authenticated
// user is not granted with sufficient permission to execute the requested
// operation, return a response with common.status.code == `PERMISSION_DENIED`.
// If the per-user-resource-based quota is exhausted, return a response with
// common.status.code == `RESOURCE_EXHAUSTED`. If any unexpected server-side
// errors raise, return a response with common.status.code == `INTERNAL`.
type MessagingServiceServer interface {
	// Queries the route entries of the requested topic in the perspective of the
	// given endpoints. On success, servers should return a collection of
	// addressable message-queues. Note servers may return customized route
	// entries based on endpoints provided.
	//
	// If the requested topic doesn't exist, returns `NOT_FOUND`.
	// If the specific endpoints is empty, returns `INVALID_ARGUMENT`.
	QueryRoute(context.Context, *QueryRouteRequest) (*QueryRouteResponse, error)
	// Producer or consumer sends HeartbeatRequest to servers periodically to
	// keep-alive. Additionally, it also reports client-side configuration,
	// including topic subscription, load-balancing group name, etc.
	//
	// Returns `OK` if success.
	//
	// If a client specifies a language that is not yet supported by servers,
	// returns `INVALID_ARGUMENT`
	Heartbeat(context.Context, *HeartbeatRequest) (*HeartbeatResponse, error)
	// Delivers messages to brokers.
	// Clients may further:
	// 1. Refine a message destination to message-queues which fulfills parts of
	// FIFO semantic;
	// 2. Flag a message as transactional, which keeps it invisible to consumers
	// until it commits;
	// 3. Time a message, making it invisible to consumers till specified
	// time-point;
	// 4. And more...
	//
	// Returns message-id or transaction-id with status `OK` on success.
	//
	// If the destination topic doesn't exist, returns `NOT_FOUND`.
	SendMessage(context.Context, *SendMessageRequest) (*SendMessageResponse, error)
	// Queries the assigned route info of a topic for current consumer,
	// the returned assignment result is decided by server-side load balancer.
	//
	// If the corresponding topic doesn't exist, returns `NOT_FOUND`.
	// If the specific endpoints is empty, returns `INVALID_ARGUMENT`.
	QueryAssignment(context.Context, *QueryAssignmentRequest) (*QueryAssignmentResponse, error)
	// Receives messages from the server in batch manner, returns a set of
	// messages if success. The received messages should be acked or redelivered
	// after processed.
	//
	// If the pending concurrent receive requests exceed the quota of the given
	// consumer group, returns `UNAVAILABLE`. If the upstream store server hangs,
	// return `DEADLINE_EXCEEDED` in a timely manner. If the corresponding topic
	// or consumer group doesn't exist, returns `NOT_FOUND`. If there is no new
	// message in the specific topic, returns `OK` with an empty message set.
	// Please note that client may suffer from false empty responses.
	//
	// If failed to receive message from remote, server must return only one
	// `ReceiveMessageResponse` as the reply to the request, whose `Status` indicates
	// the specific reason of failure, otherwise, the reply is considered successful.
	ReceiveMessage(*ReceiveMessageRequest, grpc.ServerStreamingServer[ReceiveMessageResponse]) error
	// Acknowledges the message associated with the `receipt_handle` or `offset`
	// in the `AckMessageRequest`, it means the message has been successfully
	// processed. Returns `OK` if the message server remove the relevant message
	// successfully.
	//
	// If the given receipt_handle is illegal or out of date, returns
	// `INVALID_ARGUMENT`.
	AckMessage(context.Context, *AckMessageRequest) (*AckMessageResponse, error)
	// Forwards one message to dead letter queue if the max delivery attempts is
	// exceeded by this message at client-side, return `OK` if success.
	ForwardMessageToDeadLetterQueue(context.Context, *ForwardMessageToDeadLetterQueueRequest) (*ForwardMessageToDeadLetterQueueResponse, error)
	// PullMessage and ReceiveMessage RPCs serve a similar purpose,
	// which is to attempt to get messages from the server, but with different semantics.
	PullMessage(*PullMessageRequest, grpc.ServerStreamingServer[PullMessageResponse]) error
	// Update the consumption progress of the designated queue of the
	// consumer group to the remote.
	UpdateOffset(context.Context, *UpdateOffsetRequest) (*UpdateOffsetResponse, error)
	// Query the consumption progress of the designated queue of the
	// consumer group to the remote.
	GetOffset(context.Context, *GetOffsetRequest) (*GetOffsetResponse, error)
	// Query the offset of the designated queue by the query offset policy.
	QueryOffset(context.Context, *QueryOffsetRequest) (*QueryOffsetResponse, error)
	// Commits or rollback one transactional message.
	EndTransaction(context.Context, *EndTransactionRequest) (*EndTransactionResponse, error)
	// Once a client starts, it would immediately establishes bi-lateral stream
	// RPCs with brokers, reporting its settings as the initiative command.
	//
	// When servers have need of inspecting client status, they would issue
	// telemetry commands to clients. After executing received instructions,
	// clients shall report command execution results through client-side streams.
	Telemetry(grpc.BidiStreamingServer[TelemetryCommand, TelemetryCommand]) error
	// Notify the server that the client is terminated.
	NotifyClientTermination(context.Context, *NotifyClientTerminationRequest) (*NotifyClientTerminationResponse, error)
	// Once a message is retrieved from consume queue on behalf of the group, it
	// will be kept invisible to other clients of the same group for a period of
	// time. The message is supposed to be processed within the invisible
	// duration. If the client, which is in charge of the invisible message, is
	// not capable of processing the message timely, it may use
	// ChangeInvisibleDuration to lengthen invisible duration.
	ChangeInvisibleDuration(context.Context, *ChangeInvisibleDurationRequest) (*ChangeInvisibleDurationResponse, error)
	// Recall a message,
	// for delay message, should recall before delivery time, like the rollback operation of transaction message,
	// for normal message, not supported for now.
	RecallMessage(context.Context, *RecallMessageRequest) (*RecallMessageResponse, error)
	mustEmbedUnimplementedMessagingServiceServer()
}

// UnimplementedMessagingServiceServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedMessagingServiceServer struct{}

func (UnimplementedMessagingServiceServer) QueryRoute(context.Context, *QueryRouteRequest) (*QueryRouteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryRoute not implemented")
}
func (UnimplementedMessagingServiceServer) Heartbeat(context.Context, *HeartbeatRequest) (*HeartbeatResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Heartbeat not implemented")
}
func (UnimplementedMessagingServiceServer) SendMessage(context.Context, *SendMessageRequest) (*SendMessageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SendMessage not implemented")
}
func (UnimplementedMessagingServiceServer) QueryAssignment(context.Context, *QueryAssignmentRequest) (*QueryAssignmentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryAssignment not implemented")
}
func (UnimplementedMessagingServiceServer) ReceiveMessage(*ReceiveMessageRequest, grpc.ServerStreamingServer[ReceiveMessageResponse]) error {
	return status.Errorf(codes.Unimplemented, "method ReceiveMessage not implemented")
}
func (UnimplementedMessagingServiceServer) AckMessage(context.Context, *AckMessageRequest) (*AckMessageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AckMessage not implemented")
}
func (UnimplementedMessagingServiceServer) ForwardMessageToDeadLetterQueue(context.Context, *ForwardMessageToDeadLetterQueueRequest) (*ForwardMessageToDeadLetterQueueResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ForwardMessageToDeadLetterQueue not implemented")
}
func (UnimplementedMessagingServiceServer) PullMessage(*PullMessageRequest, grpc.ServerStreamingServer[PullMessageResponse]) error {
	return status.Errorf(codes.Unimplemented, "method PullMessage not implemented")
}
func (UnimplementedMessagingServiceServer) UpdateOffset(context.Context, *UpdateOffsetRequest) (*UpdateOffsetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateOffset not implemented")
}
func (UnimplementedMessagingServiceServer) GetOffset(context.Context, *GetOffsetRequest) (*GetOffsetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOffset not implemented")
}
func (UnimplementedMessagingServiceServer) QueryOffset(context.Context, *QueryOffsetRequest) (*QueryOffsetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryOffset not implemented")
}
func (UnimplementedMessagingServiceServer) EndTransaction(context.Context, *EndTransactionRequest) (*EndTransactionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EndTransaction not implemented")
}
func (UnimplementedMessagingServiceServer) Telemetry(grpc.BidiStreamingServer[TelemetryCommand, TelemetryCommand]) error {
	return status.Errorf(codes.Unimplemented, "method Telemetry not implemented")
}
func (UnimplementedMessagingServiceServer) NotifyClientTermination(context.Context, *NotifyClientTerminationRequest) (*NotifyClientTerminationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NotifyClientTermination not implemented")
}
func (UnimplementedMessagingServiceServer) ChangeInvisibleDuration(context.Context, *ChangeInvisibleDurationRequest) (*ChangeInvisibleDurationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ChangeInvisibleDuration not implemented")
}
func (UnimplementedMessagingServiceServer) RecallMessage(context.Context, *RecallMessageRequest) (*RecallMessageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RecallMessage not implemented")
}
func (UnimplementedMessagingServiceServer) mustEmbedUnimplementedMessagingServiceServer() {}
func (UnimplementedMessagingServiceServer) testEmbeddedByValue()                          {}

// UnsafeMessagingServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to MessagingServiceServer will
// result in compilation errors.
type UnsafeMessagingServiceServer interface {
	mustEmbedUnimplementedMessagingServiceServer()
}

func RegisterMessagingServiceServer(s grpc.ServiceRegistrar, srv MessagingServiceServer) {
	// If the following call pancis, it indicates UnimplementedMessagingServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&MessagingService_ServiceDesc, srv)
}

func _MessagingService_QueryRoute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryRouteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessagingServiceServer).QueryRoute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MessagingService_QueryRoute_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessagingServiceServer).QueryRoute(ctx, req.(*QueryRouteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessagingService_Heartbeat_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HeartbeatRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessagingServiceServer).Heartbeat(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MessagingService_Heartbeat_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessagingServiceServer).Heartbeat(ctx, req.(*HeartbeatRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessagingService_SendMessage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SendMessageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessagingServiceServer).SendMessage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MessagingService_SendMessage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessagingServiceServer).SendMessage(ctx, req.(*SendMessageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessagingService_QueryAssignment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessagingServiceServer).QueryAssignment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MessagingService_QueryAssignment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessagingServiceServer).QueryAssignment(ctx, req.(*QueryAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessagingService_ReceiveMessage_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReceiveMessageRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(MessagingServiceServer).ReceiveMessage(m, &grpc.GenericServerStream[ReceiveMessageRequest, ReceiveMessageResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type MessagingService_ReceiveMessageServer = grpc.ServerStreamingServer[ReceiveMessageResponse]

func _MessagingService_AckMessage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AckMessageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessagingServiceServer).AckMessage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MessagingService_AckMessage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessagingServiceServer).AckMessage(ctx, req.(*AckMessageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessagingService_ForwardMessageToDeadLetterQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ForwardMessageToDeadLetterQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessagingServiceServer).ForwardMessageToDeadLetterQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MessagingService_ForwardMessageToDeadLetterQueue_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessagingServiceServer).ForwardMessageToDeadLetterQueue(ctx, req.(*ForwardMessageToDeadLetterQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessagingService_PullMessage_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PullMessageRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(MessagingServiceServer).PullMessage(m, &grpc.GenericServerStream[PullMessageRequest, PullMessageResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type MessagingService_PullMessageServer = grpc.ServerStreamingServer[PullMessageResponse]

func _MessagingService_UpdateOffset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateOffsetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessagingServiceServer).UpdateOffset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MessagingService_UpdateOffset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessagingServiceServer).UpdateOffset(ctx, req.(*UpdateOffsetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessagingService_GetOffset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOffsetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessagingServiceServer).GetOffset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MessagingService_GetOffset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessagingServiceServer).GetOffset(ctx, req.(*GetOffsetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessagingService_QueryOffset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryOffsetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessagingServiceServer).QueryOffset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MessagingService_QueryOffset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessagingServiceServer).QueryOffset(ctx, req.(*QueryOffsetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessagingService_EndTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EndTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessagingServiceServer).EndTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MessagingService_EndTransaction_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessagingServiceServer).EndTransaction(ctx, req.(*EndTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessagingService_Telemetry_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(MessagingServiceServer).Telemetry(&grpc.GenericServerStream[TelemetryCommand, TelemetryCommand]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type MessagingService_TelemetryServer = grpc.BidiStreamingServer[TelemetryCommand, TelemetryCommand]

func _MessagingService_NotifyClientTermination_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NotifyClientTerminationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessagingServiceServer).NotifyClientTermination(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MessagingService_NotifyClientTermination_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessagingServiceServer).NotifyClientTermination(ctx, req.(*NotifyClientTerminationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessagingService_ChangeInvisibleDuration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ChangeInvisibleDurationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessagingServiceServer).ChangeInvisibleDuration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MessagingService_ChangeInvisibleDuration_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessagingServiceServer).ChangeInvisibleDuration(ctx, req.(*ChangeInvisibleDurationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessagingService_RecallMessage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RecallMessageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessagingServiceServer).RecallMessage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MessagingService_RecallMessage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessagingServiceServer).RecallMessage(ctx, req.(*RecallMessageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// MessagingService_ServiceDesc is the grpc.ServiceDesc for MessagingService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var MessagingService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "apache.rocketmq.v2.MessagingService",
	HandlerType: (*MessagingServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "QueryRoute",
			Handler:    _MessagingService_QueryRoute_Handler,
		},
		{
			MethodName: "Heartbeat",
			Handler:    _MessagingService_Heartbeat_Handler,
		},
		{
			MethodName: "SendMessage",
			Handler:    _MessagingService_SendMessage_Handler,
		},
		{
			MethodName: "QueryAssignment",
			Handler:    _MessagingService_QueryAssignment_Handler,
		},
		{
			MethodName: "AckMessage",
			Handler:    _MessagingService_AckMessage_Handler,
		},
		{
			MethodName: "ForwardMessageToDeadLetterQueue",
			Handler:    _MessagingService_ForwardMessageToDeadLetterQueue_Handler,
		},
		{
			MethodName: "UpdateOffset",
			Handler:    _MessagingService_UpdateOffset_Handler,
		},
		{
			MethodName: "GetOffset",
			Handler:    _MessagingService_GetOffset_Handler,
		},
		{
			MethodName: "QueryOffset",
			Handler:    _MessagingService_QueryOffset_Handler,
		},
		{
			MethodName: "EndTransaction",
			Handler:    _MessagingService_EndTransaction_Handler,
		},
		{
			MethodName: "NotifyClientTermination",
			Handler:    _MessagingService_NotifyClientTermination_Handler,
		},
		{
			MethodName: "ChangeInvisibleDuration",
			Handler:    _MessagingService_ChangeInvisibleDuration_Handler,
		},
		{
			MethodName: "RecallMessage",
			Handler:    _MessagingService_RecallMessage_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ReceiveMessage",
			Handler:       _MessagingService_ReceiveMessage_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PullMessage",
			Handler:       _MessagingService_PullMessage_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Telemetry",
			Handler:       _MessagingService_Telemetry_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "apache/rocketmq/v2/service.proto",
}
