/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

public enum Protocol {
    AMQP_0_8(ProtocolType.AMQP, "0-8"),
    AMQP_0_9(ProtocolType.AMQP, "0-9"),
    AMQP_0_9_1(ProtocolType.AMQP, "0-9-1"),
    AMQP_0_10(ProtocolType.AMQP, "0-10"),
    AMQP_1_0(ProtocolType.AMQP, "1.0"),
    HTTP(ProtocolType.HTTP);

    private final ProtocolType _protocolType;
    private final String _protocolVersion;

    private Protocol(ProtocolType type) {
        this(type, null);
    }

    private Protocol(ProtocolType type, String version) {
        this._protocolType = type;
        this._protocolVersion = version;
    }

    public ProtocolType getProtocolType() {
        return this._protocolType;
    }

    public String getProtocolVersion() {
        return this._protocolVersion;
    }

    public boolean isAMQP() {
        return this._protocolType == ProtocolType.AMQP;
    }

    public static enum ProtocolType {
        AMQP,
        HTTP;

    }
}

