/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.lang.reflect.Array;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.server.protocol.v1_0.Session_1_0;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.DistributionMode;
import org.apache.qpid.server.protocol.v1_0.type.ErrorCondition;
import org.apache.qpid.server.protocol.v1_0.type.LifetimePolicy;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.TxnCapability;
import org.apache.qpid.server.protocol.v1_0.type.messaging.StdDistMode;
import org.apache.qpid.server.protocol.v1_0.type.transaction.TransactionError;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.protocol.v1_0.type.transport.ConnectionError;
import org.apache.qpid.server.protocol.v1_0.type.transport.LinkError;
import org.apache.qpid.server.protocol.v1_0.type.transport.SessionError;

public class DeserializationFactories {
    public static Map<Symbol, Object> convertToNodeProperties(Object value) throws AmqpErrorException {
        if (!(value instanceof Map)) {
            throw new AmqpErrorException(AmqpError.DECODE_ERROR, String.format("Cannot construct 'node-properties' from type '%s'", value == null ? null : value.getClass().getSimpleName()), new Object[0]);
        }
        LinkedHashMap<Symbol, Object> nodeProperties = new LinkedHashMap<Symbol, Object>();
        Map map = (Map)value;
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            if (!(key instanceof Symbol)) {
                throw new AmqpErrorException(AmqpError.DECODE_ERROR, String.format("'node-properties' must have only keys of type 'symbol' but got '%s'", key.getClass().getSimpleName()), new Object[0]);
            }
            if (Session_1_0.LIFETIME_POLICY.equals(key)) {
                Object lifetimePolicy = entry.getValue();
                if (!(lifetimePolicy instanceof LifetimePolicy)) {
                    String typeName = lifetimePolicy == null ? null : lifetimePolicy.getClass().getSimpleName();
                    throw new AmqpErrorException(AmqpError.DECODE_ERROR, String.format("Cannot construct 'lifetime-policy' from type '%s'", typeName), new Object[0]);
                }
                nodeProperties.put((Symbol)key, lifetimePolicy);
                continue;
            }
            if (Symbol.valueOf("supported-dist-modes").equals(key)) {
                DistributionMode[] converted;
                Object distributionMode = entry.getValue();
                if (distributionMode == null) {
                    converted = null;
                } else if (distributionMode.getClass().isArray()) {
                    converted = new DistributionMode[Array.getLength(distributionMode)];
                    for (int i = 0; i < converted.length; ++i) {
                        Object item = Array.get(distributionMode, i);
                        if (item == null) {
                            throw new AmqpErrorException(AmqpError.DECODE_ERROR, "'null' not allowed in 'supported-distribution-modes'", new Object[0]);
                        }
                        converted[i] = DeserializationFactories.convertToDistributionMode(item);
                    }
                } else {
                    converted = new DistributionMode[]{DeserializationFactories.convertToDistributionMode(distributionMode)};
                }
                nodeProperties.put((Symbol)key, converted);
                continue;
            }
            nodeProperties.put((Symbol)key, entry.getValue());
        }
        return nodeProperties;
    }

    public static DistributionMode convertToDistributionMode(Object value) throws AmqpErrorException {
        if (value instanceof DistributionMode) {
            return (DistributionMode)value;
        }
        if (value instanceof Symbol) {
            try {
                return StdDistMode.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                return new UnknownDistributionMode((Symbol)value);
            }
        }
        String message = String.format("Cannot construct 'distribution-mode' from type '%s'", value == null ? null : value.getClass().getSimpleName());
        throw new AmqpErrorException(AmqpError.DECODE_ERROR, message, new Object[0]);
    }

    public static TxnCapability convertToTxnCapability(Object value) throws AmqpErrorException {
        if (value instanceof TxnCapability) {
            return (TxnCapability)value;
        }
        if (value instanceof Symbol) {
            try {
                return org.apache.qpid.server.protocol.v1_0.type.transaction.TxnCapability.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                return new UnknownTxnCapability((Symbol)value);
            }
        }
        String message = String.format("Cannot construct 'txn-capability' from type '%s'", value == null ? null : value.getClass().getSimpleName());
        throw new AmqpErrorException(AmqpError.DECODE_ERROR, message, new Object[0]);
    }

    public static ErrorCondition convertToErrorCondition(Object value) throws AmqpErrorException {
        if (value instanceof ErrorCondition) {
            return (ErrorCondition)value;
        }
        if (value instanceof Symbol) {
            try {
                return AmqpError.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                try {
                    return ConnectionError.valueOf(value);
                }
                catch (IllegalArgumentException e1) {
                    try {
                        return SessionError.valueOf(value);
                    }
                    catch (IllegalArgumentException e2) {
                        try {
                            return LinkError.valueOf(value);
                        }
                        catch (IllegalArgumentException e3) {
                            try {
                                return TransactionError.valueOf(value);
                            }
                            catch (IllegalArgumentException e4) {
                                return new UnknownErrorCondition((Symbol)value);
                            }
                        }
                    }
                }
            }
        }
        String message = String.format("Cannot construct 'error-condition' from type '%s'", value == null ? null : value.getClass().getSimpleName());
        throw new AmqpErrorException(AmqpError.DECODE_ERROR, message, new Object[0]);
    }

    private static class UnknownDistributionMode
    implements DistributionMode {
        private final Symbol _value;

        public UnknownDistributionMode(Symbol value) {
            this._value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnknownDistributionMode that = (UnknownDistributionMode)o;
            return this._value.equals(that._value);
        }

        public int hashCode() {
            return this._value.hashCode();
        }

        public String toString() {
            return this._value.toString();
        }
    }

    private static class UnknownTxnCapability
    implements TxnCapability {
        private final Symbol _value;

        public UnknownTxnCapability(Symbol value) {
            this._value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnknownTxnCapability that = (UnknownTxnCapability)o;
            return this._value.equals(that._value);
        }

        public int hashCode() {
            return this._value.hashCode();
        }

        public String toString() {
            return this._value.toString();
        }
    }

    private static final class UnknownErrorCondition
    implements ErrorCondition {
        private final Symbol _value;

        public UnknownErrorCondition(Symbol value) {
            this._value = value;
        }

        @Override
        public Symbol getValue() {
            return this._value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnknownErrorCondition that = (UnknownErrorCondition)o;
            return this._value.equals(that._value);
        }

        public int hashCode() {
            return this._value.hashCode();
        }

        public String toString() {
            return this._value.toString();
        }
    }
}

