/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.service;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.websocket.DeploymentException;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.web.JettyRequestLogFactory;
import org.apache.pulsar.broker.web.JsonMapperProvider;
import org.apache.pulsar.broker.web.WebExecutorThreadPool;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.util.ExecutorProvider;
import org.apache.pulsar.common.util.DefaultPulsarSslFactory;
import org.apache.pulsar.common.util.PulsarSslConfiguration;
import org.apache.pulsar.common.util.PulsarSslFactory;
import org.apache.pulsar.jetty.tls.JettySslContextFactory;
import org.apache.pulsar.websocket.service.WebSocketProxyConfiguration;
import org.eclipse.jetty.server.AbstractNetworkConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ConnectionLimit;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.ProxyConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.QoSFilter;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServer {
    private static final String MATCH_ALL = "/*";
    private final Server server;
    private final List<Handler> handlers = new ArrayList<Handler>();
    private final WebSocketProxyConfiguration conf;
    private final WebExecutorThreadPool executorService;
    private final FilterHolder qualityOfServiceFilterHolder;
    private ServerConnector connector;
    private ServerConnector connectorTls;
    private PulsarSslFactory sslFactory;
    private ScheduledExecutorService scheduledExecutorService;
    private static final Logger log = LoggerFactory.getLogger(ProxyServer.class);

    public ProxyServer(WebSocketProxyConfiguration config) throws PulsarClientException, MalformedURLException, PulsarServerException {
        this.conf = config;
        this.executorService = new WebExecutorThreadPool(config.getNumHttpServerThreads(), "pulsar-websocket-web", config.getHttpServerThreadPoolQueueSize());
        this.server = new Server((ThreadPool)this.executorService);
        if (config.getMaxHttpServerConnections() > 0) {
            this.server.addBean((Object)new ConnectionLimit(config.getMaxHttpServerConnections(), this.server));
        }
        HttpConfiguration httpConfig = new HttpConfiguration();
        if (config.isWebServiceTrustXForwardedFor()) {
            httpConfig.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        }
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfig);
        ArrayList<ServerConnector> connectors = new ArrayList<ServerConnector>();
        if (config.getWebServicePort().isPresent()) {
            ArrayList<Object> connectionFactories = new ArrayList<Object>();
            if (config.isWebServiceHaProxyProtocolEnabled()) {
                connectionFactories.add(new ProxyConnectionFactory());
            }
            connectionFactories.add(httpConnectionFactory);
            this.connector = new ServerConnector(this.server, connectionFactories.toArray(new ConnectionFactory[0]));
            this.connector.setPort(config.getWebServicePort().get().intValue());
            connectors.add(this.connector);
        }
        if (config.getWebServicePortTls().isPresent()) {
            try {
                PulsarSslConfiguration sslConfiguration = this.buildSslConfiguration(config);
                this.sslFactory = new DefaultPulsarSslFactory();
                this.sslFactory.initialize(sslConfiguration);
                this.sslFactory.createInternalSslContext();
                this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ExecutorProvider.ExtendedThreadFactory("proxy-websocket-ssl-refresh"));
                if (config.getTlsCertRefreshCheckDurationSec() > 0L) {
                    this.scheduledExecutorService.scheduleWithFixedDelay(this::refreshSslContext, config.getTlsCertRefreshCheckDurationSec(), config.getTlsCertRefreshCheckDurationSec(), TimeUnit.SECONDS);
                }
                SslContextFactory.Server sslCtxFactory = JettySslContextFactory.createSslContextFactory((String)config.getTlsProvider(), (PulsarSslFactory)this.sslFactory, (boolean)config.isTlsRequireTrustedClientCertOnConnect(), config.getWebServiceTlsCiphers(), config.getWebServiceTlsProtocols());
                ArrayList<Object> connectionFactories = new ArrayList<Object>();
                if (config.isWebServiceHaProxyProtocolEnabled()) {
                    connectionFactories.add(new ProxyConnectionFactory());
                }
                connectionFactories.add(new SslConnectionFactory((SslContextFactory)sslCtxFactory, httpConnectionFactory.getProtocol()));
                connectionFactories.add(httpConnectionFactory);
                if (httpConfig.getCustomizer(SecureRequestCustomizer.class) == null) {
                    httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                }
                this.connectorTls = new ServerConnector(this.server, connectionFactories.toArray(new ConnectionFactory[0]));
                this.connectorTls.setPort(config.getWebServicePortTls().get().intValue());
                connectors.add(this.connectorTls);
            }
            catch (Exception e) {
                throw new PulsarServerException((Throwable)e);
            }
        }
        connectors.stream().forEach(c -> c.setAcceptQueueSize(config.getHttpServerAcceptQueueSize()));
        this.server.setConnectors((Connector[])connectors.toArray(new ServerConnector[connectors.size()]));
        if (config.getMaxConcurrentHttpRequests() > 0) {
            this.qualityOfServiceFilterHolder = new FilterHolder(QoSFilter.class);
            this.qualityOfServiceFilterHolder.setInitParameter("maxRequests", String.valueOf(config.getMaxConcurrentHttpRequests()));
        } else {
            this.qualityOfServiceFilterHolder = null;
        }
    }

    public void addWebSocketServlet(String basePath, Servlet socketServlet) throws ServletException, DeploymentException {
        ServletHolder servletHolder = new ServletHolder("ws-events", socketServlet);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(basePath);
        context.addServlet(servletHolder, MATCH_ALL);
        this.addQosFilterIfNeeded(context);
        this.handlers.add((Handler)context);
    }

    public void addRestResource(String basePath, String attribute, Object attributeValue, Class<?> resourceClass) {
        ResourceConfig config = new ResourceConfig();
        config.register(resourceClass);
        config.register(JsonMapperProvider.class);
        ServletHolder servletHolder = new ServletHolder((Servlet)new ServletContainer(config));
        servletHolder.setAsyncSupported(true);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(basePath);
        context.addServlet(servletHolder, MATCH_ALL);
        context.setAttribute(attribute, attributeValue);
        this.addQosFilterIfNeeded(context);
        this.handlers.add((Handler)context);
    }

    private void addQosFilterIfNeeded(ServletContextHandler context) {
        if (this.qualityOfServiceFilterHolder != null) {
            context.addFilter(this.qualityOfServiceFilterHolder, MATCH_ALL, EnumSet.allOf(DispatcherType.class));
        }
    }

    public void start() throws PulsarServerException {
        log.info("Starting web socket proxy at port {}", (Object)Arrays.stream(this.server.getConnectors()).map(ServerConnector.class::cast).map(AbstractNetworkConnector::getPort).map(Object::toString).collect(Collectors.joining(",")));
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        boolean showDetailedAddresses = this.conf.getWebServiceLogDetailedAddresses() != null ? this.conf.getWebServiceLogDetailedAddresses() : this.conf.isWebServiceHaProxyProtocolEnabled() || this.conf.isWebServiceTrustXForwardedFor();
        requestLogHandler.setRequestLog(JettyRequestLogFactory.createRequestLogger((boolean)showDetailedAddresses, (Server)this.server));
        this.handlers.add(0, (Handler)new ContextHandlerCollection());
        this.handlers.add((Handler)requestLogHandler);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(this.handlers.toArray(new Handler[this.handlers.size()]));
        HandlerCollection handlerCollection = new HandlerCollection();
        handlerCollection.setHandlers(new Handler[]{contexts, new DefaultHandler(), requestLogHandler});
        this.server.setHandler((Handler)handlerCollection);
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new PulsarServerException((Throwable)e);
        }
    }

    public void stop() throws Exception {
        this.server.stop();
        this.executorService.stop();
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
        }
    }

    public Optional<Integer> getListenPortHTTP() {
        if (this.connector != null) {
            return Optional.of(this.connector.getLocalPort());
        }
        return Optional.empty();
    }

    public Optional<Integer> getListenPortHTTPS() {
        if (this.connectorTls != null) {
            return Optional.of(this.connectorTls.getLocalPort());
        }
        return Optional.empty();
    }

    protected PulsarSslConfiguration buildSslConfiguration(WebSocketProxyConfiguration config) {
        return PulsarSslConfiguration.builder().tlsKeyStoreType(config.getTlsKeyStoreType()).tlsKeyStorePath(config.getTlsKeyStore()).tlsKeyStorePassword(config.getTlsKeyStorePassword()).tlsTrustStoreType(config.getTlsTrustStoreType()).tlsTrustStorePath(config.getTlsTrustStore()).tlsTrustStorePassword(config.getTlsTrustStorePassword()).tlsCiphers(config.getWebServiceTlsCiphers()).tlsProtocols(config.getWebServiceTlsProtocols()).tlsTrustCertsFilePath(config.getTlsTrustCertsFilePath()).tlsCertificateFilePath(config.getTlsCertificateFilePath()).tlsKeyFilePath(config.getTlsKeyFilePath()).allowInsecureConnection(config.isTlsAllowInsecureConnection()).requireTrustedClientCertOnConnect(config.isTlsRequireTrustedClientCertOnConnect()).tlsEnabledWithKeystore(config.isTlsEnabledWithKeyStore()).serverMode(true).isHttps(true).build();
    }

    protected void refreshSslContext() {
        try {
            this.sslFactory.update();
        }
        catch (Exception e) {
            log.error("Failed to refresh SSL context", (Throwable)e);
        }
    }
}

