/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PublishedDataItemsDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 15583;
  }

  // Properties.
  protected final List<PublishedVariableDataType> publishedData;

  public PublishedDataItemsDataType(List<PublishedVariableDataType> publishedData) {
    super();
    this.publishedData = publishedData;
  }

  public List<PublishedVariableDataType> getPublishedData() {
    return publishedData;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PublishedDataItemsDataType");

    // Implicit Field (noOfPublishedData) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfPublishedData =
        (int) ((((getPublishedData()) == (null)) ? -(1) : COUNT(getPublishedData())));
    writeImplicitField("noOfPublishedData", noOfPublishedData, writeSignedInt(writeBuffer, 32));

    // Array Field (publishedData)
    writeComplexTypeArrayField("publishedData", publishedData, writeBuffer);

    writeBuffer.popContext("PublishedDataItemsDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    PublishedDataItemsDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Implicit Field (noOfPublishedData)
    lengthInBits += 32;

    // Array field
    if (publishedData != null) {
      int i = 0;
      for (PublishedVariableDataType element : publishedData) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= publishedData.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("PublishedDataItemsDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int noOfPublishedData = readImplicitField("noOfPublishedData", readSignedInt(readBuffer, 32));

    List<PublishedVariableDataType> publishedData =
        readCountArrayField(
            "publishedData",
            readComplex(
                () ->
                    (PublishedVariableDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (14275)),
                readBuffer),
            noOfPublishedData);

    readBuffer.closeContext("PublishedDataItemsDataType");
    // Create the instance
    return new PublishedDataItemsDataTypeBuilderImpl(publishedData);
  }

  public static class PublishedDataItemsDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final List<PublishedVariableDataType> publishedData;

    public PublishedDataItemsDataTypeBuilderImpl(List<PublishedVariableDataType> publishedData) {
      this.publishedData = publishedData;
    }

    public PublishedDataItemsDataType build() {
      PublishedDataItemsDataType publishedDataItemsDataType =
          new PublishedDataItemsDataType(publishedData);
      return publishedDataItemsDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PublishedDataItemsDataType)) {
      return false;
    }
    PublishedDataItemsDataType that = (PublishedDataItemsDataType) o;
    return (getPublishedData() == that.getPublishedData()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getPublishedData());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
