/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class LogRecord extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 19363;
  }

  // Properties.
  protected final long eventTime;
  protected final int severity;
  protected final NodeId eventType;
  protected final NodeId sourceNode;
  protected final PascalString sourceName;
  protected final LocalizedText message;
  protected final TraceContextDataType traceContext;
  protected final List<NameValuePair> additionalData;

  public LogRecord(
      long eventTime,
      int severity,
      NodeId eventType,
      NodeId sourceNode,
      PascalString sourceName,
      LocalizedText message,
      TraceContextDataType traceContext,
      List<NameValuePair> additionalData) {
    super();
    this.eventTime = eventTime;
    this.severity = severity;
    this.eventType = eventType;
    this.sourceNode = sourceNode;
    this.sourceName = sourceName;
    this.message = message;
    this.traceContext = traceContext;
    this.additionalData = additionalData;
  }

  public long getEventTime() {
    return eventTime;
  }

  public int getSeverity() {
    return severity;
  }

  public NodeId getEventType() {
    return eventType;
  }

  public NodeId getSourceNode() {
    return sourceNode;
  }

  public PascalString getSourceName() {
    return sourceName;
  }

  public LocalizedText getMessage() {
    return message;
  }

  public TraceContextDataType getTraceContext() {
    return traceContext;
  }

  public List<NameValuePair> getAdditionalData() {
    return additionalData;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("LogRecord");

    // Simple Field (eventTime)
    writeSimpleField("eventTime", eventTime, writeSignedLong(writeBuffer, 64));

    // Simple Field (severity)
    writeSimpleField("severity", severity, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (eventType)
    writeSimpleField("eventType", eventType, writeComplex(writeBuffer));

    // Simple Field (sourceNode)
    writeSimpleField("sourceNode", sourceNode, writeComplex(writeBuffer));

    // Simple Field (sourceName)
    writeSimpleField("sourceName", sourceName, writeComplex(writeBuffer));

    // Simple Field (message)
    writeSimpleField("message", message, writeComplex(writeBuffer));

    // Simple Field (traceContext)
    writeSimpleField("traceContext", traceContext, writeComplex(writeBuffer));

    // Implicit Field (noOfAdditionalData) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfAdditionalData =
        (int) ((((getAdditionalData()) == (null)) ? -(1) : COUNT(getAdditionalData())));
    writeImplicitField("noOfAdditionalData", noOfAdditionalData, writeSignedInt(writeBuffer, 32));

    // Array Field (additionalData)
    writeComplexTypeArrayField("additionalData", additionalData, writeBuffer);

    writeBuffer.popContext("LogRecord");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    LogRecord _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (eventTime)
    lengthInBits += 64;

    // Simple field (severity)
    lengthInBits += 16;

    // Simple field (eventType)
    lengthInBits += eventType.getLengthInBits();

    // Simple field (sourceNode)
    lengthInBits += sourceNode.getLengthInBits();

    // Simple field (sourceName)
    lengthInBits += sourceName.getLengthInBits();

    // Simple field (message)
    lengthInBits += message.getLengthInBits();

    // Simple field (traceContext)
    lengthInBits += traceContext.getLengthInBits();

    // Implicit Field (noOfAdditionalData)
    lengthInBits += 32;

    // Array field
    if (additionalData != null) {
      int i = 0;
      for (NameValuePair element : additionalData) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= additionalData.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("LogRecord");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    long eventTime = readSimpleField("eventTime", readSignedLong(readBuffer, 64));

    int severity = readSimpleField("severity", readUnsignedInt(readBuffer, 16));

    NodeId eventType =
        readSimpleField("eventType", readComplex(() -> NodeId.staticParse(readBuffer), readBuffer));

    NodeId sourceNode =
        readSimpleField(
            "sourceNode", readComplex(() -> NodeId.staticParse(readBuffer), readBuffer));

    PascalString sourceName =
        readSimpleField(
            "sourceName", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    LocalizedText message =
        readSimpleField(
            "message", readComplex(() -> LocalizedText.staticParse(readBuffer), readBuffer));

    TraceContextDataType traceContext =
        readSimpleField(
            "traceContext",
            readComplex(
                () ->
                    (TraceContextDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (19749)),
                readBuffer));

    int noOfAdditionalData = readImplicitField("noOfAdditionalData", readSignedInt(readBuffer, 32));

    List<NameValuePair> additionalData =
        readCountArrayField(
            "additionalData",
            readComplex(
                () ->
                    (NameValuePair)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (19750)),
                readBuffer),
            noOfAdditionalData);

    readBuffer.closeContext("LogRecord");
    // Create the instance
    return new LogRecordBuilderImpl(
        eventTime,
        severity,
        eventType,
        sourceNode,
        sourceName,
        message,
        traceContext,
        additionalData);
  }

  public static class LogRecordBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final long eventTime;
    private final int severity;
    private final NodeId eventType;
    private final NodeId sourceNode;
    private final PascalString sourceName;
    private final LocalizedText message;
    private final TraceContextDataType traceContext;
    private final List<NameValuePair> additionalData;

    public LogRecordBuilderImpl(
        long eventTime,
        int severity,
        NodeId eventType,
        NodeId sourceNode,
        PascalString sourceName,
        LocalizedText message,
        TraceContextDataType traceContext,
        List<NameValuePair> additionalData) {
      this.eventTime = eventTime;
      this.severity = severity;
      this.eventType = eventType;
      this.sourceNode = sourceNode;
      this.sourceName = sourceName;
      this.message = message;
      this.traceContext = traceContext;
      this.additionalData = additionalData;
    }

    public LogRecord build() {
      LogRecord logRecord =
          new LogRecord(
              eventTime,
              severity,
              eventType,
              sourceNode,
              sourceName,
              message,
              traceContext,
              additionalData);
      return logRecord;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof LogRecord)) {
      return false;
    }
    LogRecord that = (LogRecord) o;
    return (getEventTime() == that.getEventTime())
        && (getSeverity() == that.getSeverity())
        && (getEventType() == that.getEventType())
        && (getSourceNode() == that.getSourceNode())
        && (getSourceName() == that.getSourceName())
        && (getMessage() == that.getMessage())
        && (getTraceContext() == that.getTraceContext())
        && (getAdditionalData() == that.getAdditionalData())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getEventTime(),
        getSeverity(),
        getEventType(),
        getSourceNode(),
        getSourceName(),
        getMessage(),
        getTraceContext(),
        getAdditionalData());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
