/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class JsonServerEndpointsMessage extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 19317;
  }

  // Properties.
  protected final PascalString messageId;
  protected final PascalString messageType;
  protected final PascalString publisherId;
  protected final long timestamp;
  protected final ApplicationDescription description;
  protected final List<EndpointDescription> endpoints;

  public JsonServerEndpointsMessage(
      PascalString messageId,
      PascalString messageType,
      PascalString publisherId,
      long timestamp,
      ApplicationDescription description,
      List<EndpointDescription> endpoints) {
    super();
    this.messageId = messageId;
    this.messageType = messageType;
    this.publisherId = publisherId;
    this.timestamp = timestamp;
    this.description = description;
    this.endpoints = endpoints;
  }

  public PascalString getMessageId() {
    return messageId;
  }

  public PascalString getMessageType() {
    return messageType;
  }

  public PascalString getPublisherId() {
    return publisherId;
  }

  public long getTimestamp() {
    return timestamp;
  }

  public ApplicationDescription getDescription() {
    return description;
  }

  public List<EndpointDescription> getEndpoints() {
    return endpoints;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("JsonServerEndpointsMessage");

    // Simple Field (messageId)
    writeSimpleField("messageId", messageId, writeComplex(writeBuffer));

    // Simple Field (messageType)
    writeSimpleField("messageType", messageType, writeComplex(writeBuffer));

    // Simple Field (publisherId)
    writeSimpleField("publisherId", publisherId, writeComplex(writeBuffer));

    // Simple Field (timestamp)
    writeSimpleField("timestamp", timestamp, writeSignedLong(writeBuffer, 64));

    // Simple Field (description)
    writeSimpleField("description", description, writeComplex(writeBuffer));

    // Implicit Field (noOfEndpoints) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfEndpoints = (int) ((((getEndpoints()) == (null)) ? -(1) : COUNT(getEndpoints())));
    writeImplicitField("noOfEndpoints", noOfEndpoints, writeSignedInt(writeBuffer, 32));

    // Array Field (endpoints)
    writeComplexTypeArrayField("endpoints", endpoints, writeBuffer);

    writeBuffer.popContext("JsonServerEndpointsMessage");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    JsonServerEndpointsMessage _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (messageId)
    lengthInBits += messageId.getLengthInBits();

    // Simple field (messageType)
    lengthInBits += messageType.getLengthInBits();

    // Simple field (publisherId)
    lengthInBits += publisherId.getLengthInBits();

    // Simple field (timestamp)
    lengthInBits += 64;

    // Simple field (description)
    lengthInBits += description.getLengthInBits();

    // Implicit Field (noOfEndpoints)
    lengthInBits += 32;

    // Array field
    if (endpoints != null) {
      int i = 0;
      for (EndpointDescription element : endpoints) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= endpoints.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("JsonServerEndpointsMessage");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString messageId =
        readSimpleField(
            "messageId", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString messageType =
        readSimpleField(
            "messageType", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString publisherId =
        readSimpleField(
            "publisherId", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    long timestamp = readSimpleField("timestamp", readSignedLong(readBuffer, 64));

    ApplicationDescription description =
        readSimpleField(
            "description",
            readComplex(
                () ->
                    (ApplicationDescription)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (310)),
                readBuffer));

    int noOfEndpoints = readImplicitField("noOfEndpoints", readSignedInt(readBuffer, 32));

    List<EndpointDescription> endpoints =
        readCountArrayField(
            "endpoints",
            readComplex(
                () ->
                    (EndpointDescription)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (314)),
                readBuffer),
            noOfEndpoints);

    readBuffer.closeContext("JsonServerEndpointsMessage");
    // Create the instance
    return new JsonServerEndpointsMessageBuilderImpl(
        messageId, messageType, publisherId, timestamp, description, endpoints);
  }

  public static class JsonServerEndpointsMessageBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString messageId;
    private final PascalString messageType;
    private final PascalString publisherId;
    private final long timestamp;
    private final ApplicationDescription description;
    private final List<EndpointDescription> endpoints;

    public JsonServerEndpointsMessageBuilderImpl(
        PascalString messageId,
        PascalString messageType,
        PascalString publisherId,
        long timestamp,
        ApplicationDescription description,
        List<EndpointDescription> endpoints) {
      this.messageId = messageId;
      this.messageType = messageType;
      this.publisherId = publisherId;
      this.timestamp = timestamp;
      this.description = description;
      this.endpoints = endpoints;
    }

    public JsonServerEndpointsMessage build() {
      JsonServerEndpointsMessage jsonServerEndpointsMessage =
          new JsonServerEndpointsMessage(
              messageId, messageType, publisherId, timestamp, description, endpoints);
      return jsonServerEndpointsMessage;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof JsonServerEndpointsMessage)) {
      return false;
    }
    JsonServerEndpointsMessage that = (JsonServerEndpointsMessage) o;
    return (getMessageId() == that.getMessageId())
        && (getMessageType() == that.getMessageType())
        && (getPublisherId() == that.getPublisherId())
        && (getTimestamp() == that.getTimestamp())
        && (getDescription() == that.getDescription())
        && (getEndpoints() == that.getEndpoints())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getMessageId(),
        getMessageType(),
        getPublisherId(),
        getTimestamp(),
        getDescription(),
        getEndpoints());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
