/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class IdentifyReplyCommand implements Message {

  // Abstract accessors for discriminator values.
  public abstract Attribute getAttribute();

  // Arguments.
  protected final Byte numBytes;

  public IdentifyReplyCommand(Byte numBytes) {
    super();
    this.numBytes = numBytes;
  }

  protected abstract void serializeIdentifyReplyCommandChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("IdentifyReplyCommand");

    // Switch field (Serialize the sub-type)
    serializeIdentifyReplyCommandChild(writeBuffer);

    writeBuffer.popContext("IdentifyReplyCommand");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    IdentifyReplyCommand _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static IdentifyReplyCommand staticParse(
      ReadBuffer readBuffer, Attribute attribute, Byte numBytes) throws ParseException {
    readBuffer.pullContext("IdentifyReplyCommand");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    IdentifyReplyCommandBuilder builder = null;
    if (EvaluationHelper.equals(attribute, Attribute.Manufacturer)) {
      builder =
          IdentifyReplyCommandManufacturer.staticParseIdentifyReplyCommandBuilder(
              readBuffer, attribute, numBytes);
    } else if (EvaluationHelper.equals(attribute, Attribute.Type)) {
      builder =
          IdentifyReplyCommandType.staticParseIdentifyReplyCommandBuilder(
              readBuffer, attribute, numBytes);
    } else if (EvaluationHelper.equals(attribute, Attribute.FirmwareVersion)) {
      builder =
          IdentifyReplyCommandFirmwareVersion.staticParseIdentifyReplyCommandBuilder(
              readBuffer, attribute, numBytes);
    } else if (EvaluationHelper.equals(attribute, Attribute.Summary)) {
      builder =
          IdentifyReplyCommandSummary.staticParseIdentifyReplyCommandBuilder(
              readBuffer, attribute, numBytes);
    } else if (EvaluationHelper.equals(attribute, Attribute.ExtendedDiagnosticSummary)) {
      builder =
          IdentifyReplyCommandExtendedDiagnosticSummary.staticParseIdentifyReplyCommandBuilder(
              readBuffer, attribute, numBytes);
    } else if (EvaluationHelper.equals(attribute, Attribute.NetworkTerminalLevels)) {
      builder =
          IdentifyReplyCommandNetworkTerminalLevels.staticParseIdentifyReplyCommandBuilder(
              readBuffer, attribute, numBytes);
    } else if (EvaluationHelper.equals(attribute, Attribute.TerminalLevel)) {
      builder =
          IdentifyReplyCommandTerminalLevels.staticParseIdentifyReplyCommandBuilder(
              readBuffer, attribute, numBytes);
    } else if (EvaluationHelper.equals(attribute, Attribute.NetworkVoltage)) {
      builder =
          IdentifyReplyCommandNetworkVoltage.staticParseIdentifyReplyCommandBuilder(
              readBuffer, attribute, numBytes);
    } else if (EvaluationHelper.equals(attribute, Attribute.GAVValuesCurrent)) {
      builder =
          IdentifyReplyCommandGAVValuesCurrent.staticParseIdentifyReplyCommandBuilder(
              readBuffer, attribute, numBytes);
    } else if (EvaluationHelper.equals(attribute, Attribute.GAVValuesStored)) {
      builder =
          IdentifyReplyCommandGAVValuesStored.staticParseIdentifyReplyCommandBuilder(
              readBuffer, attribute, numBytes);
    } else if (EvaluationHelper.equals(attribute, Attribute.GAVPhysicalAddresses)) {
      builder =
          IdentifyReplyCommandGAVPhysicalAddresses.staticParseIdentifyReplyCommandBuilder(
              readBuffer, attribute, numBytes);
    } else if (EvaluationHelper.equals(attribute, Attribute.LogicalAssignment)) {
      builder =
          IdentifyReplyCommandLogicalAssignment.staticParseIdentifyReplyCommandBuilder(
              readBuffer, attribute, numBytes);
    } else if (EvaluationHelper.equals(attribute, Attribute.Delays)) {
      builder =
          IdentifyReplyCommandDelays.staticParseIdentifyReplyCommandBuilder(
              readBuffer, attribute, numBytes);
    } else if (EvaluationHelper.equals(attribute, Attribute.MinimumLevels)) {
      builder =
          IdentifyReplyCommandMinimumLevels.staticParseIdentifyReplyCommandBuilder(
              readBuffer, attribute, numBytes);
    } else if (EvaluationHelper.equals(attribute, Attribute.MaximumLevels)) {
      builder =
          IdentifyReplyCommandMaximumLevels.staticParseIdentifyReplyCommandBuilder(
              readBuffer, attribute, numBytes);
    } else if (EvaluationHelper.equals(attribute, Attribute.CurrentSenseLevels)) {
      builder =
          IdentifyReplyCommandCurrentSenseLevels.staticParseIdentifyReplyCommandBuilder(
              readBuffer, attribute, numBytes);
    } else if (EvaluationHelper.equals(attribute, Attribute.OutputUnitSummary)) {
      builder =
          IdentifyReplyCommandOutputUnitSummary.staticParseIdentifyReplyCommandBuilder(
              readBuffer, attribute, numBytes);
    } else if (EvaluationHelper.equals(attribute, Attribute.DSIStatus)) {
      builder =
          IdentifyReplyCommandDSIStatus.staticParseIdentifyReplyCommandBuilder(
              readBuffer, attribute, numBytes);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "attribute="
              + attribute
              + "]");
    }

    readBuffer.closeContext("IdentifyReplyCommand");
    // Create the instance
    IdentifyReplyCommand _identifyReplyCommand = builder.build(numBytes);

    return _identifyReplyCommand;
  }

  public interface IdentifyReplyCommandBuilder {
    IdentifyReplyCommand build(Byte numBytes);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof IdentifyReplyCommand)) {
      return false;
    }
    IdentifyReplyCommand that = (IdentifyReplyCommand) o;
    return true;
  }

  @Override
  public int hashCode() {
    return Objects.hash();
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
