/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ModbusPDUWriteSingleRegisterRequest is the corresponding interface of ModbusPDUWriteSingleRegisterRequest
type ModbusPDUWriteSingleRegisterRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ModbusPDU
	// GetAddress returns Address (property field)
	GetAddress() uint16
	// GetValue returns Value (property field)
	GetValue() uint16
	// IsModbusPDUWriteSingleRegisterRequest is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsModbusPDUWriteSingleRegisterRequest()
	// CreateBuilder creates a ModbusPDUWriteSingleRegisterRequestBuilder
	CreateModbusPDUWriteSingleRegisterRequestBuilder() ModbusPDUWriteSingleRegisterRequestBuilder
}

// _ModbusPDUWriteSingleRegisterRequest is the data-structure of this message
type _ModbusPDUWriteSingleRegisterRequest struct {
	ModbusPDUContract
	Address uint16
	Value   uint16
}

var _ ModbusPDUWriteSingleRegisterRequest = (*_ModbusPDUWriteSingleRegisterRequest)(nil)
var _ ModbusPDURequirements = (*_ModbusPDUWriteSingleRegisterRequest)(nil)

// NewModbusPDUWriteSingleRegisterRequest factory function for _ModbusPDUWriteSingleRegisterRequest
func NewModbusPDUWriteSingleRegisterRequest(address uint16, value uint16) *_ModbusPDUWriteSingleRegisterRequest {
	_result := &_ModbusPDUWriteSingleRegisterRequest{
		ModbusPDUContract: NewModbusPDU(),
		Address:           address,
		Value:             value,
	}
	_result.ModbusPDUContract.(*_ModbusPDU)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ModbusPDUWriteSingleRegisterRequestBuilder is a builder for ModbusPDUWriteSingleRegisterRequest
type ModbusPDUWriteSingleRegisterRequestBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(address uint16, value uint16) ModbusPDUWriteSingleRegisterRequestBuilder
	// WithAddress adds Address (property field)
	WithAddress(uint16) ModbusPDUWriteSingleRegisterRequestBuilder
	// WithValue adds Value (property field)
	WithValue(uint16) ModbusPDUWriteSingleRegisterRequestBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ModbusPDUBuilder
	// Build builds the ModbusPDUWriteSingleRegisterRequest or returns an error if something is wrong
	Build() (ModbusPDUWriteSingleRegisterRequest, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ModbusPDUWriteSingleRegisterRequest
}

// NewModbusPDUWriteSingleRegisterRequestBuilder() creates a ModbusPDUWriteSingleRegisterRequestBuilder
func NewModbusPDUWriteSingleRegisterRequestBuilder() ModbusPDUWriteSingleRegisterRequestBuilder {
	return &_ModbusPDUWriteSingleRegisterRequestBuilder{_ModbusPDUWriteSingleRegisterRequest: new(_ModbusPDUWriteSingleRegisterRequest)}
}

type _ModbusPDUWriteSingleRegisterRequestBuilder struct {
	*_ModbusPDUWriteSingleRegisterRequest

	parentBuilder *_ModbusPDUBuilder

	collectedErr []error
}

var _ (ModbusPDUWriteSingleRegisterRequestBuilder) = (*_ModbusPDUWriteSingleRegisterRequestBuilder)(nil)

func (b *_ModbusPDUWriteSingleRegisterRequestBuilder) setParent(contract ModbusPDUContract) {
	b.ModbusPDUContract = contract
	contract.(*_ModbusPDU)._SubType = b._ModbusPDUWriteSingleRegisterRequest
}

func (b *_ModbusPDUWriteSingleRegisterRequestBuilder) WithMandatoryFields(address uint16, value uint16) ModbusPDUWriteSingleRegisterRequestBuilder {
	return b.WithAddress(address).WithValue(value)
}

func (b *_ModbusPDUWriteSingleRegisterRequestBuilder) WithAddress(address uint16) ModbusPDUWriteSingleRegisterRequestBuilder {
	b.Address = address
	return b
}

func (b *_ModbusPDUWriteSingleRegisterRequestBuilder) WithValue(value uint16) ModbusPDUWriteSingleRegisterRequestBuilder {
	b.Value = value
	return b
}

func (b *_ModbusPDUWriteSingleRegisterRequestBuilder) Build() (ModbusPDUWriteSingleRegisterRequest, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ModbusPDUWriteSingleRegisterRequest.deepCopy(), nil
}

func (b *_ModbusPDUWriteSingleRegisterRequestBuilder) MustBuild() ModbusPDUWriteSingleRegisterRequest {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ModbusPDUWriteSingleRegisterRequestBuilder) Done() ModbusPDUBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewModbusPDUBuilder().(*_ModbusPDUBuilder)
	}
	return b.parentBuilder
}

func (b *_ModbusPDUWriteSingleRegisterRequestBuilder) buildForModbusPDU() (ModbusPDU, error) {
	return b.Build()
}

func (b *_ModbusPDUWriteSingleRegisterRequestBuilder) DeepCopy() any {
	_copy := b.CreateModbusPDUWriteSingleRegisterRequestBuilder().(*_ModbusPDUWriteSingleRegisterRequestBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateModbusPDUWriteSingleRegisterRequestBuilder creates a ModbusPDUWriteSingleRegisterRequestBuilder
func (b *_ModbusPDUWriteSingleRegisterRequest) CreateModbusPDUWriteSingleRegisterRequestBuilder() ModbusPDUWriteSingleRegisterRequestBuilder {
	if b == nil {
		return NewModbusPDUWriteSingleRegisterRequestBuilder()
	}
	return &_ModbusPDUWriteSingleRegisterRequestBuilder{_ModbusPDUWriteSingleRegisterRequest: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ModbusPDUWriteSingleRegisterRequest) GetErrorFlag() bool {
	return bool(false)
}

func (m *_ModbusPDUWriteSingleRegisterRequest) GetFunctionFlag() uint8 {
	return 0x06
}

func (m *_ModbusPDUWriteSingleRegisterRequest) GetResponse() bool {
	return bool(false)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ModbusPDUWriteSingleRegisterRequest) GetParent() ModbusPDUContract {
	return m.ModbusPDUContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ModbusPDUWriteSingleRegisterRequest) GetAddress() uint16 {
	return m.Address
}

func (m *_ModbusPDUWriteSingleRegisterRequest) GetValue() uint16 {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastModbusPDUWriteSingleRegisterRequest(structType any) ModbusPDUWriteSingleRegisterRequest {
	if casted, ok := structType.(ModbusPDUWriteSingleRegisterRequest); ok {
		return casted
	}
	if casted, ok := structType.(*ModbusPDUWriteSingleRegisterRequest); ok {
		return *casted
	}
	return nil
}

func (m *_ModbusPDUWriteSingleRegisterRequest) GetTypeName() string {
	return "ModbusPDUWriteSingleRegisterRequest"
}

func (m *_ModbusPDUWriteSingleRegisterRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ModbusPDUContract.(*_ModbusPDU).getLengthInBits(ctx))

	// Simple field (address)
	lengthInBits += 16

	// Simple field (value)
	lengthInBits += 16

	return lengthInBits
}

func (m *_ModbusPDUWriteSingleRegisterRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ModbusPDUWriteSingleRegisterRequest) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ModbusPDU, response bool) (__modbusPDUWriteSingleRegisterRequest ModbusPDUWriteSingleRegisterRequest, err error) {
	m.ModbusPDUContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ModbusPDUWriteSingleRegisterRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ModbusPDUWriteSingleRegisterRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	address, err := ReadSimpleField(ctx, "address", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'address' field"))
	}
	m.Address = address

	value, err := ReadSimpleField(ctx, "value", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("ModbusPDUWriteSingleRegisterRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ModbusPDUWriteSingleRegisterRequest")
	}

	return m, nil
}

func (m *_ModbusPDUWriteSingleRegisterRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ModbusPDUWriteSingleRegisterRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ModbusPDUWriteSingleRegisterRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ModbusPDUWriteSingleRegisterRequest")
		}

		if err := WriteSimpleField[uint16](ctx, "address", m.GetAddress(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'address' field")
		}

		if err := WriteSimpleField[uint16](ctx, "value", m.GetValue(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'value' field")
		}

		if popErr := writeBuffer.PopContext("ModbusPDUWriteSingleRegisterRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ModbusPDUWriteSingleRegisterRequest")
		}
		return nil
	}
	return m.ModbusPDUContract.(*_ModbusPDU).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ModbusPDUWriteSingleRegisterRequest) IsModbusPDUWriteSingleRegisterRequest() {}

func (m *_ModbusPDUWriteSingleRegisterRequest) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ModbusPDUWriteSingleRegisterRequest) deepCopy() *_ModbusPDUWriteSingleRegisterRequest {
	if m == nil {
		return nil
	}
	_ModbusPDUWriteSingleRegisterRequestCopy := &_ModbusPDUWriteSingleRegisterRequest{
		m.ModbusPDUContract.(*_ModbusPDU).deepCopy(),
		m.Address,
		m.Value,
	}
	_ModbusPDUWriteSingleRegisterRequestCopy.ModbusPDUContract.(*_ModbusPDU)._SubType = m
	return _ModbusPDUWriteSingleRegisterRequestCopy
}

func (m *_ModbusPDUWriteSingleRegisterRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
