/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// TDataIndividualReq is the corresponding interface of TDataIndividualReq
type TDataIndividualReq interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	CEMI
	// IsTDataIndividualReq is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsTDataIndividualReq()
	// CreateBuilder creates a TDataIndividualReqBuilder
	CreateTDataIndividualReqBuilder() TDataIndividualReqBuilder
}

// _TDataIndividualReq is the data-structure of this message
type _TDataIndividualReq struct {
	CEMIContract
}

var _ TDataIndividualReq = (*_TDataIndividualReq)(nil)
var _ CEMIRequirements = (*_TDataIndividualReq)(nil)

// NewTDataIndividualReq factory function for _TDataIndividualReq
func NewTDataIndividualReq(size uint16) *_TDataIndividualReq {
	_result := &_TDataIndividualReq{
		CEMIContract: NewCEMI(size),
	}
	_result.CEMIContract.(*_CEMI)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// TDataIndividualReqBuilder is a builder for TDataIndividualReq
type TDataIndividualReqBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() TDataIndividualReqBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() CEMIBuilder
	// Build builds the TDataIndividualReq or returns an error if something is wrong
	Build() (TDataIndividualReq, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() TDataIndividualReq
}

// NewTDataIndividualReqBuilder() creates a TDataIndividualReqBuilder
func NewTDataIndividualReqBuilder() TDataIndividualReqBuilder {
	return &_TDataIndividualReqBuilder{_TDataIndividualReq: new(_TDataIndividualReq)}
}

type _TDataIndividualReqBuilder struct {
	*_TDataIndividualReq

	parentBuilder *_CEMIBuilder

	collectedErr []error
}

var _ (TDataIndividualReqBuilder) = (*_TDataIndividualReqBuilder)(nil)

func (b *_TDataIndividualReqBuilder) setParent(contract CEMIContract) {
	b.CEMIContract = contract
	contract.(*_CEMI)._SubType = b._TDataIndividualReq
}

func (b *_TDataIndividualReqBuilder) WithMandatoryFields() TDataIndividualReqBuilder {
	return b
}

func (b *_TDataIndividualReqBuilder) Build() (TDataIndividualReq, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._TDataIndividualReq.deepCopy(), nil
}

func (b *_TDataIndividualReqBuilder) MustBuild() TDataIndividualReq {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_TDataIndividualReqBuilder) Done() CEMIBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewCEMIBuilder().(*_CEMIBuilder)
	}
	return b.parentBuilder
}

func (b *_TDataIndividualReqBuilder) buildForCEMI() (CEMI, error) {
	return b.Build()
}

func (b *_TDataIndividualReqBuilder) DeepCopy() any {
	_copy := b.CreateTDataIndividualReqBuilder().(*_TDataIndividualReqBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateTDataIndividualReqBuilder creates a TDataIndividualReqBuilder
func (b *_TDataIndividualReq) CreateTDataIndividualReqBuilder() TDataIndividualReqBuilder {
	if b == nil {
		return NewTDataIndividualReqBuilder()
	}
	return &_TDataIndividualReqBuilder{_TDataIndividualReq: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_TDataIndividualReq) GetMessageCode() uint8 {
	return 0x4A
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_TDataIndividualReq) GetParent() CEMIContract {
	return m.CEMIContract
}

// Deprecated: use the interface for direct cast
func CastTDataIndividualReq(structType any) TDataIndividualReq {
	if casted, ok := structType.(TDataIndividualReq); ok {
		return casted
	}
	if casted, ok := structType.(*TDataIndividualReq); ok {
		return *casted
	}
	return nil
}

func (m *_TDataIndividualReq) GetTypeName() string {
	return "TDataIndividualReq"
}

func (m *_TDataIndividualReq) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.CEMIContract.(*_CEMI).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_TDataIndividualReq) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_TDataIndividualReq) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_CEMI, size uint16) (__tDataIndividualReq TDataIndividualReq, err error) {
	m.CEMIContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("TDataIndividualReq"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for TDataIndividualReq")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("TDataIndividualReq"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for TDataIndividualReq")
	}

	return m, nil
}

func (m *_TDataIndividualReq) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_TDataIndividualReq) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("TDataIndividualReq"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for TDataIndividualReq")
		}

		if popErr := writeBuffer.PopContext("TDataIndividualReq"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for TDataIndividualReq")
		}
		return nil
	}
	return m.CEMIContract.(*_CEMI).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_TDataIndividualReq) IsTDataIndividualReq() {}

func (m *_TDataIndividualReq) DeepCopy() any {
	return m.deepCopy()
}

func (m *_TDataIndividualReq) deepCopy() *_TDataIndividualReq {
	if m == nil {
		return nil
	}
	_TDataIndividualReqCopy := &_TDataIndividualReq{
		m.CEMIContract.(*_CEMI).deepCopy(),
	}
	_TDataIndividualReqCopy.CEMIContract.(*_CEMI)._SubType = m
	return _TDataIndividualReqCopy
}

func (m *_TDataIndividualReq) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
