/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataBinaryOutputFeedbackValue is the corresponding interface of BACnetConstructedDataBinaryOutputFeedbackValue
type BACnetConstructedDataBinaryOutputFeedbackValue interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetFeedbackValue returns FeedbackValue (property field)
	GetFeedbackValue() BACnetBinaryPVTagged
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetBinaryPVTagged
	// IsBACnetConstructedDataBinaryOutputFeedbackValue is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataBinaryOutputFeedbackValue()
	// CreateBuilder creates a BACnetConstructedDataBinaryOutputFeedbackValueBuilder
	CreateBACnetConstructedDataBinaryOutputFeedbackValueBuilder() BACnetConstructedDataBinaryOutputFeedbackValueBuilder
}

// _BACnetConstructedDataBinaryOutputFeedbackValue is the data-structure of this message
type _BACnetConstructedDataBinaryOutputFeedbackValue struct {
	BACnetConstructedDataContract
	FeedbackValue BACnetBinaryPVTagged
}

var _ BACnetConstructedDataBinaryOutputFeedbackValue = (*_BACnetConstructedDataBinaryOutputFeedbackValue)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataBinaryOutputFeedbackValue)(nil)

// NewBACnetConstructedDataBinaryOutputFeedbackValue factory function for _BACnetConstructedDataBinaryOutputFeedbackValue
func NewBACnetConstructedDataBinaryOutputFeedbackValue(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, feedbackValue BACnetBinaryPVTagged, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataBinaryOutputFeedbackValue {
	if feedbackValue == nil {
		panic("feedbackValue of type BACnetBinaryPVTagged for BACnetConstructedDataBinaryOutputFeedbackValue must not be nil")
	}
	_result := &_BACnetConstructedDataBinaryOutputFeedbackValue{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		FeedbackValue:                 feedbackValue,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataBinaryOutputFeedbackValueBuilder is a builder for BACnetConstructedDataBinaryOutputFeedbackValue
type BACnetConstructedDataBinaryOutputFeedbackValueBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(feedbackValue BACnetBinaryPVTagged) BACnetConstructedDataBinaryOutputFeedbackValueBuilder
	// WithFeedbackValue adds FeedbackValue (property field)
	WithFeedbackValue(BACnetBinaryPVTagged) BACnetConstructedDataBinaryOutputFeedbackValueBuilder
	// WithFeedbackValueBuilder adds FeedbackValue (property field) which is build by the builder
	WithFeedbackValueBuilder(func(BACnetBinaryPVTaggedBuilder) BACnetBinaryPVTaggedBuilder) BACnetConstructedDataBinaryOutputFeedbackValueBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataBinaryOutputFeedbackValue or returns an error if something is wrong
	Build() (BACnetConstructedDataBinaryOutputFeedbackValue, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataBinaryOutputFeedbackValue
}

// NewBACnetConstructedDataBinaryOutputFeedbackValueBuilder() creates a BACnetConstructedDataBinaryOutputFeedbackValueBuilder
func NewBACnetConstructedDataBinaryOutputFeedbackValueBuilder() BACnetConstructedDataBinaryOutputFeedbackValueBuilder {
	return &_BACnetConstructedDataBinaryOutputFeedbackValueBuilder{_BACnetConstructedDataBinaryOutputFeedbackValue: new(_BACnetConstructedDataBinaryOutputFeedbackValue)}
}

type _BACnetConstructedDataBinaryOutputFeedbackValueBuilder struct {
	*_BACnetConstructedDataBinaryOutputFeedbackValue

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataBinaryOutputFeedbackValueBuilder) = (*_BACnetConstructedDataBinaryOutputFeedbackValueBuilder)(nil)

func (b *_BACnetConstructedDataBinaryOutputFeedbackValueBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataBinaryOutputFeedbackValue
}

func (b *_BACnetConstructedDataBinaryOutputFeedbackValueBuilder) WithMandatoryFields(feedbackValue BACnetBinaryPVTagged) BACnetConstructedDataBinaryOutputFeedbackValueBuilder {
	return b.WithFeedbackValue(feedbackValue)
}

func (b *_BACnetConstructedDataBinaryOutputFeedbackValueBuilder) WithFeedbackValue(feedbackValue BACnetBinaryPVTagged) BACnetConstructedDataBinaryOutputFeedbackValueBuilder {
	b.FeedbackValue = feedbackValue
	return b
}

func (b *_BACnetConstructedDataBinaryOutputFeedbackValueBuilder) WithFeedbackValueBuilder(builderSupplier func(BACnetBinaryPVTaggedBuilder) BACnetBinaryPVTaggedBuilder) BACnetConstructedDataBinaryOutputFeedbackValueBuilder {
	builder := builderSupplier(b.FeedbackValue.CreateBACnetBinaryPVTaggedBuilder())
	var err error
	b.FeedbackValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetBinaryPVTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataBinaryOutputFeedbackValueBuilder) Build() (BACnetConstructedDataBinaryOutputFeedbackValue, error) {
	if b.FeedbackValue == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'feedbackValue' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataBinaryOutputFeedbackValue.deepCopy(), nil
}

func (b *_BACnetConstructedDataBinaryOutputFeedbackValueBuilder) MustBuild() BACnetConstructedDataBinaryOutputFeedbackValue {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataBinaryOutputFeedbackValueBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataBinaryOutputFeedbackValueBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataBinaryOutputFeedbackValueBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataBinaryOutputFeedbackValueBuilder().(*_BACnetConstructedDataBinaryOutputFeedbackValueBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataBinaryOutputFeedbackValueBuilder creates a BACnetConstructedDataBinaryOutputFeedbackValueBuilder
func (b *_BACnetConstructedDataBinaryOutputFeedbackValue) CreateBACnetConstructedDataBinaryOutputFeedbackValueBuilder() BACnetConstructedDataBinaryOutputFeedbackValueBuilder {
	if b == nil {
		return NewBACnetConstructedDataBinaryOutputFeedbackValueBuilder()
	}
	return &_BACnetConstructedDataBinaryOutputFeedbackValueBuilder{_BACnetConstructedDataBinaryOutputFeedbackValue: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataBinaryOutputFeedbackValue) GetObjectTypeArgument() BACnetObjectType {
	return BACnetObjectType_BINARY_OUTPUT
}

func (m *_BACnetConstructedDataBinaryOutputFeedbackValue) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_FEEDBACK_VALUE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataBinaryOutputFeedbackValue) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataBinaryOutputFeedbackValue) GetFeedbackValue() BACnetBinaryPVTagged {
	return m.FeedbackValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataBinaryOutputFeedbackValue) GetActualValue() BACnetBinaryPVTagged {
	ctx := context.Background()
	_ = ctx
	return CastBACnetBinaryPVTagged(m.GetFeedbackValue())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataBinaryOutputFeedbackValue(structType any) BACnetConstructedDataBinaryOutputFeedbackValue {
	if casted, ok := structType.(BACnetConstructedDataBinaryOutputFeedbackValue); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataBinaryOutputFeedbackValue); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataBinaryOutputFeedbackValue) GetTypeName() string {
	return "BACnetConstructedDataBinaryOutputFeedbackValue"
}

func (m *_BACnetConstructedDataBinaryOutputFeedbackValue) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (feedbackValue)
	lengthInBits += m.FeedbackValue.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataBinaryOutputFeedbackValue) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataBinaryOutputFeedbackValue) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataBinaryOutputFeedbackValue BACnetConstructedDataBinaryOutputFeedbackValue, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataBinaryOutputFeedbackValue"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataBinaryOutputFeedbackValue")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	feedbackValue, err := ReadSimpleField[BACnetBinaryPVTagged](ctx, "feedbackValue", ReadComplex[BACnetBinaryPVTagged](BACnetBinaryPVTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_APPLICATION_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'feedbackValue' field"))
	}
	m.FeedbackValue = feedbackValue

	actualValue, err := ReadVirtualField[BACnetBinaryPVTagged](ctx, "actualValue", (*BACnetBinaryPVTagged)(nil), feedbackValue)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataBinaryOutputFeedbackValue"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataBinaryOutputFeedbackValue")
	}

	return m, nil
}

func (m *_BACnetConstructedDataBinaryOutputFeedbackValue) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataBinaryOutputFeedbackValue) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataBinaryOutputFeedbackValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataBinaryOutputFeedbackValue")
		}

		if err := WriteSimpleField[BACnetBinaryPVTagged](ctx, "feedbackValue", m.GetFeedbackValue(), WriteComplex[BACnetBinaryPVTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'feedbackValue' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataBinaryOutputFeedbackValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataBinaryOutputFeedbackValue")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataBinaryOutputFeedbackValue) IsBACnetConstructedDataBinaryOutputFeedbackValue() {
}

func (m *_BACnetConstructedDataBinaryOutputFeedbackValue) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataBinaryOutputFeedbackValue) deepCopy() *_BACnetConstructedDataBinaryOutputFeedbackValue {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataBinaryOutputFeedbackValueCopy := &_BACnetConstructedDataBinaryOutputFeedbackValue{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetBinaryPVTagged](m.FeedbackValue),
	}
	_BACnetConstructedDataBinaryOutputFeedbackValueCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataBinaryOutputFeedbackValueCopy
}

func (m *_BACnetConstructedDataBinaryOutputFeedbackValue) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
