/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetActionCommand is the corresponding interface of BACnetActionCommand
type BACnetActionCommand interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetDeviceIdentifier returns DeviceIdentifier (property field)
	GetDeviceIdentifier() BACnetContextTagObjectIdentifier
	// GetObjectIdentifier returns ObjectIdentifier (property field)
	GetObjectIdentifier() BACnetContextTagObjectIdentifier
	// GetPropertyIdentifier returns PropertyIdentifier (property field)
	GetPropertyIdentifier() BACnetPropertyIdentifierTagged
	// GetArrayIndex returns ArrayIndex (property field)
	GetArrayIndex() BACnetContextTagUnsignedInteger
	// GetPropertyValue returns PropertyValue (property field)
	GetPropertyValue() BACnetConstructedData
	// GetPriority returns Priority (property field)
	GetPriority() BACnetContextTagUnsignedInteger
	// GetPostDelay returns PostDelay (property field)
	GetPostDelay() BACnetContextTagBoolean
	// GetQuitOnFailure returns QuitOnFailure (property field)
	GetQuitOnFailure() BACnetContextTagBoolean
	// GetWriteSuccessful returns WriteSuccessful (property field)
	GetWriteSuccessful() BACnetContextTagBoolean
	// IsBACnetActionCommand is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetActionCommand()
	// CreateBuilder creates a BACnetActionCommandBuilder
	CreateBACnetActionCommandBuilder() BACnetActionCommandBuilder
}

// _BACnetActionCommand is the data-structure of this message
type _BACnetActionCommand struct {
	DeviceIdentifier   BACnetContextTagObjectIdentifier
	ObjectIdentifier   BACnetContextTagObjectIdentifier
	PropertyIdentifier BACnetPropertyIdentifierTagged
	ArrayIndex         BACnetContextTagUnsignedInteger
	PropertyValue      BACnetConstructedData
	Priority           BACnetContextTagUnsignedInteger
	PostDelay          BACnetContextTagBoolean
	QuitOnFailure      BACnetContextTagBoolean
	WriteSuccessful    BACnetContextTagBoolean
}

var _ BACnetActionCommand = (*_BACnetActionCommand)(nil)

// NewBACnetActionCommand factory function for _BACnetActionCommand
func NewBACnetActionCommand(deviceIdentifier BACnetContextTagObjectIdentifier, objectIdentifier BACnetContextTagObjectIdentifier, propertyIdentifier BACnetPropertyIdentifierTagged, arrayIndex BACnetContextTagUnsignedInteger, propertyValue BACnetConstructedData, priority BACnetContextTagUnsignedInteger, postDelay BACnetContextTagBoolean, quitOnFailure BACnetContextTagBoolean, writeSuccessful BACnetContextTagBoolean) *_BACnetActionCommand {
	if objectIdentifier == nil {
		panic("objectIdentifier of type BACnetContextTagObjectIdentifier for BACnetActionCommand must not be nil")
	}
	if propertyIdentifier == nil {
		panic("propertyIdentifier of type BACnetPropertyIdentifierTagged for BACnetActionCommand must not be nil")
	}
	if quitOnFailure == nil {
		panic("quitOnFailure of type BACnetContextTagBoolean for BACnetActionCommand must not be nil")
	}
	if writeSuccessful == nil {
		panic("writeSuccessful of type BACnetContextTagBoolean for BACnetActionCommand must not be nil")
	}
	return &_BACnetActionCommand{DeviceIdentifier: deviceIdentifier, ObjectIdentifier: objectIdentifier, PropertyIdentifier: propertyIdentifier, ArrayIndex: arrayIndex, PropertyValue: propertyValue, Priority: priority, PostDelay: postDelay, QuitOnFailure: quitOnFailure, WriteSuccessful: writeSuccessful}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetActionCommandBuilder is a builder for BACnetActionCommand
type BACnetActionCommandBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(objectIdentifier BACnetContextTagObjectIdentifier, propertyIdentifier BACnetPropertyIdentifierTagged, quitOnFailure BACnetContextTagBoolean, writeSuccessful BACnetContextTagBoolean) BACnetActionCommandBuilder
	// WithDeviceIdentifier adds DeviceIdentifier (property field)
	WithOptionalDeviceIdentifier(BACnetContextTagObjectIdentifier) BACnetActionCommandBuilder
	// WithOptionalDeviceIdentifierBuilder adds DeviceIdentifier (property field) which is build by the builder
	WithOptionalDeviceIdentifierBuilder(func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetActionCommandBuilder
	// WithObjectIdentifier adds ObjectIdentifier (property field)
	WithObjectIdentifier(BACnetContextTagObjectIdentifier) BACnetActionCommandBuilder
	// WithObjectIdentifierBuilder adds ObjectIdentifier (property field) which is build by the builder
	WithObjectIdentifierBuilder(func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetActionCommandBuilder
	// WithPropertyIdentifier adds PropertyIdentifier (property field)
	WithPropertyIdentifier(BACnetPropertyIdentifierTagged) BACnetActionCommandBuilder
	// WithPropertyIdentifierBuilder adds PropertyIdentifier (property field) which is build by the builder
	WithPropertyIdentifierBuilder(func(BACnetPropertyIdentifierTaggedBuilder) BACnetPropertyIdentifierTaggedBuilder) BACnetActionCommandBuilder
	// WithArrayIndex adds ArrayIndex (property field)
	WithOptionalArrayIndex(BACnetContextTagUnsignedInteger) BACnetActionCommandBuilder
	// WithOptionalArrayIndexBuilder adds ArrayIndex (property field) which is build by the builder
	WithOptionalArrayIndexBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetActionCommandBuilder
	// WithPropertyValue adds PropertyValue (property field)
	WithOptionalPropertyValue(BACnetConstructedData) BACnetActionCommandBuilder
	// WithOptionalPropertyValueBuilder adds PropertyValue (property field) which is build by the builder
	WithOptionalPropertyValueBuilder(func(BACnetConstructedDataBuilder) BACnetConstructedDataBuilder) BACnetActionCommandBuilder
	// WithPriority adds Priority (property field)
	WithOptionalPriority(BACnetContextTagUnsignedInteger) BACnetActionCommandBuilder
	// WithOptionalPriorityBuilder adds Priority (property field) which is build by the builder
	WithOptionalPriorityBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetActionCommandBuilder
	// WithPostDelay adds PostDelay (property field)
	WithOptionalPostDelay(BACnetContextTagBoolean) BACnetActionCommandBuilder
	// WithOptionalPostDelayBuilder adds PostDelay (property field) which is build by the builder
	WithOptionalPostDelayBuilder(func(BACnetContextTagBooleanBuilder) BACnetContextTagBooleanBuilder) BACnetActionCommandBuilder
	// WithQuitOnFailure adds QuitOnFailure (property field)
	WithQuitOnFailure(BACnetContextTagBoolean) BACnetActionCommandBuilder
	// WithQuitOnFailureBuilder adds QuitOnFailure (property field) which is build by the builder
	WithQuitOnFailureBuilder(func(BACnetContextTagBooleanBuilder) BACnetContextTagBooleanBuilder) BACnetActionCommandBuilder
	// WithWriteSuccessful adds WriteSuccessful (property field)
	WithWriteSuccessful(BACnetContextTagBoolean) BACnetActionCommandBuilder
	// WithWriteSuccessfulBuilder adds WriteSuccessful (property field) which is build by the builder
	WithWriteSuccessfulBuilder(func(BACnetContextTagBooleanBuilder) BACnetContextTagBooleanBuilder) BACnetActionCommandBuilder
	// Build builds the BACnetActionCommand or returns an error if something is wrong
	Build() (BACnetActionCommand, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetActionCommand
}

// NewBACnetActionCommandBuilder() creates a BACnetActionCommandBuilder
func NewBACnetActionCommandBuilder() BACnetActionCommandBuilder {
	return &_BACnetActionCommandBuilder{_BACnetActionCommand: new(_BACnetActionCommand)}
}

type _BACnetActionCommandBuilder struct {
	*_BACnetActionCommand

	collectedErr []error
}

var _ (BACnetActionCommandBuilder) = (*_BACnetActionCommandBuilder)(nil)

func (b *_BACnetActionCommandBuilder) WithMandatoryFields(objectIdentifier BACnetContextTagObjectIdentifier, propertyIdentifier BACnetPropertyIdentifierTagged, quitOnFailure BACnetContextTagBoolean, writeSuccessful BACnetContextTagBoolean) BACnetActionCommandBuilder {
	return b.WithObjectIdentifier(objectIdentifier).WithPropertyIdentifier(propertyIdentifier).WithQuitOnFailure(quitOnFailure).WithWriteSuccessful(writeSuccessful)
}

func (b *_BACnetActionCommandBuilder) WithOptionalDeviceIdentifier(deviceIdentifier BACnetContextTagObjectIdentifier) BACnetActionCommandBuilder {
	b.DeviceIdentifier = deviceIdentifier
	return b
}

func (b *_BACnetActionCommandBuilder) WithOptionalDeviceIdentifierBuilder(builderSupplier func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetActionCommandBuilder {
	builder := builderSupplier(b.DeviceIdentifier.CreateBACnetContextTagObjectIdentifierBuilder())
	var err error
	b.DeviceIdentifier, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_BACnetActionCommandBuilder) WithObjectIdentifier(objectIdentifier BACnetContextTagObjectIdentifier) BACnetActionCommandBuilder {
	b.ObjectIdentifier = objectIdentifier
	return b
}

func (b *_BACnetActionCommandBuilder) WithObjectIdentifierBuilder(builderSupplier func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetActionCommandBuilder {
	builder := builderSupplier(b.ObjectIdentifier.CreateBACnetContextTagObjectIdentifierBuilder())
	var err error
	b.ObjectIdentifier, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_BACnetActionCommandBuilder) WithPropertyIdentifier(propertyIdentifier BACnetPropertyIdentifierTagged) BACnetActionCommandBuilder {
	b.PropertyIdentifier = propertyIdentifier
	return b
}

func (b *_BACnetActionCommandBuilder) WithPropertyIdentifierBuilder(builderSupplier func(BACnetPropertyIdentifierTaggedBuilder) BACnetPropertyIdentifierTaggedBuilder) BACnetActionCommandBuilder {
	builder := builderSupplier(b.PropertyIdentifier.CreateBACnetPropertyIdentifierTaggedBuilder())
	var err error
	b.PropertyIdentifier, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetPropertyIdentifierTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetActionCommandBuilder) WithOptionalArrayIndex(arrayIndex BACnetContextTagUnsignedInteger) BACnetActionCommandBuilder {
	b.ArrayIndex = arrayIndex
	return b
}

func (b *_BACnetActionCommandBuilder) WithOptionalArrayIndexBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetActionCommandBuilder {
	builder := builderSupplier(b.ArrayIndex.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.ArrayIndex, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetActionCommandBuilder) WithOptionalPropertyValue(propertyValue BACnetConstructedData) BACnetActionCommandBuilder {
	b.PropertyValue = propertyValue
	return b
}

func (b *_BACnetActionCommandBuilder) WithOptionalPropertyValueBuilder(builderSupplier func(BACnetConstructedDataBuilder) BACnetConstructedDataBuilder) BACnetActionCommandBuilder {
	builder := builderSupplier(b.PropertyValue.CreateBACnetConstructedDataBuilder())
	var err error
	b.PropertyValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetConstructedDataBuilder failed"))
	}
	return b
}

func (b *_BACnetActionCommandBuilder) WithOptionalPriority(priority BACnetContextTagUnsignedInteger) BACnetActionCommandBuilder {
	b.Priority = priority
	return b
}

func (b *_BACnetActionCommandBuilder) WithOptionalPriorityBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetActionCommandBuilder {
	builder := builderSupplier(b.Priority.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.Priority, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetActionCommandBuilder) WithOptionalPostDelay(postDelay BACnetContextTagBoolean) BACnetActionCommandBuilder {
	b.PostDelay = postDelay
	return b
}

func (b *_BACnetActionCommandBuilder) WithOptionalPostDelayBuilder(builderSupplier func(BACnetContextTagBooleanBuilder) BACnetContextTagBooleanBuilder) BACnetActionCommandBuilder {
	builder := builderSupplier(b.PostDelay.CreateBACnetContextTagBooleanBuilder())
	var err error
	b.PostDelay, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagBooleanBuilder failed"))
	}
	return b
}

func (b *_BACnetActionCommandBuilder) WithQuitOnFailure(quitOnFailure BACnetContextTagBoolean) BACnetActionCommandBuilder {
	b.QuitOnFailure = quitOnFailure
	return b
}

func (b *_BACnetActionCommandBuilder) WithQuitOnFailureBuilder(builderSupplier func(BACnetContextTagBooleanBuilder) BACnetContextTagBooleanBuilder) BACnetActionCommandBuilder {
	builder := builderSupplier(b.QuitOnFailure.CreateBACnetContextTagBooleanBuilder())
	var err error
	b.QuitOnFailure, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagBooleanBuilder failed"))
	}
	return b
}

func (b *_BACnetActionCommandBuilder) WithWriteSuccessful(writeSuccessful BACnetContextTagBoolean) BACnetActionCommandBuilder {
	b.WriteSuccessful = writeSuccessful
	return b
}

func (b *_BACnetActionCommandBuilder) WithWriteSuccessfulBuilder(builderSupplier func(BACnetContextTagBooleanBuilder) BACnetContextTagBooleanBuilder) BACnetActionCommandBuilder {
	builder := builderSupplier(b.WriteSuccessful.CreateBACnetContextTagBooleanBuilder())
	var err error
	b.WriteSuccessful, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagBooleanBuilder failed"))
	}
	return b
}

func (b *_BACnetActionCommandBuilder) Build() (BACnetActionCommand, error) {
	if b.ObjectIdentifier == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'objectIdentifier' not set"))
	}
	if b.PropertyIdentifier == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'propertyIdentifier' not set"))
	}
	if b.QuitOnFailure == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'quitOnFailure' not set"))
	}
	if b.WriteSuccessful == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'writeSuccessful' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetActionCommand.deepCopy(), nil
}

func (b *_BACnetActionCommandBuilder) MustBuild() BACnetActionCommand {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetActionCommandBuilder) DeepCopy() any {
	_copy := b.CreateBACnetActionCommandBuilder().(*_BACnetActionCommandBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetActionCommandBuilder creates a BACnetActionCommandBuilder
func (b *_BACnetActionCommand) CreateBACnetActionCommandBuilder() BACnetActionCommandBuilder {
	if b == nil {
		return NewBACnetActionCommandBuilder()
	}
	return &_BACnetActionCommandBuilder{_BACnetActionCommand: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetActionCommand) GetDeviceIdentifier() BACnetContextTagObjectIdentifier {
	return m.DeviceIdentifier
}

func (m *_BACnetActionCommand) GetObjectIdentifier() BACnetContextTagObjectIdentifier {
	return m.ObjectIdentifier
}

func (m *_BACnetActionCommand) GetPropertyIdentifier() BACnetPropertyIdentifierTagged {
	return m.PropertyIdentifier
}

func (m *_BACnetActionCommand) GetArrayIndex() BACnetContextTagUnsignedInteger {
	return m.ArrayIndex
}

func (m *_BACnetActionCommand) GetPropertyValue() BACnetConstructedData {
	return m.PropertyValue
}

func (m *_BACnetActionCommand) GetPriority() BACnetContextTagUnsignedInteger {
	return m.Priority
}

func (m *_BACnetActionCommand) GetPostDelay() BACnetContextTagBoolean {
	return m.PostDelay
}

func (m *_BACnetActionCommand) GetQuitOnFailure() BACnetContextTagBoolean {
	return m.QuitOnFailure
}

func (m *_BACnetActionCommand) GetWriteSuccessful() BACnetContextTagBoolean {
	return m.WriteSuccessful
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetActionCommand(structType any) BACnetActionCommand {
	if casted, ok := structType.(BACnetActionCommand); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetActionCommand); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetActionCommand) GetTypeName() string {
	return "BACnetActionCommand"
}

func (m *_BACnetActionCommand) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Optional Field (deviceIdentifier)
	if m.DeviceIdentifier != nil {
		lengthInBits += m.DeviceIdentifier.GetLengthInBits(ctx)
	}

	// Simple field (objectIdentifier)
	lengthInBits += m.ObjectIdentifier.GetLengthInBits(ctx)

	// Simple field (propertyIdentifier)
	lengthInBits += m.PropertyIdentifier.GetLengthInBits(ctx)

	// Optional Field (arrayIndex)
	if m.ArrayIndex != nil {
		lengthInBits += m.ArrayIndex.GetLengthInBits(ctx)
	}

	// Optional Field (propertyValue)
	if m.PropertyValue != nil {
		lengthInBits += m.PropertyValue.GetLengthInBits(ctx)
	}

	// Optional Field (priority)
	if m.Priority != nil {
		lengthInBits += m.Priority.GetLengthInBits(ctx)
	}

	// Optional Field (postDelay)
	if m.PostDelay != nil {
		lengthInBits += m.PostDelay.GetLengthInBits(ctx)
	}

	// Simple field (quitOnFailure)
	lengthInBits += m.QuitOnFailure.GetLengthInBits(ctx)

	// Simple field (writeSuccessful)
	lengthInBits += m.WriteSuccessful.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetActionCommand) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetActionCommandParse(ctx context.Context, theBytes []byte) (BACnetActionCommand, error) {
	return BACnetActionCommandParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetActionCommandParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetActionCommand, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetActionCommand, error) {
		return BACnetActionCommandParseWithBuffer(ctx, readBuffer)
	}
}

func BACnetActionCommandParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetActionCommand, error) {
	v, err := (&_BACnetActionCommand{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetActionCommand) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetActionCommand BACnetActionCommand, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetActionCommand"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetActionCommand")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	var deviceIdentifier BACnetContextTagObjectIdentifier
	_deviceIdentifier, err := ReadOptionalField[BACnetContextTagObjectIdentifier](ctx, "deviceIdentifier", ReadComplex[BACnetContextTagObjectIdentifier](BACnetContextTagParseWithBufferProducer[BACnetContextTagObjectIdentifier]((uint8)(uint8(0)), (BACnetDataType)(BACnetDataType_BACNET_OBJECT_IDENTIFIER)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'deviceIdentifier' field"))
	}
	if _deviceIdentifier != nil {
		deviceIdentifier = *_deviceIdentifier
		m.DeviceIdentifier = deviceIdentifier
	}

	objectIdentifier, err := ReadSimpleField[BACnetContextTagObjectIdentifier](ctx, "objectIdentifier", ReadComplex[BACnetContextTagObjectIdentifier](BACnetContextTagParseWithBufferProducer[BACnetContextTagObjectIdentifier]((uint8)(uint8(1)), (BACnetDataType)(BACnetDataType_BACNET_OBJECT_IDENTIFIER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'objectIdentifier' field"))
	}
	m.ObjectIdentifier = objectIdentifier

	propertyIdentifier, err := ReadSimpleField[BACnetPropertyIdentifierTagged](ctx, "propertyIdentifier", ReadComplex[BACnetPropertyIdentifierTagged](BACnetPropertyIdentifierTaggedParseWithBufferProducer((uint8)(uint8(2)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'propertyIdentifier' field"))
	}
	m.PropertyIdentifier = propertyIdentifier

	var arrayIndex BACnetContextTagUnsignedInteger
	_arrayIndex, err := ReadOptionalField[BACnetContextTagUnsignedInteger](ctx, "arrayIndex", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(3)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'arrayIndex' field"))
	}
	if _arrayIndex != nil {
		arrayIndex = *_arrayIndex
		m.ArrayIndex = arrayIndex
	}

	var propertyValue BACnetConstructedData
	_propertyValue, err := ReadOptionalField[BACnetConstructedData](ctx, "propertyValue", ReadComplex[BACnetConstructedData](BACnetConstructedDataParseWithBufferProducer[BACnetConstructedData]((uint8)(uint8(4)), (BACnetObjectType)(objectIdentifier.GetObjectType()), (BACnetPropertyIdentifier)(propertyIdentifier.GetValue()), (BACnetTagPayloadUnsignedInteger)((CastBACnetTagPayloadUnsignedInteger(utils.InlineIf(bool((arrayIndex) != (nil)), func() any { return CastBACnetTagPayloadUnsignedInteger((arrayIndex).GetPayload()) }, func() any { return CastBACnetTagPayloadUnsignedInteger(nil) }))))), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'propertyValue' field"))
	}
	if _propertyValue != nil {
		propertyValue = *_propertyValue
		m.PropertyValue = propertyValue
	}

	var priority BACnetContextTagUnsignedInteger
	_priority, err := ReadOptionalField[BACnetContextTagUnsignedInteger](ctx, "priority", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(5)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'priority' field"))
	}
	if _priority != nil {
		priority = *_priority
		m.Priority = priority
	}

	var postDelay BACnetContextTagBoolean
	_postDelay, err := ReadOptionalField[BACnetContextTagBoolean](ctx, "postDelay", ReadComplex[BACnetContextTagBoolean](BACnetContextTagParseWithBufferProducer[BACnetContextTagBoolean]((uint8)(uint8(6)), (BACnetDataType)(BACnetDataType_BOOLEAN)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'postDelay' field"))
	}
	if _postDelay != nil {
		postDelay = *_postDelay
		m.PostDelay = postDelay
	}

	quitOnFailure, err := ReadSimpleField[BACnetContextTagBoolean](ctx, "quitOnFailure", ReadComplex[BACnetContextTagBoolean](BACnetContextTagParseWithBufferProducer[BACnetContextTagBoolean]((uint8)(uint8(7)), (BACnetDataType)(BACnetDataType_BOOLEAN)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'quitOnFailure' field"))
	}
	m.QuitOnFailure = quitOnFailure

	writeSuccessful, err := ReadSimpleField[BACnetContextTagBoolean](ctx, "writeSuccessful", ReadComplex[BACnetContextTagBoolean](BACnetContextTagParseWithBufferProducer[BACnetContextTagBoolean]((uint8)(uint8(8)), (BACnetDataType)(BACnetDataType_BOOLEAN)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'writeSuccessful' field"))
	}
	m.WriteSuccessful = writeSuccessful

	if closeErr := readBuffer.CloseContext("BACnetActionCommand"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetActionCommand")
	}

	return m, nil
}

func (m *_BACnetActionCommand) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetActionCommand) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetActionCommand"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetActionCommand")
	}

	if err := WriteOptionalField[BACnetContextTagObjectIdentifier](ctx, "deviceIdentifier", GetRef(m.GetDeviceIdentifier()), WriteComplex[BACnetContextTagObjectIdentifier](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'deviceIdentifier' field")
	}

	if err := WriteSimpleField[BACnetContextTagObjectIdentifier](ctx, "objectIdentifier", m.GetObjectIdentifier(), WriteComplex[BACnetContextTagObjectIdentifier](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'objectIdentifier' field")
	}

	if err := WriteSimpleField[BACnetPropertyIdentifierTagged](ctx, "propertyIdentifier", m.GetPropertyIdentifier(), WriteComplex[BACnetPropertyIdentifierTagged](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'propertyIdentifier' field")
	}

	if err := WriteOptionalField[BACnetContextTagUnsignedInteger](ctx, "arrayIndex", GetRef(m.GetArrayIndex()), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'arrayIndex' field")
	}

	if err := WriteOptionalField[BACnetConstructedData](ctx, "propertyValue", GetRef(m.GetPropertyValue()), WriteComplex[BACnetConstructedData](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'propertyValue' field")
	}

	if err := WriteOptionalField[BACnetContextTagUnsignedInteger](ctx, "priority", GetRef(m.GetPriority()), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'priority' field")
	}

	if err := WriteOptionalField[BACnetContextTagBoolean](ctx, "postDelay", GetRef(m.GetPostDelay()), WriteComplex[BACnetContextTagBoolean](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'postDelay' field")
	}

	if err := WriteSimpleField[BACnetContextTagBoolean](ctx, "quitOnFailure", m.GetQuitOnFailure(), WriteComplex[BACnetContextTagBoolean](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'quitOnFailure' field")
	}

	if err := WriteSimpleField[BACnetContextTagBoolean](ctx, "writeSuccessful", m.GetWriteSuccessful(), WriteComplex[BACnetContextTagBoolean](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'writeSuccessful' field")
	}

	if popErr := writeBuffer.PopContext("BACnetActionCommand"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetActionCommand")
	}
	return nil
}

func (m *_BACnetActionCommand) IsBACnetActionCommand() {}

func (m *_BACnetActionCommand) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetActionCommand) deepCopy() *_BACnetActionCommand {
	if m == nil {
		return nil
	}
	_BACnetActionCommandCopy := &_BACnetActionCommand{
		utils.DeepCopy[BACnetContextTagObjectIdentifier](m.DeviceIdentifier),
		utils.DeepCopy[BACnetContextTagObjectIdentifier](m.ObjectIdentifier),
		utils.DeepCopy[BACnetPropertyIdentifierTagged](m.PropertyIdentifier),
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.ArrayIndex),
		utils.DeepCopy[BACnetConstructedData](m.PropertyValue),
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.Priority),
		utils.DeepCopy[BACnetContextTagBoolean](m.PostDelay),
		utils.DeepCopy[BACnetContextTagBoolean](m.QuitOnFailure),
		utils.DeepCopy[BACnetContextTagBoolean](m.WriteSuccessful),
	}
	return _BACnetActionCommandCopy
}

func (m *_BACnetActionCommand) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
