/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.frenchtreebank;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import opennlp.tools.formats.frenchtreebank.ConstitDocumentHandler;
import opennlp.tools.parser.Parse;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.XmlUtil;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConstitParseSampleStream
extends FilterObjectStream<byte[], Parse> {
    private final SAXParser saxParser;
    private final List<Parse> parses = new ArrayList<Parse>();

    protected ConstitParseSampleStream(ObjectStream<byte[]> samples) {
        super(samples);
        this.saxParser = XmlUtil.createSaxParser();
    }

    @Override
    public Parse read() throws IOException {
        byte[] xmlbytes;
        if (this.parses.isEmpty() && (xmlbytes = (byte[])this.samples.read()) != null) {
            ArrayList<Parse> producedParses = new ArrayList<Parse>();
            try {
                this.saxParser.parse((InputStream)new ByteArrayInputStream(xmlbytes), (DefaultHandler)new ConstitDocumentHandler(producedParses));
            }
            catch (SAXException e) {
                throw new IOException(e.getMessage(), e);
            }
            this.parses.addAll(producedParses);
        }
        if (this.parses.size() > 0) {
            return this.parses.remove(0);
        }
        return null;
    }
}

