/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room.activities;

import java.io.Serializable;
import java.util.Date;
import org.apache.openmeetings.db.util.ws.RoomMessage;
import org.apache.openmeetings.db.util.ws.TextRoomMessage;

public class Activity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String uid;
    private final Long sender;
    private final String name;
    private final Date created;
    private final Type type;

    public Activity(RoomMessage m, Type type) {
        this(m.getUid(), null, m.getUserId(), m.getName(), type);
    }

    public Activity(TextRoomMessage m, Type type) {
        this(m.getUid(), m.getText(), m.getUserId(), m.getName(), type);
    }

    public Activity(String id, String uid, Long sender, String name, Type type) {
        this.id = id;
        this.uid = uid;
        this.sender = sender;
        this.name = name;
        this.type = type;
        this.created = new Date();
    }

    public String getId() {
        return this.id;
    }

    public String getUid() {
        return this.uid;
    }

    public Long getSender() {
        return this.sender;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Date getCreated() {
        return this.created;
    }

    public static enum Type {
        ROOM_ENTER,
        ROOM_EXIT,
        REQ_RIGHT_MODERATOR(true),
        REQ_RIGHT_PRESENTER(true),
        REQ_RIGHT_WB(true),
        REQ_RIGHT_SHARE(true),
        REQ_RIGHT_REMOTE(true),
        REQ_RIGHT_A(true),
        REQ_RIGHT_AV(true),
        REQ_RIGHT_MUTE_OTHERS(true),
        REQ_RIGHT_HAVE_QUESTION(true);

        private final boolean action;

        private Type() {
            this(false);
        }

        private Type(boolean action) {
            this.action = action;
        }

        public boolean isAction() {
            return this.action;
        }
    }
}

