/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.map.ExtendedMapEntry;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.impl.CachedQueryEntry;
import com.hazelcast.query.impl.getters.Extractors;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class LazyMapEntry<K, V>
extends CachedQueryEntry<K, V>
implements Serializable,
IdentifiedDataSerializable,
ExtendedMapEntry<K, V> {
    private static final long serialVersionUID = 0L;
    private transient long newTtl = -1L;
    private transient boolean modified;
    private transient boolean changeExpiryOnUpdate = true;

    public LazyMapEntry() {
    }

    public LazyMapEntry(Object key, Object value, InternalSerializationService serializationService) {
        this(key, value, serializationService, null);
    }

    public LazyMapEntry(Object key, Object value, InternalSerializationService serializationService, Extractors extractors) {
        this.init(serializationService, key, value, extractors);
    }

    public LazyMapEntry init(InternalSerializationService serializationService, Object key, Object value, Extractors extractors, long ttl, boolean changeExpiryOnUpdate) {
        super.init(serializationService, key, value, extractors);
        this.modified = false;
        this.newTtl = ttl;
        this.changeExpiryOnUpdate = changeExpiryOnUpdate;
        return this;
    }

    public void setValueByInMemoryFormat(InMemoryFormat inMemoryFormat, Object value) {
        if (inMemoryFormat == InMemoryFormat.OBJECT) {
            this.valueObject = value;
            this.valueData = null;
        } else {
            this.valueData = (Data)value;
            this.valueObject = null;
        }
    }

    @Override
    public V setValue(V value) {
        this.modified = true;
        Object oldValue = this.getValue();
        this.valueObject = value;
        this.valueData = null;
        this.changeExpiryOnUpdate = true;
        this.newTtl = -1L;
        return oldValue;
    }

    @Override
    public V setValue(V value, long ttl, TimeUnit ttlUnit) {
        V v = this.setValue(value);
        this.newTtl = ttlUnit.toMillis(ttl);
        return v;
    }

    @Override
    public V setValueWithoutChangingExpiryTime(V value) {
        V v = this.setValue(value);
        this.changeExpiryOnUpdate = false;
        return v;
    }

    public void remove() {
        this.modified = true;
        this.valueObject = null;
        this.valueData = null;
    }

    public boolean hasNullValue() {
        return this.valueObject == null && this.valueData == null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public long getNewTtl() {
        return this.newTtl;
    }

    public boolean isChangeExpiryOnUpdate() {
        return this.changeExpiryOnUpdate;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry e = (Map.Entry)o;
        return Objects.equals(this.getKey(), e.getKey()) && Objects.equals(this.getValue(), e.getValue());
    }

    @Override
    public int hashCode() {
        return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
    }

    public String toString() {
        return this.getKey() + "=" + this.getValue();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.keyObject = in.readObject();
        this.valueObject = in.readObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getKey());
        out.writeObject(this.getValue());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.keyObject = in.readObject();
        this.valueObject = in.readObject();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.getKey());
        out.writeObject(this.getValue());
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 120;
    }
}

