/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.MapUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public final class NameSpaceUtil {
    private NameSpaceUtil() {
    }

    public static <T> Collection<ServiceNamespace> getAllNamespaces(Map<?, T> containers, Predicate<T> containerFilter, Function<T, ObjectNamespace> toNamespace) {
        if (MapUtil.isNullOrEmpty(containers)) {
            return Collections.emptySet();
        }
        Set<ServiceNamespace> collection = Collections.emptySet();
        for (T container : containers.values()) {
            if (!containerFilter.test(container)) continue;
            ObjectNamespace namespace = toNamespace.apply(container);
            if (collection.isEmpty()) {
                collection = new HashSet<ServiceNamespace>(collection);
            }
            collection.add(namespace);
        }
        return collection;
    }
}

