/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.spi.annotation.PrivateApi;
import java.io.IOException;
import java.util.Objects;

public class MerkleTreeConfig
implements IdentifiedDataSerializable,
Versioned {
    private static final int MIN_DEPTH = 2;
    private static final int MAX_DEPTH = 27;
    private static final int DEFAULT_DEPTH = 10;
    private Boolean enabled;
    private int depth = 10;

    public MerkleTreeConfig() {
    }

    public MerkleTreeConfig(MerkleTreeConfig config) {
        Preconditions.checkNotNull(config, "config can't be null");
        this.enabled = config.enabled;
        this.depth = config.depth;
    }

    public String toString() {
        return "MerkleTreeConfig{enabled=" + this.enabled + ", depth=" + this.depth + "}";
    }

    public int getDepth() {
        return this.depth;
    }

    public MerkleTreeConfig setDepth(int depth) {
        if (depth < 2 || depth > 27) {
            throw new IllegalArgumentException("Merkle tree depth " + depth + " is outside of the allowed range 2-27. ");
        }
        this.depth = depth;
        return this;
    }

    @Deprecated
    public boolean isEnabled() {
        return Boolean.TRUE.equals(this.enabled);
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    @PrivateApi
    public boolean isEnabledSet() {
        return this.enabled != null;
    }

    public MerkleTreeConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 50;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        SerializationUtil.writeNullableBoolean(out, this.enabled);
        out.writeInt(this.depth);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.enabled = SerializationUtil.readNullableBoolean(in);
        this.depth = in.readInt();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MerkleTreeConfig)) {
            return false;
        }
        MerkleTreeConfig that = (MerkleTreeConfig)o;
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        return this.depth == that.depth;
    }

    public final int hashCode() {
        int result = Objects.hashCode(this.enabled);
        result = 31 * result + this.depth;
        return result;
    }
}

