/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.kurento.jsonrpc.message.Response;
import org.kurento.jsonrpc.message.ResponseError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JsonRpcResponseDeserializer
implements JsonDeserializer<Response<?>> {
    private static final Logger log = LoggerFactory.getLogger(JsonRpcResponseDeserializer.class);

    JsonRpcResponseDeserializer() {
    }

    public Response<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!(json instanceof JsonObject)) {
            throw new JsonParseException("JonObject expected, found " + json.getClass().getSimpleName());
        }
        JsonObject jObject = (JsonObject)json;
        if (!jObject.has("jsonrpc")) {
            throw new JsonParseException("Invalid JsonRpc response lacking version 'jsonrpc' field");
        }
        if (!jObject.get("jsonrpc").getAsString().equals("2.0")) {
            throw new JsonParseException("Invalid JsonRpc version");
        }
        Integer id = null;
        JsonElement idAsJsonElement = jObject.get("id");
        if (idAsJsonElement != null) {
            try {
                id = idAsJsonElement.getAsInt();
            }
            catch (Exception e) {
                throw new JsonParseException("Invalid format in 'id' field in request " + String.valueOf(json));
            }
        }
        if (jObject.has("error")) {
            return new Response(id, (ResponseError)context.deserialize(jObject.get("error"), ResponseError.class));
        }
        if (jObject.has("result")) {
            ParameterizedType parameterizedType = (ParameterizedType)typeOfT;
            Object deserialize = context.deserialize(jObject.get("result"), parameterizedType.getActualTypeArguments()[0]);
            return new Response<Object>(id, deserialize);
        }
        log.warn("Invalid JsonRpc response: " + String.valueOf(json) + " It lacks a valid 'result' or 'error' field");
        return new Response(id, null);
    }
}

