/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.session;

import java.util.ArrayList;
import java.util.List;

public enum SessionVariable {
    NIFI_CLIENT_PROPS("nifi.props"),
    NIFI_REGISTRY_CLIENT_PROPS("nifi.reg.props");

    private final String variableName;

    private SessionVariable(String variableName) {
        this.variableName = variableName;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public static SessionVariable fromVariableName(String variableName) {
        for (SessionVariable variable : SessionVariable.values()) {
            if (!variable.getVariableName().equals(variableName)) continue;
            return variable;
        }
        return null;
    }

    public static List<String> getAllVariableNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (SessionVariable variable : SessionVariable.values()) {
            names.add(variable.getVariableName());
        }
        return names;
    }
}

