/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.reactive;

import java.net.http.HttpClient;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.JdkHttpClientBuilder;
import org.springframework.boot.http.client.reactive.AbstractClientHttpConnectorBuilder;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorSettings;
import org.springframework.http.client.reactive.JdkClientHttpConnector;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class JdkClientHttpConnectorBuilder
extends AbstractClientHttpConnectorBuilder<JdkClientHttpConnector> {
    private final JdkHttpClientBuilder httpClientBuilder;

    JdkClientHttpConnectorBuilder() {
        this(null, new JdkHttpClientBuilder());
    }

    private JdkClientHttpConnectorBuilder(List<Consumer<JdkClientHttpConnector>> customizers, JdkHttpClientBuilder httpClientBuilder) {
        super(customizers);
        this.httpClientBuilder = httpClientBuilder;
    }

    public JdkClientHttpConnectorBuilder withCustomizer(Consumer<JdkClientHttpConnector> customizer) {
        return new JdkClientHttpConnectorBuilder(this.mergedCustomizers(customizer), this.httpClientBuilder);
    }

    public JdkClientHttpConnectorBuilder withCustomizers(Collection<Consumer<JdkClientHttpConnector>> customizers) {
        return new JdkClientHttpConnectorBuilder(this.mergedCustomizers(customizers), this.httpClientBuilder);
    }

    public JdkClientHttpConnectorBuilder withHttpClientCustomizer(Consumer<HttpClient.Builder> httpClientCustomizer) {
        Assert.notNull(httpClientCustomizer, (String)"'httpClientCustomizer' must not be null");
        return new JdkClientHttpConnectorBuilder(this.getCustomizers(), this.httpClientBuilder.withCustomizer(httpClientCustomizer));
    }

    @Override
    protected JdkClientHttpConnector createClientHttpConnector(ClientHttpConnectorSettings settings) {
        HttpClient httpClient = this.httpClientBuilder.build(this.asHttpClientSettings(settings.withReadTimeout(null)));
        JdkClientHttpConnector connector = new JdkClientHttpConnector(httpClient);
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(settings::readTimeout).to(arg_0 -> ((JdkClientHttpConnector)connector).setReadTimeout(arg_0));
        return connector;
    }

    static class Classes {
        static final String HTTP_CLIENT = "java.net.http.HttpClient";

        Classes() {
        }

        static boolean present(ClassLoader classLoader) {
            return ClassUtils.isPresent((String)HTTP_CLIENT, (ClassLoader)classLoader);
        }
    }
}

