/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.content;

import java.nio.file.Path;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;

public class PathContentSource
implements Content.Source {
    private final Path _path;
    private final Content.Source _source;

    public PathContentSource(Path path) {
        this(path, null);
    }

    public PathContentSource(Path path, ByteBufferPool byteBufferPool) {
        this(path, byteBufferPool instanceof ByteBufferPool.Sized ? (sized = (ByteBufferPool.Sized)byteBufferPool) : new ByteBufferPool.Sized(byteBufferPool));
        ByteBufferPool.Sized sized;
    }

    public PathContentSource(Path path, ByteBufferPool.Sized sizedBufferPool) {
        this._path = path;
        this._source = Content.Source.from(sizedBufferPool, path);
    }

    public Path getPath() {
        return this._path;
    }

    @Override
    public void demand(Runnable demandCallback) {
        this._source.demand(demandCallback);
    }

    @Override
    public void fail(Throwable failure) {
        this._source.fail(failure);
    }

    @Override
    public void fail(Throwable failure, boolean last) {
        this._source.fail(failure, last);
    }

    @Override
    public long getLength() {
        return this._source.getLength();
    }

    @Override
    public Content.Chunk read() {
        return this._source.read();
    }

    @Override
    public boolean rewind() {
        return this._source.rewind();
    }
}

