/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authentication;

public interface IdentityProviderUsage {
    public String getText();

    public AuthType getAuthType();

    public static enum AuthType {
        UNKNOWN(0, "Unknown"),
        BASIC(1, "Basic"),
        BEARER(2, "Bearer"),
        DIGEST(3, "Digest"),
        NEGOTIATE(4, "Negotiate"),
        OAUTH(5, "OAuth"),
        OTHER(99, "Other");

        private final int code;
        private String httpAuthScheme;

        private AuthType(int statusCode, String httpAuthScheme) {
            this.code = statusCode;
            this.httpAuthScheme = httpAuthScheme;
        }

        public int getStatusCode() {
            return this.code;
        }

        public String getHttpAuthScheme() {
            return this.toString();
        }

        public AuthType httpAuthScheme(String httpAuthScheme) {
            if (httpAuthScheme != null) {
                this.httpAuthScheme = httpAuthScheme;
            }
            return this;
        }

        public String toString() {
            return this.httpAuthScheme;
        }

        public static AuthType fromCode(int code) {
            AuthType[] enumTypes;
            for (AuthType s : enumTypes = AuthType.values()) {
                if (s.code != code) continue;
                return s;
            }
            return null;
        }
    }
}

