/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl.pem;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.boot.ssl.pem.PemCertificateParser;
import org.springframework.boot.ssl.pem.PemPrivateKeyParser;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public final class PemContent {
    private static final Pattern PEM_HEADER = Pattern.compile("-+BEGIN\\s+[^-]*-+", 2);
    private static final Pattern PEM_FOOTER = Pattern.compile("-+END\\s+[^-]*-+", 2);
    private final String text;

    private PemContent(String text) {
        this.text = text.lines().map(String::trim).collect(Collectors.joining("\n"));
    }

    public List<X509Certificate> getCertificates() {
        return PemCertificateParser.parse(this.text);
    }

    public PrivateKey getPrivateKey() {
        return this.getPrivateKey(null);
    }

    public PrivateKey getPrivateKey(String password) {
        return PemPrivateKeyParser.parse(this.text, password);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Objects.equals(this.text, ((PemContent)obj).text);
    }

    public int hashCode() {
        return Objects.hash(this.text);
    }

    public String toString() {
        return this.text;
    }

    static PemContent load(String content, ResourceLoader resourceLoader) throws IOException {
        PemContent pemContent;
        block10: {
            if (!StringUtils.hasLength((String)content)) {
                return null;
            }
            if (PemContent.isPresentInText(content)) {
                return new PemContent(content);
            }
            InputStream in = resourceLoader.getResource(content).getInputStream();
            try {
                pemContent = PemContent.load(in);
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | UncheckedIOException ex) {
                    throw new IOException("Error reading certificate or key from file '%s'".formatted(content), ex);
                }
            }
            in.close();
        }
        return pemContent;
    }

    public static PemContent load(Path path) throws IOException {
        Assert.notNull((Object)path, (String)"'path' must not be null");
        try (InputStream in = Files.newInputStream(path, StandardOpenOption.READ);){
            PemContent pemContent = PemContent.load(in);
            return pemContent;
        }
    }

    public static PemContent load(InputStream in) throws IOException {
        return PemContent.of(StreamUtils.copyToString((InputStream)in, (Charset)StandardCharsets.UTF_8));
    }

    public static PemContent of(String text) {
        return text != null ? new PemContent(text) : null;
    }

    public static boolean isPresentInText(String text) {
        return text != null && PEM_HEADER.matcher(text).find() && PEM_FOOTER.matcher(text).find();
    }
}

