/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.generator;

import org.eclipse.jetty.http2.frames.FrameType;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;

public class HeaderGenerator {
    private int maxFrameSize = 16384;
    private final ByteBufferPool bufferPool;
    private final boolean useDirectByteBuffers;

    public HeaderGenerator(ByteBufferPool bufferPool) {
        this(bufferPool, true);
    }

    public HeaderGenerator(ByteBufferPool bufferPool, boolean useDirectByteBuffers) {
        this.bufferPool = bufferPool;
        this.useDirectByteBuffers = useDirectByteBuffers;
    }

    public ByteBufferPool getByteBufferPool() {
        return this.bufferPool;
    }

    public boolean isUseDirectByteBuffers() {
        return this.useDirectByteBuffers;
    }

    public void generate(RetainableByteBuffer.Mutable accumulator, FrameType frameType, int capacity, int length, int flags, int streamId) {
        accumulator.putInt((length & 0xFFFFFF) << 8 | frameType.getType() & 0xFF).put((byte)flags).putInt(streamId);
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }
}

